/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.AbstractParamInterfaceBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IDataSetPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.businessprocess.TextControlBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.factory.TestDataControlFactory;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamText;
import org.eclipse.jubula.client.ui.rcp.widgets.CheckedParamTextContentAssisted;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.widgets.DirectCombo;
import org.eclipse.jubula.tools.internal.utils.IsAliveThread;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;

public abstract class AbstractDataSetPage
extends Page
implements ISelectionListener,
IAdaptable,
DataEventDispatcher.IParamChangedListener,
DataEventDispatcher.IProjectLoadedListener,
DataEventDispatcher.ILanguageChangedListener,
DataEventDispatcher.IDataChangedListener {
    protected static final int DATASET_NUMBER_COLUMNWIDTH = 20;
    protected static final int COLUMN_WIDTH = 70;
    private ComboSelection m_cActiveCombo = new ComboSelection(null, null);
    private IParameterInterfacePO m_paramInterfaceObj;
    private List<DirectCombo> m_propertyCombos;
    private DirectCombo<Locale> m_languageCombo;
    private DirectCombo<Integer> m_dataSetCombo;
    private DirectCombo<IParamDescriptionPO> m_paramCombo;
    private Control m_control;
    private TableViewer m_tableViewer;
    private DSVTableCursor m_tableCursor;
    private Button m_addButton;
    private Button m_insertButton;
    private Button m_deleteButton;
    private ControlEnabler m_controlEnabler;
    private AbstractParamInterfaceBP m_paramBP;
    private IWorkbenchPart m_currentPart;
    private IStructuredSelection m_currentSelection;

    public AbstractDataSetPage(AbstractParamInterfaceBP bp) {
        this.setParamBP(bp);
    }

    public void handleLanguageChanged(Locale locale) {
        if (this.getComboTracker().getCurrentCombo() == this.getLanguageCombo()) {
            this.getLanguageCombo().setSelectedObject((Object)locale);
            this.getLanguageCombo().notifyListeners(13, new Event());
        }
    }

    private ComboSelection getComboTracker() {
        return this.m_cActiveCombo;
    }

    private int getSelectedDataSet() {
        if (this.getComboTracker().getCurrentCombo() != this.getDataSetCombo()) {
            return this.getTableViewer().getTable().getSelectionIndex();
        }
        return this.getDataSetCombo().getSelectionIndex() - 1;
    }

    private void setTableViewer(TableViewer tableViewer) {
        this.m_tableViewer = tableViewer;
    }

    private TableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    private Table getTable() {
        return this.getTableViewer().getTable();
    }

    private void checkComboSelection(TestDataRowAction action, int row) {
        if (this.getComboTracker().getCurrentCombo() == this.getDataSetCombo()) {
            switch (action) {
                case ADDED: {
                    this.getDataSetCombo().setSelectedObject((Object)(this.getDataSetCombo().getItemCount() - 1));
                    break;
                }
                case INSERTED: {
                    this.getDataSetCombo().setSelectedObject((Object)(row + 1));
                    break;
                }
                case DELETED: {
                    if (row - 1 < 0) break;
                    this.getDataSetCombo().setSelectedObject((Object)row);
                    this.getTableViewer().refresh();
                    break;
                }
            }
        }
    }

    private void setDataSetCombo(DirectCombo<Integer> dataSetCombo) {
        this.m_dataSetCombo = dataSetCombo;
    }

    private DirectCombo<Integer> getDataSetCombo() {
        return this.m_dataSetCombo;
    }

    private void setLanguageCombo(DirectCombo<Locale> languageCombo) {
        this.m_languageCombo = languageCombo;
    }

    private DirectCombo<Locale> getLanguageCombo() {
        return this.m_languageCombo;
    }

    public void createControl(Composite parent) {
        Composite topLevelComposite = new Composite(parent, 0);
        topLevelComposite.setData("TEST_COMP_NAME", (Object)"DataSetViewPage");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 2;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        topLevelComposite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        topLevelComposite.setLayoutData((Object)layoutData);
        this.m_control = topLevelComposite;
        Composite buttonComp = new Composite(topLevelComposite, 2048);
        layout = new GridLayout(3, false);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        buttonComp.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        buttonComp.setLayoutData((Object)gridData);
        this.createComboLabels(buttonComp);
        this.createCombos(buttonComp);
        this.initTableViewer(buttonComp);
        this.createButtons(buttonComp);
        Plugin.getHelpSystem().setHelp((Control)this.getTable(), "org.eclipse.jubula.client.ua.help.guidancerDataSetViewContextId");
    }

    private void createComboLabels(Composite parent) {
        Label paramLabel = new Label(parent, 0);
        paramLabel.setText(Messages.DataSetViewParameter);
        paramLabel.setData("TEST_COMP_NAME", (Object)"DataSetView.ParamLabel");
        Label dataSetLabel = new Label(parent, 0);
        dataSetLabel.setText(Messages.DataSetViewDataSet);
        dataSetLabel.setData("TEST_COMP_NAME", (Object)"DataSetView.DataSetLabel");
        Label languageLabel = new Label(parent, 0);
        languageLabel.setText(Messages.DataSetViewLanguage);
        languageLabel.setData("TEST_COMP_NAME", (Object)"DataSetView.DataSetLabel");
    }

    private void createButtons(Composite parent) {
        this.setAddButton(new Button(parent, 0x1000008));
        this.getAddButton().setData("TEST_COMP_NAME", (Object)"DataSetView.AddButton");
        this.getAddButton().setText(Messages.JubulaDataSetViewAppend);
        GridData gridData = new GridData(32);
        gridData.widthHint = 80;
        this.getAddButton().setLayoutData((Object)gridData);
        this.getAddButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getAddButton());
        this.setInsertButton(new Button(parent, 0x1000008));
        this.getInsertButton().setData("TEST_COMP_NAME", (Object)"DataSetView.InsertButton");
        this.getInsertButton().setText(Messages.DataSetViewInsert);
        gridData = new GridData(32);
        gridData.widthHint = 80;
        this.getInsertButton().setLayoutData((Object)gridData);
        this.getInsertButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getInsertButton());
        this.setDeleteButton(new Button(parent, 0x1000008));
        this.getDeleteButton().setData("TEST_COMP_NAME", (Object)"DataSetView.DeleteButton");
        this.getDeleteButton().setText(Messages.JubulaDataSetViewDelete);
        gridData = new GridData(32);
        gridData.widthHint = 80;
        this.getDeleteButton().setLayoutData((Object)gridData);
        this.getDeleteButton().setEnabled(false);
        this.getControlEnabler().addControl((Control)this.getDeleteButton());
        this.addListenerToButtons();
    }

    private void initTableViewer(Composite parent) {
        this.setTableViewer(new TableViewer(parent, 65540));
        Table table = this.getTable();
        table.setData("TEST_COMP_NAME", (Object)"DataSetView.DataTable");
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gridData = new GridData(1808);
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 3;
        table.setLayoutData((Object)gridData);
        this.getTableViewer().setUseHashlookup(true);
        this.getTableViewer().setContentProvider((IContentProvider)new LanguageContentProvider());
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider());
        this.setTableCursor(new DSVTableCursor(this.getTable(), 0));
    }

    private void addListenerToButtons() {
        this.getAddButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.addDataSet();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.ADDED, index);
                AbstractDataSetPage.this.getControlEnabler().selectionChanged(AbstractDataSetPage.this.m_currentPart, (ISelection)AbstractDataSetPage.this.m_currentSelection);
            }
        });
        this.getInsertButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.insertDataSetAtCurrentSelection();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.INSERTED, index);
            }
        });
        this.getDeleteButton().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = AbstractDataSetPage.this.getSelectedDataSet();
                AbstractDataSetPage.this.removeDataSet();
                AbstractDataSetPage.this.checkComboSelection(TestDataRowAction.DELETED, index);
            }
        });
    }

    private void addDataSet() {
        int rowCount = this.getParamInterfaceObj().getDataManager().getDataSetCount();
        this.insertDataSet(rowCount);
        this.fillDataSetCombo();
    }

    private void insertDataSetAtCurrentSelection() {
        int row = this.getSelectedDataSet();
        this.insertDataSet(row);
    }

    private void insertDataSet(int row) {
        ITDManager man;
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        editor.getEditorHelper().requestEditableState();
        if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
            this.getTableViewer().setInput((Object)man);
        }
        if (row > -1) {
            this.getParamBP().addDataSet(this.getParamInterfaceObj(), row);
            this.fillDataSetCombo();
        } else {
            this.addDataSet();
        }
        editor.getEditorHelper().setDirty(true);
        this.getTableViewer().refresh();
        List projLangs = GeneralStorage.getInstance().getProject().getLangHelper().getLanguageList();
        for (Locale locale : projLangs) {
            this.setIsEntrySetComplete(this.getParamInterfaceObj(), locale);
        }
        int rowToSelect = row;
        if (this.getComboTracker().getCurrentCombo() == this.getDataSetCombo()) {
            rowToSelect = 0;
        }
        if (rowToSelect == -1) {
            rowToSelect = this.getTable().getItemCount();
        } else {
            this.getTableCursor().setSelection(rowToSelect, 1);
            this.setFocus();
        }
        this.getTable().setSelection(rowToSelect);
        DataEventDispatcher.getInstance().fireParamChangedListener();
    }

    public Control getControl() {
        return this.m_control;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void setFocus() {
        this.getTable().setFocus();
    }

    private ControlEnabler getControlEnabler() {
        if (this.m_controlEnabler == null) {
            this.m_controlEnabler = new ControlEnabler();
        }
        return this.m_controlEnabler;
    }

    private void setAddButton(Button addButton) {
        this.m_addButton = addButton;
    }

    private Button getAddButton() {
        return this.m_addButton;
    }

    private void setInsertButton(Button insertButton) {
        this.m_insertButton = insertButton;
    }

    private Button getInsertButton() {
        return this.m_insertButton;
    }

    private void setDeleteButton(Button deleteButton) {
        this.m_deleteButton = deleteButton;
    }

    private Button getDeleteButton() {
        return this.m_deleteButton;
    }

    private void clearTableViewer() {
        this.getTable().removeAll();
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.dispose();
            ++n2;
        }
    }

    private String initDataSetColumn() {
        this.clearTableViewer();
        Table table = this.getTable();
        TableColumn dataSetNumberCol = new TableColumn(table, 0);
        dataSetNumberCol.setText(Messages.DataSetViewControllerDataSetNumber);
        dataSetNumberCol.setWidth(20);
        return dataSetNumberCol.getText();
    }

    private String initParameterColumn() {
        this.clearTableViewer();
        Table table = this.getTable();
        TableColumn paramCol = new TableColumn(table, 0);
        paramCol.setText(Messages.DataSetViewParameter);
        paramCol.pack();
        return paramCol.getText();
    }

    private void packTable() {
        Table table = this.getTable();
        TableColumn[] columns = table.getColumns();
        int columnCount = columns.length;
        int i = 1;
        while (i < columnCount) {
            TableColumn column = columns[i];
            column.pack();
            if (column.getWidth() < 70) {
                column.setWidth(70);
            }
            ++i;
        }
    }

    private void setPriorComboSelection() {
        DirectCombo priorCombo = this.getComboTracker().getCurrentCombo();
        for (DirectCombo combo : this.m_propertyCombos) {
            if (combo != priorCombo) continue;
            combo.setSelectedObject(this.getComboTracker().getCurrentSelectedValue(false));
            if (combo.getSelectedObject() != null) break;
            this.getComboTracker().setDefaultComboSelection();
            this.getComboTracker().getCurrentCombo().setSelectedObject(this.getComboTracker().getCurrentSelectedValue(false));
            break;
        }
    }

    private void createCombos(Composite parent) {
        this.m_propertyCombos = new ArrayList<DirectCombo>();
        ArrayList a1 = new ArrayList(0);
        ArrayList a2 = new ArrayList(0);
        this.m_paramCombo = new DirectCombo(parent, 0, a1, a2, true, false);
        this.m_paramCombo.setData("TEST_COMP_NAME", (Object)"DataSetView.ParamCombo");
        this.m_paramCombo.addSelectionListener((SelectionListener)new ParameterComboListener());
        GridData paramComboLayoutData = new GridData();
        paramComboLayoutData.horizontalAlignment = 4;
        paramComboLayoutData.grabExcessHorizontalSpace = true;
        this.m_paramCombo.setLayoutData((Object)paramComboLayoutData);
        this.m_propertyCombos.add(this.m_paramCombo);
        ArrayList b1 = new ArrayList(0);
        ArrayList b2 = new ArrayList(0);
        this.setDataSetCombo((DirectCombo<Integer>)new DirectCombo(parent, 0, b1, b2, true, false));
        this.getDataSetCombo().setData("TEST_COMP_NAME", (Object)"DataSetView.DataSetCombo");
        this.getDataSetCombo().addSelectionListener((SelectionListener)new DataSetComboListener());
        this.getDataSetCombo().setSize(100, this.getDataSetCombo().getItemHeight());
        GridData dataSetComboLayoutData = new GridData();
        dataSetComboLayoutData.horizontalAlignment = 4;
        dataSetComboLayoutData.grabExcessHorizontalSpace = true;
        this.getDataSetCombo().setLayoutData((Object)dataSetComboLayoutData);
        this.m_propertyCombos.add(this.getDataSetCombo());
        ArrayList c1 = new ArrayList(0);
        ArrayList c2 = new ArrayList(0);
        this.setLanguageCombo((DirectCombo<Locale>)new DirectCombo(parent, 0, c1, c2, true, false));
        this.getLanguageCombo().setData("TEST_COMP_NAME", (Object)"DataSetView.LanguageCombo");
        this.getLanguageCombo().addSelectionListener((SelectionListener)new LanguageComboListener());
        this.getLanguageCombo().setSize(100, this.getLanguageCombo().getItemHeight());
        GridData languageComboLayoutData = new GridData();
        languageComboLayoutData.horizontalAlignment = 4;
        languageComboLayoutData.grabExcessHorizontalSpace = true;
        this.getLanguageCombo().setLayoutData((Object)languageComboLayoutData);
        this.m_propertyCombos.add(this.getLanguageCombo());
        ComboSingleSelectionListener comboSelListener = new ComboSingleSelectionListener();
        this.m_paramCombo.addSelectionListener((SelectionListener)comboSelListener);
        this.getDataSetCombo().addSelectionListener((SelectionListener)comboSelListener);
        this.getLanguageCombo().addSelectionListener((SelectionListener)comboSelListener);
    }

    private void initTableViewerParameterColumns() {
        if (this.getParamInterfaceObj() == null) {
            return;
        }
        Table table = this.getTable();
        String[] columnProperties = new String[this.getParamInterfaceObj().getParameterList().size() + 1];
        columnProperties[0] = this.initDataSetColumn();
        int i = 1;
        for (IParamDescriptionPO descr : this.getParamInterfaceObj().getParameterList()) {
            TableColumn column = new TableColumn(table, 0);
            String columnName = descr.getName();
            column.setText(columnName);
            columnProperties[i++] = columnName;
            column.setWidth(70);
        }
        this.getTableViewer().setColumnProperties(columnProperties);
    }

    private void initTableViewerLanguageColumns(boolean dataSetNumbers) {
        if (this.getParamInterfaceObj() == null) {
            return;
        }
        List<Locale> locales = WorkingLanguageBP.getInstance().getDisplayableLanguages();
        String[] columnProperties = new String[locales.size() + 1];
        Table table = this.getTable();
        columnProperties[0] = dataSetNumbers ? this.initDataSetColumn() : this.initParameterColumn();
        int i = 1;
        ArrayList<String> dispList = new ArrayList<String>();
        for (Locale locale : locales) {
            dispList.add(locale.getDisplayName());
        }
        Object[] dispNames = dispList.toArray(new String[dispList.size()]);
        Arrays.sort(dispNames);
        Object[] objectArray = dispNames;
        int n = dispNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object lang = objectArray[n2];
            TableColumn column = new TableColumn(table, 0);
            column.setText((String)lang);
            column.setWidth(70);
            column.setData((Object)Languages.getInstance().getLocale((String)lang));
            columnProperties[i++] = column.getText();
            ++n2;
        }
        this.getTableViewer().setColumnProperties(columnProperties);
    }

    private void updateView() {
        this.clearTableViewer();
        this.fillParamCombo();
        this.fillDataSetCombo();
        this.fillLanguageCombo();
        this.setPriorComboSelection();
        IParameterInterfacePO paramObj = this.getParamInterfaceObj();
        if (paramObj != null && this.isNodeValid(paramObj)) {
            this.getTableViewer().setInput((Object)this.getInputForTable(paramObj));
            this.createTable();
        } else {
            this.getTableViewer().setInput(null);
        }
    }

    protected abstract boolean isNodeValid(IParameterInterfacePO var1);

    private void createTable() {
        DirectCombo combo = this.getComboTracker().getCurrentCombo();
        Object formerValue = this.getComboTracker().getCurrentSelectedValue(true);
        if (combo != null && formerValue != null && formerValue.equals(combo.getSelectedObject())) {
            combo.notifyListeners(13, new Event());
        } else {
            this.initTableViewerParameterColumns();
        }
        this.packTable();
    }

    private void fillParamCombo() {
        List paramList = new ArrayList(0);
        if (this.getParamInterfaceObj() != null) {
            paramList = this.getParamInterfaceObj().getParameterList();
        }
        int listSize = paramList.size();
        ArrayList<String> keys = new ArrayList<String>(listSize);
        ArrayList<IParamDescriptionPO> values = new ArrayList<IParamDescriptionPO>(listSize);
        for (IParamDescriptionPO descr : paramList) {
            keys.add(descr.getName());
            values.add(descr);
        }
        this.m_paramCombo.setItems(values, keys);
        this.m_paramCombo.setSelectedObject(null);
    }

    private void fillLanguageCombo() {
        List<Locale> langList = WorkingLanguageBP.getInstance().getDisplayableLanguages();
        ArrayList<String> dispList = new ArrayList<String>();
        for (Locale locale : langList) {
            dispList.add(locale.getDisplayName());
        }
        Object[] dispNames = dispList.toArray(new String[dispList.size()]);
        Arrays.sort(dispNames);
        int listSize = langList.size();
        ArrayList<Object> keys = new ArrayList<Object>(listSize);
        ArrayList<Locale> values = new ArrayList<Locale>(listSize);
        Object[] objectArray = dispNames;
        int n = dispNames.length;
        int n2 = 0;
        while (n2 < n) {
            Object lang = objectArray[n2];
            values.add(Languages.getInstance().getLocale((String)lang));
            keys.add(lang);
            ++n2;
        }
        this.getLanguageCombo().setItems(values, keys);
    }

    private void fillDataSetCombo() {
        int dataSets = 0;
        IParameterInterfacePO testDataProvider = this.getParamInterfaceObj();
        if (testDataProvider != null) {
            while (testDataProvider.getReferencedDataCube() != null) {
                testDataProvider = testDataProvider.getReferencedDataCube();
            }
            dataSets = testDataProvider.getDataManager().getDataSetCount();
        }
        ArrayList<String> keys = new ArrayList<String>(dataSets);
        ArrayList<Integer> values = new ArrayList<Integer>(dataSets);
        int i = 0;
        while (i < dataSets) {
            int value = i + 1;
            values.add(value);
            keys.add("" + value);
            ++i;
        }
        this.getDataSetCombo().setItems(values, keys);
    }

    public static String getGuiStringForParamValue(IParameterInterfacePO paramObj, IParamDescriptionPO desc, int rowCount, Locale locale) {
        return AbstractParamInterfaceBP.getGuiStringForParamValue((IParameterInterfacePO)paramObj, (IParamDescriptionPO)desc, (int)rowCount, (Locale)locale);
    }

    public void handleParamChanged() {
        this.initTableViewerParameterColumns();
        this.updateView();
    }

    public void handleProjectLoaded() {
        this.setParamInterfaceObj(null);
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataSetPage.this.getTableViewer().setInput(null);
                AbstractDataSetPage.this.getComboTracker().setDefaultComboSelection();
            }
        });
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (dataState == DataEventDispatcher.DataState.Deleted && po.equals(this.getParamInterfaceObj())) {
            this.setParamInterfaceObj(null);
            this.updateView();
        }
        if (dataState == DataEventDispatcher.DataState.StructureModified && po instanceof ITestDataCategoryPO) {
            this.updateView();
        }
        Plugin.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                AbstractDataSetPage.this.getControlEnabler().selectionChanged(AbstractDataSetPage.this.m_currentPart, (ISelection)AbstractDataSetPage.this.m_currentSelection);
            }
        });
    }

    private void removeDataSet() {
        AbstractJBEditor editor = (AbstractJBEditor)this.m_currentPart;
        if (editor == null) {
            return;
        }
        if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
            ITDManager man;
            if (this.getParamInterfaceObj() instanceof IExecTestCasePO && !(man = ((IExecTestCasePO)this.getParamInterfaceObj()).resolveTDReference()).equals(this.getTableViewer().getInput())) {
                this.getTableViewer().setInput((Object)man);
            }
            int row = this.getSelectedDataSet();
            try {
                if (row == -1 && this.getTableCursor().getRow() != null) {
                    row = this.getTable().indexOf(this.getTableCursor().getRow());
                }
                if (row > -1) {
                    editor.getEditorHelper().getEditSupport().lockWorkVersion();
                    this.getParamBP().removeDataSet(this.getParamInterfaceObj(), row, (IParamNameMapper)editor.getEditorHelper().getEditSupport().getParamMapper(), WorkingLanguageBP.getInstance().getWorkingLanguage());
                    editor.getEditorHelper().setDirty(true);
                    this.getTableViewer().refresh();
                    this.fillDataSetCombo();
                    List projLangs = GeneralStorage.getInstance().getProject().getLangHelper().getLanguageList();
                    for (Locale locale : projLangs) {
                        this.setIsEntrySetComplete(this.getParamInterfaceObj(), locale);
                    }
                    if (this.getComboTracker().getCurrentCombo() == this.getDataSetCombo()) {
                        row = 0;
                    }
                    if (this.getTable().getItemCount() != 0) {
                        if (this.getTable().getItemCount() <= row && this.getTable().getItemCount() > 0) {
                            this.getTable().setSelection(--row);
                        } else {
                            this.getTable().setSelection(row);
                        }
                        this.getTableCursor().setSelection(row, 1);
                    } else {
                        this.getDeleteButton().setEnabled(false);
                        this.getInsertButton().setEnabled(false);
                    }
                    this.setFocus();
                    DataEventDispatcher.getInstance().fireParamChangedListener();
                }
            }
            catch (PMException pme) {
                PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
            }
        }
    }

    private void reactOnChange(IWorkbenchPart part, IStructuredSelection selection) {
        this.m_currentPart = part;
        this.m_currentSelection = selection;
        this.getControlEnabler().selectionChanged(part, (ISelection)selection);
        IParameterInterfacePO paramInterfacePO = this.getSelectedParamInterfaceObj(selection);
        if (this.getParamInterfaceObj() != null && this.getParamInterfaceObj() == paramInterfacePO) {
            return;
        }
        this.setParamInterfaceObj(paramInterfacePO);
        this.updateView();
    }

    private IParameterInterfacePO getSelectedParamInterfaceObj(IStructuredSelection selection) {
        IParameterInterfacePO paramInterfacePO = null;
        Object firstSel = selection.getFirstElement();
        if (firstSel instanceof IParameterInterfacePO) {
            paramInterfacePO = (IParameterInterfacePO)firstSel;
        }
        return paramInterfacePO;
    }

    protected abstract void setIsEntrySetComplete(IParameterInterfacePO var1, Locale var2);

    protected abstract boolean isEditorOpen(IParameterInterfacePO var1);

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.reactOnChange(part, (IStructuredSelection)selection);
    }

    private void setParamBP(AbstractParamInterfaceBP paramBP) {
        this.m_paramBP = paramBP;
    }

    private AbstractParamInterfaceBP getParamBP() {
        return this.m_paramBP;
    }

    private void setParamInterfaceObj(IParameterInterfacePO paramInterfaceObj) {
        this.m_paramInterfaceObj = paramInterfaceObj;
    }

    private IParameterInterfacePO getParamInterfaceObj() {
        return this.m_paramInterfaceObj;
    }

    private GuiParamValueConverter getGuiParamValueConverter(String value, IParameterInterfacePO paramInterfaceObj, Locale locale, IParamDescriptionPO currentParamDescription, IParamValueValidator dataValidator) {
        return new GuiParamValueConverter(value, paramInterfaceObj, locale, currentParamDescription, dataValidator);
    }

    protected ITDManager getInputForTable(IParameterInterfacePO paramInterface) {
        return paramInterface.getDataManager();
    }

    private void setTableCursor(DSVTableCursor tableCursor) {
        this.m_tableCursor = tableCursor;
    }

    public DSVTableCursor getTableCursor() {
        return this.m_tableCursor;
    }

    private static abstract class AbstractContentProvider
    implements IStructuredContentProvider {
        private AbstractContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private abstract class AbstractControlEnabler {
        private List<Control> m_controlList = new ArrayList<Control>();
        private boolean m_areControlsEnabled = true;

        private AbstractControlEnabler() {
        }

        public void addControl(Control control) {
            if (!this.getControlList().contains(control)) {
                this.getControlList().add(control);
            }
        }

        protected List<Control> getControlList() {
            return this.m_controlList;
        }

        public void setControlsEnabled(boolean enabled) {
            this.m_areControlsEnabled = enabled;
            for (Control control : this.getControlList()) {
                control.setEnabled(enabled);
            }
        }

        public boolean areControlsEnabled() {
            return this.m_areControlsEnabled;
        }
    }

    private abstract class AbstractLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        private AbstractLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (!AbstractDataSetPage.this.getControlEnabler().areControlsEnabled()) {
                return LayoutUtil.GRAY_COLOR;
            }
            return null;
        }
    }

    private abstract class AbstractSelectionListener
    implements SelectionListener {
        private AbstractSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ComboSelection {
        private DirectCombo m_combo;
        private Object m_value;

        public ComboSelection(DirectCombo combo, Object value) {
            this.m_combo = combo;
            this.m_value = value;
        }

        public DirectCombo getCurrentCombo() {
            if (this.m_combo == null) {
                return this.comboFallback();
            }
            return this.m_combo;
        }

        public Object getCurrentSelectedValue(boolean isDefaultAllowed) {
            if (isDefaultAllowed) {
                if (this.m_value == null) {
                    return this.valueFallback();
                }
                return this.m_value;
            }
            return this.m_value;
        }

        public void setComboSelection(DirectCombo combo) {
            this.m_combo = combo;
            this.m_value = combo.getSelectedObject();
        }

        public void setDefaultComboSelection() {
            this.m_combo = AbstractDataSetPage.this.getLanguageCombo();
            this.m_value = WorkingLanguageBP.getInstance().getWorkingLanguage();
        }

        private Object valueFallback() {
            Locale defaultLocale = WorkingLanguageBP.getInstance().getWorkingLanguage();
            AbstractDataSetPage.this.getLanguageCombo().setSelectedObject((Object)defaultLocale);
            this.setComboSelection(AbstractDataSetPage.this.getLanguageCombo());
            return this.m_value;
        }

        private DirectCombo comboFallback() {
            Locale defaultLocale = null;
            if (GeneralStorage.getInstance().getProject() != null) {
                defaultLocale = GeneralStorage.getInstance().getProject().getDefaultLanguage();
            }
            AbstractDataSetPage.this.getLanguageCombo().setSelectedObject((Object)defaultLocale);
            this.setComboSelection(AbstractDataSetPage.this.getLanguageCombo());
            return AbstractDataSetPage.this.getLanguageCombo();
        }
    }

    private class ComboSingleSelectionListener
    extends AbstractSelectionListener {
        private ComboSingleSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (((DirectCombo)source).getSelectionIndex() == 0) {
                return;
            }
            for (DirectCombo combo : AbstractDataSetPage.this.m_propertyCombos) {
                if (combo == source) continue;
                combo.setSelectedObject(null);
            }
            AbstractDataSetPage.this.getComboTracker().setComboSelection((DirectCombo)source);
        }
    }

    protected class ControlEnabler
    extends AbstractControlEnabler
    implements ISelectionListener {
        protected ControlEnabler() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection strucSelection = (IStructuredSelection)selection;
            IParameterInterfacePO paramNode = AbstractDataSetPage.this.getSelectedParamInterfaceObj(strucSelection);
            boolean correctPart = false;
            if (part != null) {
                boolean bl = correctPart = part == AbstractDataSetPage.this || part.getAdapter(AbstractJBEditor.class) != null;
            }
            if (!correctPart) {
                AbstractDataSetPage.this.getTable().setForeground(LayoutUtil.GRAY_COLOR);
            } else {
                AbstractDataSetPage.this.getTable().setForeground(LayoutUtil.DEFAULT_OS_COLOR);
            }
            boolean hasInput = !strucSelection.isEmpty();
            boolean isEditorOpen = AbstractDataSetPage.this.isEditorOpen(paramNode);
            boolean hasParameter = false;
            boolean hasExcelFile = false;
            boolean hasReferencedDataCube = false;
            if (paramNode != null) {
                hasParameter = !paramNode.getParameterList().isEmpty();
                String dataFile = paramNode.getDataFile();
                hasExcelFile = dataFile != null && dataFile.length() != 0;
                hasReferencedDataCube = paramNode.getReferencedDataCube() != null;
            }
            boolean isCAP = paramNode instanceof ICapPO;
            boolean enable = correctPart && hasInput && isEditorOpen && !isCAP && !hasExcelFile && !hasReferencedDataCube && hasParameter;
            this.setControlsEnabled(enable);
        }
    }

    public class DSVTableCursor
    extends TableCursor {
        private ControlEditor m_editor;
        private AbstractJBEditor m_tcEditor;
        private KeyAdapter m_keyListener;
        private MouseAdapter m_mouseListener;
        private CursorListener m_cursorListener;
        private EditorFocusListener m_focusListener;
        private boolean m_wasActivatedWithEnterKey;
        private String m_oldValue;
        private Listener m_listener;

        public DSVTableCursor(Table parent, int style) {
            super(parent, style);
            this.m_keyListener = new EditorKeyListener();
            this.m_mouseListener = new EditorMouseListener();
            this.m_cursorListener = new CursorListener();
            this.m_focusListener = new EditorFocusListener();
            this.m_wasActivatedWithEnterKey = false;
            this.m_listener = new Listener(){

                public void handleEvent(Event event) {
                    if (event.type == 13 && event.widget instanceof CCombo) {
                        DSVTableCursor.this.writeData();
                    }
                }
            };
            this.addSelectionListener((SelectionListener)this.m_cursorListener);
            this.addMouseListener((MouseListener)this.m_mouseListener);
            this.addKeyListener((KeyListener)this.m_keyListener);
            this.m_editor = new ControlEditor((Composite)this);
            this.m_editor.grabHorizontal = true;
            this.m_editor.grabVertical = true;
        }

        private int getColumnIndexOfProperty(String columnProperty) {
            Object[] props = AbstractDataSetPage.this.getTableViewer().getColumnProperties();
            int i = 0;
            while (i < props.length) {
                if (columnProperty.equals(props[i])) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private void writeData() {
            if (AbstractDataSetPage.this.m_currentPart instanceof AbstractJBEditor) {
                this.m_tcEditor = (AbstractJBEditor)AbstractDataSetPage.this.m_currentPart;
            }
            if (this.m_tcEditor == null) {
                return;
            }
            int column = this.getColumn();
            Control editor = this.m_editor.getEditor();
            if (!TextControlBP.isTextValid(editor)) {
                TextControlBP.setText(this.m_oldValue, editor);
            }
            DirectCombo activeCombo = AbstractDataSetPage.this.getComboTracker().getCurrentCombo();
            String property = AbstractDataSetPage.this.getTableViewer().getColumnProperties()[column].toString();
            String value = TextControlBP.getText(editor);
            if (this.m_oldValue != null && this.m_oldValue.equals(value)) {
                return;
            }
            if (value != null && value.equals("")) {
                value = null;
            }
            if (activeCombo == AbstractDataSetPage.this.getLanguageCombo()) {
                this.writeLanguageData(property, value, this.m_tcEditor);
            } else if (activeCombo == AbstractDataSetPage.this.m_paramCombo) {
                this.writeParamData(property, value, this.m_tcEditor);
            } else if (activeCombo == AbstractDataSetPage.this.getDataSetCombo()) {
                this.writeDataSetData(property, value, this.m_tcEditor);
            }
        }

        private void writeDataSetData(String property, Object value, AbstractJBEditor edit) {
            int langIndex = this.getColumnIndexOfProperty(property);
            Locale locale = (Locale)AbstractDataSetPage.this.getTable().getColumn(langIndex).getData();
            int dsNumber = (Integer)AbstractDataSetPage.this.getDataSetCombo().getSelectedObject();
            int paramIndex = AbstractDataSetPage.this.getTable().getSelectionIndex();
            this.setValueToModel(value, edit, paramIndex, dsNumber - 1, locale);
            AbstractDataSetPage.this.getTable().getItem(paramIndex).setText(langIndex, value == null ? "" : (String)value);
        }

        private void writeLanguageData(String property, Object value, AbstractJBEditor edit) {
            int paramIndex = this.getColumnIndexOfProperty(property);
            int dsNumber = AbstractDataSetPage.this.getTable().indexOf(this.getRow());
            Locale locale = (Locale)AbstractDataSetPage.this.getLanguageCombo().getSelectedObject();
            this.setValueToModel(value, edit, paramIndex - 1, dsNumber, locale);
            AbstractDataSetPage.this.getTable().getItem(dsNumber).setText(paramIndex, value == null ? "" : (String)value);
        }

        private void setValueToModel(Object value, AbstractJBEditor editor, int paramIndex, int dsNumber, Locale locale) {
            if (editor.getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                ParamNameBPDecorator mapper = editor.getEditorHelper().getEditSupport().getParamMapper();
                GuiParamValueConverter conv = AbstractDataSetPage.this.getGuiParamValueConverter((String)value, AbstractDataSetPage.this.getParamInterfaceObj(), locale, this.getCurrentParamDescription(), ((CheckedParamText)this.m_editor.getEditor()).getDataValidator());
                if (conv.getErrors().isEmpty()) {
                    AbstractDataSetPage.this.getParamBP().startParameterUpdate(conv, locale, dsNumber, (IParamNameMapper)mapper);
                    AbstractDataSetPage.this.setIsEntrySetComplete(AbstractDataSetPage.this.getParamInterfaceObj(), locale);
                    editor.getEditorHelper().setDirty(true);
                    new IsAliveThread(){

                        public void run() {
                            Plugin.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    DataEventDispatcher.getInstance().firePropertyChanged(false);
                                    DataEventDispatcher.getInstance().fireParamChangedListener();
                                }
                            });
                        }
                    }.start();
                }
            }
        }

        private void writeParamData(String property, Object value, AbstractJBEditor edit) {
            int langIndex = this.getColumnIndexOfProperty(property);
            Locale locale = (Locale)AbstractDataSetPage.this.getTable().getColumn(langIndex).getData();
            IParamDescriptionPO desc = (IParamDescriptionPO)AbstractDataSetPage.this.m_paramCombo.getSelectedObject();
            int paramIndex = AbstractDataSetPage.this.getParamInterfaceObj().getDataManager().findColumnForParam(desc.getUniqueId());
            int dsNumber = AbstractDataSetPage.this.getTable().getSelectionIndex();
            this.setValueToModel(value, edit, paramIndex, dsNumber, locale);
            AbstractDataSetPage.this.getTable().getItem(dsNumber).setText(langIndex, value == null ? "" : (String)value);
        }

        public void dispose() {
            this.removeSelectionListener((SelectionListener)this.m_cursorListener);
            this.removeMouseListener((MouseListener)this.m_mouseListener);
            this.m_editor.getEditor().removeFocusListener((FocusListener)this.m_focusListener);
            super.dispose();
        }

        private boolean canModify() {
            boolean isEditor;
            if (!(AbstractDataSetPage.this.m_currentPart instanceof AbstractJBEditor)) {
                return false;
            }
            AbstractJBEditor edit = (AbstractJBEditor)AbstractDataSetPage.this.m_currentPart;
            boolean isFirstColumn = this.getColumn() == 0;
            boolean bl = isEditor = edit != null;
            return !isFirstColumn && isEditor && AbstractDataSetPage.this.getControlEnabler().areControlsEnabled();
        }

        protected void checkSubclass() {
        }

        private Control createEditor() {
            Control control = TestDataControlFactory.createControl(AbstractDataSetPage.this.getParamInterfaceObj(), this.getParamName(), (Composite)this, 0);
            control.addKeyListener((KeyListener)this.m_keyListener);
            control.setFocus();
            control.addListener(13, this.m_listener);
            this.m_oldValue = this.getRow().getText(this.getColumn());
            TextControlBP.setText(this.m_oldValue, control);
            TextControlBP.selectAll(control);
            return control;
        }

        private String getParamName() {
            DirectCombo activeCombo = AbstractDataSetPage.this.getComboTracker().getCurrentCombo();
            String paramName = "";
            if (activeCombo == AbstractDataSetPage.this.getLanguageCombo()) {
                paramName = AbstractDataSetPage.this.getTable().getColumn(this.getColumn()).getText();
            } else if (activeCombo == AbstractDataSetPage.this.m_paramCombo) {
                paramName = ((IParamDescriptionPO)AbstractDataSetPage.this.m_paramCombo.getSelectedObject()).getName();
            } else if (activeCombo == AbstractDataSetPage.this.getDataSetCombo()) {
                paramName = this.getRow().getText(0);
            }
            return paramName;
        }

        private IParamDescriptionPO getCurrentParamDescription() {
            String paramName = this.getParamName();
            return AbstractDataSetPage.this.getParamInterfaceObj().getParameterForName(paramName);
        }

        private void activateEditor() {
            if (this.canModify()) {
                this.m_editor.setEditor(this.createEditor());
                Control editorCtrl = this.m_editor.getEditor();
                if (editorCtrl != null && !editorCtrl.isDisposed()) {
                    editorCtrl.addFocusListener((FocusListener)this.m_focusListener);
                }
                TextControlBP.selectAll(this.m_editor.getEditor());
            }
        }

        private class CursorListener
        extends SelectionAdapter {
            private CursorListener() {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DSVTableCursor.this.activateEditor();
                DSVTableCursor.this.m_wasActivatedWithEnterKey = true;
            }

            public void widgetSelected(SelectionEvent e) {
                AbstractDataSetPage.this.getTable().setSelection(new TableItem[]{DSVTableCursor.this.getRow()});
            }
        }

        private class EditorFocusListener
        extends FocusAdapter {
            private EditorFocusListener() {
            }

            public void focusLost(FocusEvent e) {
                CheckedParamTextContentAssisted ed;
                if (DSVTableCursor.this.m_editor.getEditor() instanceof CheckedParamTextContentAssisted && (ed = (CheckedParamTextContentAssisted)DSVTableCursor.this.m_editor.getEditor()).isPopupOpen() && ed.isFocusControl()) {
                    super.focusLost(e);
                    return;
                }
                DSVTableCursor.this.writeData();
                DSVTableCursor.this.m_editor.getEditor().dispose();
                super.focusLost(e);
            }
        }

        private class EditorKeyListener
        extends KeyAdapter {
            private EditorKeyListener() {
            }

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001 || e.keyCode == 0x1000003 || e.keyCode == 0x1000004) {
                    return;
                }
                if (e.character != '\b' && e.character != '\u007f' && e.character != '\u001b' && e.character != '\r' && e.character != '\u1000050' && Character.isISOControl(e.character)) {
                    return;
                }
                if (e.getSource().equals(DSVTableCursor.this.m_editor.getEditor())) {
                    if (e.character == '\u001b') {
                        TextControlBP.setText(DSVTableCursor.this.m_oldValue, DSVTableCursor.this.m_editor.getEditor());
                        DSVTableCursor.this.writeData();
                        TableItem rowItem = DSVTableCursor.this.getRow();
                        int col = DSVTableCursor.this.getColumn();
                        rowItem.setText(col, DSVTableCursor.this.m_oldValue);
                        DSVTableCursor.this.m_editor.getEditor().dispose();
                        return;
                    }
                    if (e.character == '\r' || e.character == '\u1000050') {
                        if (DSVTableCursor.this.m_wasActivatedWithEnterKey) {
                            DSVTableCursor.this.m_wasActivatedWithEnterKey = false;
                            return;
                        }
                        this.handleCR();
                    }
                }
                if (e.getSource() instanceof DSVTableCursor) {
                    if (e.character == '\u001b') {
                        return;
                    }
                    DSVTableCursor.this.activateEditor();
                    if (DSVTableCursor.this.m_editor.getEditor() != null && !DSVTableCursor.this.m_editor.getEditor().isDisposed() && e.character != '\r' && e.character != '\u1000050' && !(DSVTableCursor.this.m_editor.getEditor() instanceof CCombo)) {
                        String sign = new Character(e.character).toString();
                        if (e.character == '\u007f' || e.character == '\b') {
                            sign = "";
                        }
                        TextControlBP.setText(sign, DSVTableCursor.this.m_editor.getEditor());
                        TextControlBP.setSelection(DSVTableCursor.this.m_editor.getEditor(), 1);
                    }
                }
            }

            private void handleCR() {
                Control editorControl = DSVTableCursor.this.m_editor.getEditor();
                if (!editorControl.isDisposed()) {
                    DSVTableCursor.this.writeData();
                }
                if (!editorControl.isDisposed()) {
                    TableItem rowItem = DSVTableCursor.this.getRow();
                    int col = DSVTableCursor.this.getColumn();
                    rowItem.setText(col, TextControlBP.getText(editorControl));
                    editorControl.dispose();
                    int row = AbstractDataSetPage.this.getTable().indexOf(DSVTableCursor.this.getRow());
                    if (AbstractDataSetPage.this.getTable().getColumnCount() > col + 1) {
                        DSVTableCursor.this.setSelection(row, col + 1);
                        AbstractDataSetPage.this.getTable().setSelection(row);
                        DSVTableCursor.this.setFocus();
                    } else if (AbstractDataSetPage.this.getTable().getItemCount() > row + 1) {
                        DSVTableCursor.this.setSelection(row + 1, 1);
                        AbstractDataSetPage.this.getTable().setSelection(row + 1);
                    } else {
                        AbstractDataSetPage.this.getAddButton().setFocus();
                    }
                }
            }
        }

        private class EditorMouseListener
        extends MouseAdapter {
            private EditorMouseListener() {
            }

            public void mouseUp(MouseEvent e) {
                DSVTableCursor.this.activateEditor();
                DSVTableCursor.this.m_wasActivatedWithEnterKey = false;
            }
        }
    }

    private class DataSetComboListener
    extends AbstractSelectionListener {
        private DataSetComboListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (((DirectCombo)source).getSelectionIndex() == 0) {
                AbstractDataSetPage.this.getComboTracker().getCurrentCombo().setSelectedObject(AbstractDataSetPage.this.getComboTracker().getCurrentSelectedValue(false));
                return;
            }
            AbstractDataSetPage.this.initTableViewerLanguageColumns(false);
            AbstractDataSetPage.this.getTableViewer().setContentProvider((IContentProvider)new DataSetContentProvider());
            AbstractDataSetPage.this.getTableViewer().setLabelProvider((IBaseLabelProvider)new DataSetLabelProvider());
            AbstractDataSetPage.this.getComboTracker().setComboSelection(AbstractDataSetPage.this.getDataSetCombo());
            AbstractDataSetPage.this.getTableViewer().refresh();
        }
    }

    private class DataSetContentProvider
    extends AbstractContentProvider {
        private DataSetContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            return AbstractDataSetPage.this.getParamInterfaceObj().getParameterList().toArray();
        }
    }

    private class DataSetLabelProvider
    extends AbstractLabelProvider {
        private DataSetLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof IParamDescriptionPO)) {
                return "";
            }
            IParamDescriptionPO desc = (IParamDescriptionPO)element;
            if (columnIndex == 0) {
                int rowCount = AbstractDataSetPage.this.getParamInterfaceObj().getParameterList().indexOf(desc);
                AbstractDataSetPage.this.getTable().getItem(rowCount).setBackground(columnIndex, AbstractDataSetPage.this.getTable().getDisplay().getSystemColor(22));
                return desc.getName();
            }
            Locale locale = (Locale)AbstractDataSetPage.this.getTable().getColumn(columnIndex).getData();
            String value = "";
            if (AbstractDataSetPage.this.getDataSetCombo().getSelectedObject() != null) {
                int rowCount = (Integer)AbstractDataSetPage.this.getDataSetCombo().getSelectedObject() - 1;
                IParameterInterfacePO paramInterface = AbstractDataSetPage.this.getParamInterfaceObj();
                value = AbstractDataSetPage.getGuiStringForParamValue(paramInterface, desc, rowCount, locale);
            }
            return value;
        }
    }

    private class LanguageComboListener
    extends AbstractSelectionListener {
        private LanguageComboListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (((DirectCombo)source).getSelectionIndex() == 0) {
                AbstractDataSetPage.this.getComboTracker().getCurrentCombo().setSelectedObject(AbstractDataSetPage.this.getComboTracker().getCurrentSelectedValue(false));
                return;
            }
            AbstractDataSetPage.this.getTableViewer().setContentProvider((IContentProvider)new LanguageContentProvider());
            AbstractDataSetPage.this.getTableViewer().setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider());
            AbstractDataSetPage.this.getComboTracker().setComboSelection(AbstractDataSetPage.this.getLanguageCombo());
            AbstractDataSetPage.this.initTableViewerParameterColumns();
            AbstractDataSetPage.this.getTableViewer().refresh();
        }
    }

    private static class LanguageContentProvider
    extends AbstractContentProvider {
        private LanguageContentProvider() {
        }

        @Override
        public Object[] getElements(Object inputElement) {
            ITDManager tdMan = (ITDManager)inputElement;
            List rows = tdMan.getDataSets();
            return rows.toArray();
        }

        /* synthetic */ LanguageContentProvider(LanguageContentProvider languageContentProvider, LanguageContentProvider languageContentProvider2) {
            this();
        }
    }

    private class LanguageLabelProvider
    extends AbstractLabelProvider {
        private LanguageLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            if (!(element instanceof IDataSetPO)) {
                return "";
            }
            ITDManager tdMan = (ITDManager)AbstractDataSetPage.this.getTableViewer().getInput();
            IDataSetPO row = (IDataSetPO)element;
            int rowCount = tdMan.getDataSets().indexOf(row);
            if (columnIndex == 0) {
                AbstractDataSetPage.this.getTable().getItem(rowCount).setBackground(columnIndex, AbstractDataSetPage.this.getTable().getDisplay().getSystemColor(22));
                return "" + (rowCount + 1);
            }
            List paramList = AbstractDataSetPage.this.getParamInterfaceObj().getParameterList();
            String value = "";
            if (columnIndex - 1 < paramList.size()) {
                IParamDescriptionPO desc = (IParamDescriptionPO)paramList.get(columnIndex - 1);
                IParameterInterfacePO paramInterface = AbstractDataSetPage.this.getParamInterfaceObj();
                value = AbstractDataSetPage.getGuiStringForParamValue(paramInterface, desc, rowCount, (Locale)AbstractDataSetPage.this.getLanguageCombo().getSelectedObject());
            }
            return value;
        }
    }

    private class ParameterComboListener
    extends AbstractSelectionListener {
        private ParameterComboListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (((DirectCombo)source).getSelectionIndex() == 0) {
                AbstractDataSetPage.this.getComboTracker().getCurrentCombo().setSelectedObject(AbstractDataSetPage.this.getComboTracker().getCurrentSelectedValue(false));
                return;
            }
            AbstractDataSetPage.this.initTableViewerLanguageColumns(true);
            AbstractDataSetPage.this.getTableViewer().setContentProvider((IContentProvider)new ParameterContentProvider());
            AbstractDataSetPage.this.getTableViewer().setLabelProvider((IBaseLabelProvider)new ParameterLabelProvider());
            AbstractDataSetPage.this.getComboTracker().setComboSelection(AbstractDataSetPage.this.m_paramCombo);
            AbstractDataSetPage.this.getTableViewer().refresh();
        }
    }

    private static class ParameterContentProvider
    extends LanguageContentProvider {
        private ParameterContentProvider() {
            super(null, null);
        }
    }

    private class ParameterLabelProvider
    extends AbstractLabelProvider {
        private ParameterLabelProvider() {
        }

        @Override
        public String getColumnText(Object element, int columnIndex) {
            IParamDescriptionPO desc;
            if (!(element instanceof IDataSetPO)) {
                return "";
            }
            ITDManager tdMan = (ITDManager)AbstractDataSetPage.this.getTableViewer().getInput();
            IDataSetPO row = (IDataSetPO)element;
            int rowCount = tdMan.getDataSets().indexOf(row);
            if (columnIndex == 0) {
                AbstractDataSetPage.this.getTable().getItem(rowCount).setBackground(columnIndex, AbstractDataSetPage.this.getTable().getDisplay().getSystemColor(22));
                return "" + (rowCount + 1);
            }
            String value = "";
            if (columnIndex - 1 < AbstractDataSetPage.this.getTable().getColumnCount() && (desc = (IParamDescriptionPO)AbstractDataSetPage.this.m_paramCombo.getSelectedObject()) != null) {
                Locale locale = (Locale)AbstractDataSetPage.this.getTable().getColumn(columnIndex).getData();
                IParameterInterfacePO paramInterface = AbstractDataSetPage.this.getParamInterfaceObj();
                value = AbstractDataSetPage.getGuiStringForParamValue(paramInterface, desc, rowCount, locale);
            }
            return value;
        }
    }

    private static enum TestDataRowAction {
        ADDED,
        INSERTED,
        DELETED;

    }
}

