/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.communication.internal.connection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.jubula.tools.internal.jarutils.IVersion;
import org.eclipse.jubula.tools.internal.utils.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServerSocket
extends ServerSocket {
    private static Logger log = LoggerFactory.getLogger(DefaultServerSocket.class);

    public DefaultServerSocket(int port) throws IOException {
        super(port);
    }

    public static void send(Socket socket, int state) throws IOException {
        PrintStream outputStream = new PrintStream(socket.getOutputStream());
        String status = String.valueOf(state) + "/" + IVersion.JB_PROTOCOL_MAJOR_VERSION;
        if (log.isDebugEnabled()) {
            log.debug("sending state: " + String.valueOf(status));
        }
        outputStream.println(String.valueOf(status));
        outputStream.flush();
    }

    public static String requestClientType(Socket socket, BufferedReader reader, InputStream inputStream, long timeout) throws IOException {
        PrintStream outputStream = new PrintStream(socket.getOutputStream());
        String request = "ClientTypeRequest/" + IVersion.JB_PROTOCOL_MAJOR_VERSION;
        log.debug("sending request: " + request);
        outputStream.println(request);
        outputStream.flush();
        if (log.isDebugEnabled()) {
            log.debug("waiting for client type response using timeout: " + String.valueOf(timeout));
        }
        long waitTime = 0L;
        while (waitTime <= timeout) {
            if (inputStream.available() > 0) {
                return reader.readLine();
            }
            waitTime += TimeUtil.delay((long)500L);
        }
        log.debug("no client type response received from client");
        return null;
    }
}

