/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.commands;

import org.eclipse.jubula.communication.internal.Communicator;
import org.eclipse.jubula.communication.internal.ICommand;
import org.eclipse.jubula.communication.internal.message.ChangeAUTModeMessage;
import org.eclipse.jubula.communication.internal.message.Message;
import org.eclipse.jubula.communication.internal.message.ServerShowDialogResponseMessage;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.common.commands.ChangeAUTModeCommand;
import org.eclipse.jubula.tools.internal.exception.CommunicationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowDialogResultCommand
implements ICommand {
    private static Logger log = LoggerFactory.getLogger(ShowDialogResultCommand.class);
    private ServerShowDialogResponseMessage m_message;

    public Message getMessage() {
        return this.m_message;
    }

    public void setMessage(Message message) {
        this.m_message = (ServerShowDialogResponseMessage)message;
    }

    public Message execute() {
        AUTServer autserver = AUTServer.getInstance();
        autserver.setObservingDialogOpen(this.m_message.isOpen());
        if (this.m_message.belongsToDialog()) {
            this.changeCheckModeState(this.m_message.getMode());
        } else {
            this.changeCheckModeState(autserver.getMode());
        }
        return null;
    }

    private void changeCheckModeState(int mode) {
        ChangeAUTModeMessage msg = new ChangeAUTModeMessage();
        msg.setMode(mode);
        AUTServerConfiguration config = AUTServerConfiguration.getInstance();
        msg.setKey(config.getKey());
        msg.setKeyModifier(config.getKeyMod());
        msg.setKey2(config.getKey2());
        msg.setKey2Modifier(config.getKey2Mod());
        msg.setCheckModeKey(config.getCheckModeKey());
        msg.setCheckModeKeyModifier(config.getCheckModeKeyMod());
        msg.setCheckCompKey(config.getCheckCompKey());
        msg.setCheckCompKeyModifier(config.getCheckCompKeyMod());
        msg.setSingleLineTrigger(config.getSingleLineTrigger());
        msg.setMultiLineTrigger(config.getMultiLineTrigger());
        ChangeAUTModeCommand cmd = new ChangeAUTModeCommand();
        cmd.setMessage((Message)msg);
        try {
            Communicator clientCommunicator = AUTServer.getInstance().getCommunicator();
            if (clientCommunicator != null && clientCommunicator.getConnection() != null) {
                clientCommunicator.send(cmd.execute());
            }
        }
        catch (CommunicationException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void timeout() {
        log.error(String.valueOf(this.getClass().getName()) + ".timeout() called");
    }
}

