/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.listener;

import java.util.Iterator;
import java.util.SortedSet;
import org.eclipse.jubula.rc.common.AUTServerConfiguration;
import org.eclipse.jubula.rc.swt.listener.RecordHelperSWT;
import org.eclipse.jubula.rc.swt.utils.SwtKeyCodeConverter;
import org.eclipse.jubula.toolkit.enums.ValueSets;
import org.eclipse.swt.widgets.Event;

public class KeyAcceptor {
    public static final int MAPPING_KEY_COMB = 1;
    public static final int CHECKMODE_KEY_COMB = 2;
    public static final int CHECKCOMP_KEY_COMB = 3;

    public int accept(Event event) {
        int keyMod = event.stateMask;
        int eventCode = 0;
        switch (event.button) {
            case 1: {
                eventCode = ValueSets.InteractionMode.primary.rcIntValue();
                keyMod &= 0xFFF7FFFF;
                break;
            }
            case 2: {
                eventCode = ValueSets.InteractionMode.tertiary.rcIntValue();
                keyMod &= 0xFFEFFFFF;
                break;
            }
            case 3: {
                eventCode = ValueSets.InteractionMode.secondary.rcIntValue();
                keyMod &= 0xFFDFFFFF;
                break;
            }
            default: {
                eventCode = event.keyCode;
            }
        }
        if (eventCode == 65536) {
            keyMod |= 0x10000;
        }
        if (eventCode == 131072) {
            keyMod |= 0x20000;
        }
        if (eventCode == 262144) {
            keyMod |= 0x40000;
        }
        if (eventCode >= 97 && eventCode <= 122) {
            eventCode -= 32;
        }
        if ((eventCode == AUTServerConfiguration.getInstance().getKey() || eventCode == AUTServerConfiguration.getInstance().getMouseButton()) && keyMod == AUTServerConfiguration.getInstance().getKeyMod()) {
            return 1;
        }
        if (eventCode == AUTServerConfiguration.getInstance().getCheckModeKey() && keyMod == AUTServerConfiguration.getInstance().getCheckModeKeyMod()) {
            return 2;
        }
        if (eventCode == AUTServerConfiguration.getInstance().getCheckCompKey() && keyMod == AUTServerConfiguration.getInstance().getCheckCompKeyMod()) {
            return 3;
        }
        return 0;
    }

    public boolean isSingleLineTrigger(Event event) {
        boolean isSingleTrigger = false;
        int keycode = event.keyCode;
        char character = RecordHelperSWT.topKey(event);
        int modifier = event.stateMask;
        SortedSet singleTrigger = AUTServerConfiguration.getInstance().getSingleLineTrigger();
        isSingleTrigger = this.isTrigger(singleTrigger, keycode, modifier, character);
        return isSingleTrigger;
    }

    public boolean isMultiLineTrigger(Event event) {
        boolean isMultiTrigger = false;
        int keycode = event.keyCode;
        char character = RecordHelperSWT.topKey(event);
        int modifier = event.stateMask;
        SortedSet multiTrigger = AUTServerConfiguration.getInstance().getMultiLineTrigger();
        isMultiTrigger = this.isTrigger(multiTrigger, keycode, modifier, character);
        return isMultiTrigger;
    }

    public boolean isTrigger(SortedSet triggerSet, int key, int modifier, char character) {
        boolean isTrigger = false;
        int triggerCode = 0;
        char triggerChar = ' ';
        int triggerMod = 0;
        Iterator it = triggerSet.iterator();
        while (it.hasNext()) {
            String trigger = it.next().toString().toUpperCase();
            if (trigger.indexOf("+") != -1) {
                String[] keys = trigger.split("\\+");
                switch (keys.length) {
                    case 2: {
                        triggerMod = SwtKeyCodeConverter.getModifierCode(keys[0]);
                        triggerCode = SwtKeyCodeConverter.getKeyCode(keys[1]);
                        triggerChar = keys[1].charAt(0);
                        break;
                    }
                    case 3: {
                        triggerMod = SwtKeyCodeConverter.getModifierCode(keys[0]) | SwtKeyCodeConverter.getModifierCode(keys[1]);
                        triggerCode = SwtKeyCodeConverter.getKeyCode(keys[2]);
                        triggerChar = keys[2].charAt(0);
                        break;
                    }
                    case 4: {
                        triggerMod = SwtKeyCodeConverter.getModifierCode(keys[0]) | SwtKeyCodeConverter.getModifierCode(keys[1]) | SwtKeyCodeConverter.getModifierCode(keys[2]);
                        triggerCode = SwtKeyCodeConverter.getKeyCode(keys[3]);
                        triggerChar = keys[3].charAt(0);
                    }
                }
            } else {
                triggerMod = 0;
                triggerCode = SwtKeyCodeConverter.getKeyCode(trigger);
                triggerChar = SwtKeyCodeConverter.getKeyChar(trigger).charValue();
            }
            if (key != triggerCode && character != triggerChar || modifier != triggerMod) continue;
            isTrigger = true;
        }
        return isTrigger;
    }
}

