/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester;

import java.awt.Point;
import java.util.StringTokenizer;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.util.KeyStrokeUtil;
import org.eclipse.jubula.rc.swt.driver.KeyCodeConverter;
import org.eclipse.jubula.rc.swt.driver.SwtRobot;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;

public class CAPUtil {
    private CAPUtil() {
    }

    public static void shakeMouse() {
        Point origin = AUTServer.getInstance().getRobot().getCurrentMousePosition();
        SwtRobot lowLevelRobot = new SwtRobot(Display.getDefault());
        lowLevelRobot.mouseMove(origin.x + 10, origin.y + 10);
        lowLevelRobot.mouseMove(origin.x - 10, origin.y - 10);
        lowLevelRobot.mouseMove(origin.x, origin.y);
        if (!EnvironmentUtils.isWindowsOS() && !EnvironmentUtils.isMacOS()) {
            boolean moreEvents = true;
            while (moreEvents) {
                moreEvents = Display.getDefault().readAndDispatch();
            }
        }
    }

    public static void pressOrReleaseModifiers(String modifier, boolean press) {
        IRobot robot = AUTServer.getInstance().getRobot();
        StringTokenizer modTok = new StringTokenizer(KeyStrokeUtil.getModifierString((String)modifier), " ");
        while (modTok.hasMoreTokens()) {
            String mod = modTok.nextToken();
            int keyCode = KeyCodeConverter.getKeyCode(mod);
            if (press) {
                robot.keyPress(null, keyCode);
                continue;
            }
            robot.keyRelease(null, keyCode);
        }
    }

    public static String getWidgetText(Widget widget, String key, String fallbackText) {
        Object o;
        if (key != null && (o = widget.getData(key)) instanceof String) {
            return (String)o;
        }
        return fallbackText;
    }

    public static String getWidgetText(Widget widget, String fallbackText) {
        return CAPUtil.getWidgetText(widget, "TEST_TESTABLE_TEXT", fallbackText);
    }
}

