/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.AbstractComboBoxAdapter;
import org.eclipse.jubula.tools.internal.utils.EnvironmentUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class ComboAdapter
extends AbstractComboBoxAdapter {
    private Combo m_combobox;

    public ComboAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_combobox = (Combo)objectToAdapt;
    }

    public void selectAll() {
        this.click(new Integer(1));
        if (EnvironmentUtils.isMacOS()) {
            this.getEventThreadQueuer().invokeAndWait("combo.selectAll", (IRunnable)new IRunnable<Void>(){

                public Void run() {
                    int textLength = StringUtils.length((String)ComboAdapter.this.m_combobox.getText());
                    ComboAdapter.this.m_combobox.setSelection(new Point(0, textLength));
                    return null;
                }
            });
        } else {
            this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
        }
    }

    public int getSelectedIndex() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait(String.valueOf(ComboAdapter.class.getName()) + "getSelectedIndex", (IRunnable)new IRunnable<Integer>(){

            public Integer run() throws StepExecutionException {
                return ComboAdapter.this.m_combobox.getSelectionIndex();
            }
        });
    }

    public String getText() {
        String o = (String)this.getEventThreadQueuer().invokeAndWait("getText", (IRunnable)new IRunnable<String>(){

            public String run() {
                return CAPUtil.getWidgetText((Widget)ComboAdapter.this.m_combobox, ComboAdapter.this.m_combobox.getText());
            }
        });
        return String.valueOf(o);
    }

    protected boolean isComboEnabled() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait(String.valueOf(ComboAdapter.class.getName()) + "isComboEnabled", (IRunnable)new IRunnable<Boolean>(){

            public Boolean run() throws StepExecutionException {
                return ComboAdapter.this.m_combobox.isEnabled();
            }
        });
    }

    protected void selectImpl(int index) {
        this.getRobot().keyType((Object)this.m_combobox, 27);
        this.selectComboIndex(index);
    }

    protected void openDropdownList() {
        this.toggleDropdownList();
    }

    protected int getItemCount() {
        return (Integer)this.getEventThreadQueuer().invokeAndWait("getItemCount", (IRunnable)new IRunnable<Integer>(){

            public Integer run() {
                return ComboAdapter.this.m_combobox.getItemCount();
            }
        });
    }

    private void selectComboIndex(final int index) {
        final Combo combo = this.m_combobox;
        this.getEventThreadQueuer().invokeAndWait("selectComboIndex", (IRunnable)new IRunnable<Void>(){

            public Void run() throws StepExecutionException {
                combo.select(index);
                Event selectionEvent = new Event();
                selectionEvent.type = 13;
                selectionEvent.widget = combo;
                combo.notifyListeners(13, selectionEvent);
                return null;
            }
        });
    }

    public String[] getValues() {
        return (String[])this.getEventThreadQueuer().invokeAndWait("getItem", (IRunnable)new IRunnable<String[]>(){

            public String[] run() {
                return ComboAdapter.this.m_combobox.getItems();
            }
        });
    }
}

