/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.commands;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.internal.LaunchBarManager;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.dialogs.LaunchConfigurationEditDialog;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConfigureActiveLaunchHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        LaunchBarManager launchBarManager = Activator.getDefault().getLaunchBarUIManager().getManager();
        ILaunchDescriptor launchDesc = launchBarManager.getActiveLaunchDescriptor();
        if (launchDesc == null) {
            return Status.OK_STATUS;
        }
        ConfigureActiveLaunchHandler.openConfigurationEditor(launchDesc);
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IStatus canOpenConfigurationEditor(ILaunchDescriptor desc) {
        if (desc == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.DescriptorMustNotBeNull, (Throwable)new Exception(Messages.DescriptorMustNotBeNullDesc));
        }
        LaunchBarManager manager = Activator.getDefault().getLaunchBarUIManager().getManager();
        ILaunchMode mode = manager.getActiveLaunchMode();
        IRemoteConnection target = manager.getActiveLaunchTarget();
        if (target == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoActiveTarget, (Throwable)new Exception(Messages.NoActiveTargetDesc));
        }
        ILaunchConfigurationType configType = null;
        try {
            configType = manager.getLaunchConfigurationType(desc, target);
        }
        catch (CoreException coreException) {}
        if (configType == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchConfigType, (Throwable)new Exception(Messages.CannotEditLaunchConfiguration));
        }
        if (mode == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchModeSelected, (Throwable)new Exception(Messages.NoLaunchModeSelected));
        }
        ILaunchGroup group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configType, mode.getIdentifier());
        if (group == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchGroupSelected, (Throwable)new Exception(Messages.NoLaunchGroupSelected));
        }
        String mode2 = group.getMode();
        if (mode2 == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchModeSelected, (Throwable)new Exception(Messages.CannotEditLaunchConfiguration));
        }
        LaunchGroupExtension groupExt = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(group.getIdentifier());
        if (groupExt == null) return new Status(4, "org.eclipse.launchbar.ui", Messages.CannotEditLaunchConfiguration, (Throwable)new Exception(Messages.CannotEditLaunchConfiguration));
        ILaunchConfiguration config = null;
        try {
            config = manager.getLaunchConfiguration(desc, target);
        }
        catch (CoreException coreException) {}
        if (config == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.LaunchConfigurationNotFound, (Throwable)new Exception(Messages.LaunchConfigurationNotFoundDesc));
        }
        try {
            LaunchConfigurationPresentationManager mgr = LaunchConfigurationPresentationManager.getDefault();
            mgr.getTabGroup(config, mode.getIdentifier());
            return Status.OK_STATUS;
        }
        catch (CoreException coreException) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchTabsDefined, (Throwable)new Exception(Messages.NoLaunchTabsDefinedDesc));
        }
    }

    public static void openConfigurationEditor(ILaunchDescriptor desc) {
        if (desc == null) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IStatus s = ConfigureActiveLaunchHandler.canOpenConfigurationEditor(desc);
        if (!s.isOK()) {
            MessageDialog.openError((Shell)shell, (String)s.getMessage(), (String)(s.getException() == null ? s.getMessage() : s.getException().getMessage()));
            return;
        }
        try {
            LaunchBarManager manager = Activator.getDefault().getLaunchBarUIManager().getManager();
            ILaunchMode mode = manager.getActiveLaunchMode();
            IRemoteConnection target = manager.getActiveLaunchTarget();
            ILaunchConfigurationType configType = manager.getLaunchConfigurationType(desc, target);
            ILaunchGroup group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configType, mode.getIdentifier());
            LaunchGroupExtension groupExt = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(group.getIdentifier());
            ILaunchConfiguration config = manager.getLaunchConfiguration(desc, target);
            if (config.isWorkingCopy() && ((ILaunchConfigurationWorkingCopy)config).isDirty()) {
                config = ((ILaunchConfigurationWorkingCopy)config).doSave();
            }
            LaunchConfigurationEditDialog dialog = new LaunchConfigurationEditDialog(shell, config, groupExt);
            dialog.setInitialStatus(Status.OK_STATUS);
            dialog.open();
        }
        catch (CoreException e2) {
            Activator.log((Exception)((Object)e2));
        }
    }
}

