/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal.controls;

import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.DefaultDescriptorLabelProvider;
import org.eclipse.launchbar.ui.internal.LaunchBarUIManager;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.launchbar.ui.internal.commands.ConfigureActiveLaunchHandler;
import org.eclipse.launchbar.ui.internal.controls.CSelector;
import org.eclipse.launchbar.ui.internal.controls.LaunchBarListViewer;
import org.eclipse.launchbar.ui.internal.dialogs.NewLaunchConfigWizard;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ConfigSelector
extends CSelector {
    private LaunchBarUIManager uiManager = Activator.getDefault().getLaunchBarUIManager();
    private DefaultDescriptorLabelProvider defaultProvider;
    private static final String[] noConfigs = new String[]{Messages.ConfigSelector_0};

    public ConfigSelector(Composite parent, int style) {
        super(parent, style);
        this.setToolTipText(Messages.ConfigSelector_1);
        this.defaultProvider = new DefaultDescriptorLabelProvider();
        this.setContentProvider(new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                Object[] descs = ConfigSelector.this.uiManager.getManager().getLaunchDescriptors();
                if (descs.length == 0) {
                    return noConfigs;
                }
                return descs;
            }
        });
        this.setLabelProvider((ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof ILaunchDescriptor) {
                    try {
                        Image img;
                        ILaunchDescriptor configDesc = (ILaunchDescriptor)element;
                        ILabelProvider labelProvider = ConfigSelector.this.uiManager.getLabelProvider(configDesc);
                        if (labelProvider != null && (img = labelProvider.getImage(element)) != null) {
                            return img;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e.getStatus());
                    }
                }
                return ConfigSelector.this.defaultProvider.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof ILaunchDescriptor) {
                    try {
                        String text;
                        ILaunchDescriptor configDesc = (ILaunchDescriptor)element;
                        ILabelProvider labelProvider = ConfigSelector.this.uiManager.getLabelProvider(configDesc);
                        if (labelProvider != null && (text = labelProvider.getText(element)) != null) {
                            return text;
                        }
                    }
                    catch (CoreException e) {
                        Activator.log(e.getStatus());
                    }
                }
                return ConfigSelector.this.defaultProvider.getText(element);
            }
        });
        this.setHistorySortComparator(null);
        this.setSorter(new Comparator<ILaunchDescriptor>(){

            @Override
            public int compare(ILaunchDescriptor o1, ILaunchDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    @Override
    protected void initializeListViewer(LaunchBarListViewer listViewer) {
        listViewer.setHistorySupported(true);
        listViewer.setHistoryPreferenceName("launchHistorySize");
        super.initializeListViewer(listViewer);
    }

    @Override
    protected void fireSelectionChanged() {
        Object selected = this.getSelection();
        if (selected instanceof ILaunchDescriptor) {
            ILaunchDescriptor configDesc = (ILaunchDescriptor)selected;
            try {
                this.uiManager.getManager().setActiveLaunchDescriptor(configDesc);
            }
            catch (CoreException e) {
                Activator.log(e.getStatus());
            }
        }
    }

    @Override
    public boolean isEditable(Object element) {
        return element instanceof ILaunchDescriptor;
    }

    @Override
    public void handleEdit(Object element) {
        ConfigureActiveLaunchHandler.openConfigurationEditor((ILaunchDescriptor)element);
    }

    @Override
    public boolean hasActionArea() {
        return true;
    }

    @Override
    public void createActionArea(Composite parent) {
        Composite actionArea = new Composite(parent, 0);
        GridLayout actionLayout = new GridLayout();
        actionLayout.marginHeight = 0;
        actionLayout.marginWidth = 0;
        actionArea.setLayout((Layout)actionLayout);
        actionArea.setLayoutData((Object)new GridData(4, 4, true, false));
        final Composite createButton = new Composite(actionArea, 0);
        createButton.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.marginHeight = 7;
        buttonLayout.marginWidth = 7;
        createButton.setLayout((Layout)buttonLayout);
        createButton.setBackground(this.backgroundColor);
        createButton.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Point size = createButton.getSize();
                GC gc = e.gc;
                gc.setForeground(ConfigSelector.this.outlineColor);
                gc.drawLine(0, 0, size.x, 0);
            }
        });
        final Label createLabel = new Label(createButton, 0);
        createLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        createLabel.setText(Messages.ConfigSelector_2);
        createLabel.setBackground(this.backgroundColor);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                final NewLaunchConfigWizard wizard = new NewLaunchConfigWizard();
                WizardDialog dialog = new WizardDialog(ConfigSelector.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    new Job(Messages.ConfigSelector_3){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                wizard.getWorkingCopy().doSave();
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                return e.getStatus();
                            }
                        }
                    }.schedule();
                }
            }
        };
        createButton.addMouseListener((MouseListener)mouseListener);
        createLabel.addMouseListener((MouseListener)mouseListener);
        MouseTrackAdapter mouseTrackListener = new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                createButton.setBackground(ConfigSelector.this.highlightColor);
                createLabel.setBackground(ConfigSelector.this.highlightColor);
            }

            public void mouseExit(MouseEvent e) {
                createButton.setBackground(ConfigSelector.this.backgroundColor);
                createLabel.setBackground(ConfigSelector.this.backgroundColor);
            }
        };
        createButton.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
        createLabel.addMouseTrackListener((MouseTrackListener)mouseTrackListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        return super.computeSize(250, hHint, changed);
    }

    @Override
    public void setSelection(Object element) {
        if (element == null) {
            element = noConfigs[0];
        }
        super.setSelection(element);
    }

    @Override
    public void openPopup() {
        super.openPopup();
    }
}

