/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.internal.index.IndexedArtifact;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.dialogs.AbstractMavenDialog;
import org.eclipse.m2e.core.ui.internal.search.util.Packaging;
import org.eclipse.m2e.core.ui.internal.util.M2EUIUtils;
import org.eclipse.m2e.core.ui.internal.util.ProposalUtil;
import org.eclipse.m2e.core.ui.internal.wizards.MavenPomSelectionComponent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MavenRepositorySearchDialog
extends AbstractMavenDialog {
    private static final String DIALOG_SETTINGS = MavenRepositorySearchDialog.class.getName();
    public static final String[] SCOPES = new String[]{"compile", "provided", "runtime", "test", "system"};
    public static final String[] DEP_MANAGEMENT_SCOPES = new String[]{"compile", "provided", "runtime", "test", "system", "import"};
    private final boolean showScope;
    private final Set<ArtifactKey> artifacts;
    private final Map<ArtifactKey, String> managed;
    private final String queryType;
    private String queryText;
    MavenPomSelectionComponent pomSelectionComponent;
    private IndexedArtifact selectedIndexedArtifact;
    private IndexedArtifactFile selectedIndexedArtifactFile;
    private String selectedScope;
    private Combo comScope;
    private Text txtGroupId;
    private Text txtArtifactId;
    private Text txtVersion;
    private boolean ignoreTextChange = false;
    private IProject project;
    private MavenProject mavenproject;
    private final boolean showCoords;

    public static MavenRepositorySearchDialog createOpenPomDialog(Shell parent, String title) {
        return new MavenRepositorySearchDialog(parent, title, "artifact", Collections.emptySet(), Collections.emptyMap(), false, null, null, false);
    }

    public static MavenRepositorySearchDialog createSearchDependencyDialog(Shell parent, String title, MavenProject mp, IProject p, boolean inManagedSection) {
        HashSet<ArtifactKey> artifacts = new HashSet<ArtifactKey>();
        HashMap<ArtifactKey, String> managed = new HashMap<ArtifactKey, String>();
        if (mp != null) {
            DependencyManagement dm = mp.getDependencyManagement();
            if (dm != null && dm.getDependencies() != null) {
                for (Dependency dep : dm.getDependencies()) {
                    ArtifactKey artifactKey = new ArtifactKey(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getClassifier());
                    if (inManagedSection) {
                        artifacts.add(artifactKey);
                        continue;
                    }
                    managed.put(artifactKey, dep.getType());
                }
            }
            if (!inManagedSection) {
                for (Dependency dep : mp.getModel().getDependencies()) {
                    artifacts.add(new ArtifactKey(dep.getGroupId(), dep.getArtifactId(), dep.getVersion(), dep.getClassifier()));
                }
            }
        }
        return new MavenRepositorySearchDialog(parent, title, "artifact", artifacts, managed, true, mp, p, true);
    }

    public static MavenRepositorySearchDialog createSearchParentDialog(Shell parent, String title, MavenProject mp, IProject p) {
        HashSet<ArtifactKey> artifacts = new HashSet<ArtifactKey>();
        HashMap<ArtifactKey, String> managed = new HashMap<ArtifactKey, String>();
        if (mp != null && mp.getModel().getParent() != null) {
            Parent par = mp.getModel().getParent();
            artifacts.add(new ArtifactKey(par.getGroupId(), par.getArtifactId(), par.getVersion(), null));
        }
        return new MavenRepositorySearchDialog(parent, title, "parents", artifacts, managed, false, mp, p, true);
    }

    public static MavenRepositorySearchDialog createSearchPluginDialog(Shell parent, String title, MavenProject mp, IProject p, boolean inManagedSection) {
        HashSet<ArtifactKey> artifacts = new HashSet<ArtifactKey>();
        HashMap<ArtifactKey, String> managed = new HashMap<ArtifactKey, String>();
        if (mp != null && mp.getBuild() != null) {
            PluginManagement pm = mp.getBuild().getPluginManagement();
            if (pm != null && pm.getPlugins() != null) {
                for (Plugin plug : pm.getPlugins()) {
                    ArtifactKey artifactKey = new ArtifactKey(plug.getGroupId(), plug.getArtifactId(), plug.getVersion(), null);
                    if (inManagedSection) {
                        artifacts.add(artifactKey);
                        continue;
                    }
                    managed.put(artifactKey, "");
                }
            }
            if (!inManagedSection && mp.getModel().getBuild() != null) {
                for (Plugin plug : mp.getModel().getBuild().getPlugins()) {
                    artifacts.add(new ArtifactKey(plug.getGroupId(), plug.getArtifactId(), plug.getVersion(), null));
                }
            }
        }
        return new MavenRepositorySearchDialog(parent, title, "plugin", artifacts, managed, false, mp, p, true);
    }

    private MavenRepositorySearchDialog(Shell parent, String title, String queryType, Set<ArtifactKey> artifacts, Map<ArtifactKey, String> managed, boolean showScope, MavenProject mp, IProject p, boolean showCoordinates) {
        super(parent, DIALOG_SETTINGS);
        this.artifacts = artifacts;
        this.managed = managed;
        this.queryType = queryType;
        this.showScope = showScope;
        this.project = p;
        this.mavenproject = mp;
        this.showCoords = showCoordinates;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setStatusLineAboveButtons(true);
        this.setTitle(title);
    }

    public void setQuery(String query) {
        this.queryText = query;
    }

    protected Control createDialogArea(Composite parent) {
        this.readSettings();
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.showCoords) {
            this.createGAVControls(composite);
            Label separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        this.pomSelectionComponent = new MavenPomSelectionComponent(composite, 0);
        this.pomSelectionComponent.init(this.queryText, this.queryType, this.project, this.artifacts, this.managed.keySet());
        this.pomSelectionComponent.setLayoutData(new GridData(4, 4, true, true));
        this.pomSelectionComponent.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (!MavenRepositorySearchDialog.this.pomSelectionComponent.getStatus().matches(4)) {
                    MavenRepositorySearchDialog.this.okPressedDelegate();
                }
            }
        });
        this.pomSelectionComponent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MavenRepositorySearchDialog.this.updateStatusDelegate(MavenRepositorySearchDialog.this.pomSelectionComponent.getStatus());
                MavenRepositorySearchDialog.this.computeResultFromTree();
            }
        });
        this.pomSelectionComponent.setFocus();
        return composite;
    }

    private Composite createGAVControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout gridLayout = new GridLayout(this.showScope ? 4 : 2, false);
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label groupIDlabel = new Label(composite, 0);
        groupIDlabel.setText(Messages.AddDependencyDialog_groupId_label);
        this.txtGroupId = new Text(composite, 2048);
        this.txtGroupId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        M2EUIUtils.addRequiredDecoration((Control)this.txtGroupId);
        if (this.showScope) {
            new Label(composite, 0);
            new Label(composite, 0);
        }
        Label artifactIDlabel = new Label(composite, 0);
        artifactIDlabel.setText(Messages.AddDependencyDialog_artifactId_label);
        this.txtArtifactId = new Text(composite, 2048);
        this.txtArtifactId.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        M2EUIUtils.addRequiredDecoration((Control)this.txtArtifactId);
        if (this.showScope) {
            new Label(composite, 0);
            new Label(composite, 0);
        }
        Label versionLabel = new Label(composite, 0);
        versionLabel.setText(Messages.AddDependencyDialog_version_label);
        this.txtVersion = new Text(composite, 2048);
        this.txtVersion.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        if (this.showScope) {
            Label scopeLabel = new Label(composite, 0);
            scopeLabel.setText(Messages.AddDependencyDialog_scope_label);
            this.comScope = new Combo(composite, 12);
            this.comScope.setItems(SCOPES);
            GridData scopeListData = new GridData(16384, 0x1000000, false, false);
            this.comScope.setLayoutData((Object)scopeListData);
            this.comScope.setText(SCOPES[0]);
        }
        if (this.showScope) {
            composite.setTabList(new Control[]{this.txtGroupId, this.txtArtifactId, this.txtVersion, this.comScope});
        } else {
            composite.setTabList(new Control[]{this.txtGroupId, this.txtArtifactId, this.txtVersion});
        }
        Packaging pack = this.queryType.equals("parents") ? Packaging.POM : (this.queryType.equals("plugin") ? Packaging.PLUGIN : Packaging.ALL);
        ProposalUtil.addGroupIdProposal(this.project, this.txtGroupId, pack);
        ProposalUtil.addArtifactIdProposal(this.project, this.txtGroupId, this.txtArtifactId, pack);
        ProposalUtil.addVersionProposal(this.project, this.mavenproject, this.txtGroupId, this.txtArtifactId, this.txtVersion, pack);
        this.txtArtifactId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenRepositorySearchDialog.this.updateStatus(MavenRepositorySearchDialog.this.validateArtifactEntries());
                if (!MavenRepositorySearchDialog.this.ignoreTextChange) {
                    MavenRepositorySearchDialog.this.computeResultFromField(MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtGroupId.getText()), MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtArtifactId.getText()), MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtVersion.getText()));
                }
            }
        });
        this.txtGroupId.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MavenRepositorySearchDialog.this.updateStatus(MavenRepositorySearchDialog.this.validateArtifactEntries());
                if (!MavenRepositorySearchDialog.this.ignoreTextChange) {
                    MavenRepositorySearchDialog.this.computeResultFromField(MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtGroupId.getText()), MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtArtifactId.getText()), MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtVersion.getText()));
                }
            }
        });
        this.txtVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!MavenRepositorySearchDialog.this.ignoreTextChange) {
                    MavenRepositorySearchDialog.this.computeResultFromField(MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtGroupId.getText()), MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtArtifactId.getText()), MavenRepositorySearchDialog.this.valueOrNull(MavenRepositorySearchDialog.this.txtVersion.getText()));
                }
            }
        });
        this.updateStatus(this.validateArtifactEntries());
        return composite;
    }

    IStatus validateArtifactEntries() {
        if (this.txtArtifactId.getText().isEmpty()) {
            return new Status(4, "org.eclipse.m2e.core.ui", Messages.AddDependencyDialog_artifactId_error);
        }
        if (this.txtGroupId.getText().isEmpty()) {
            return new Status(4, "org.eclipse.m2e.core.ui", Messages.AddDependencyDialog_groupId_error);
        }
        return new Status(0, "org.eclipse.m2e.core.ui", "");
    }

    void okPressedDelegate() {
        this.okPressed();
    }

    void updateStatusDelegate(IStatus status) {
        IStatus validationStatus = this.validateArtifactEntries();
        if (validationStatus.isOK()) {
            this.updateStatus(status);
        } else {
            this.updateStatus(validationStatus);
        }
    }

    private String valueOrNull(String text) {
        return text.trim().length() == 0 ? null : text;
    }

    protected void computeResult() {
        if (this.showCoords) {
            this.computeResultFromField(this.valueOrNull(this.txtGroupId.getText()), this.valueOrNull(this.txtArtifactId.getText()), this.valueOrNull(this.txtVersion.getText()));
        } else {
            this.computeResultFromTree();
        }
    }

    private void computeResultFromField(String groupId, String artifactId, String version) {
        this.selectedIndexedArtifact = this.cloneIndexedArtifact(this.selectedIndexedArtifact, groupId, artifactId);
        this.selectedIndexedArtifactFile = this.cloneIndexedArtifactFile(this.selectedIndexedArtifactFile, groupId, artifactId, version);
        this.selectedScope = this.comScope == null ? null : this.comScope.getText();
        this.setResult(Collections.singletonList(this.selectedIndexedArtifactFile));
    }

    private void computeResultFromTree() {
        this.selectedIndexedArtifact = this.pomSelectionComponent.getIndexedArtifact();
        this.selectedIndexedArtifactFile = this.pomSelectionComponent.getIndexedArtifactFile();
        this.selectedScope = this.comScope == null ? null : this.comScope.getText();
        this.setResult(Collections.singletonList(this.selectedIndexedArtifactFile));
        if (this.selectedIndexedArtifactFile != null && this.showCoords) {
            this.ignoreTextChange = true;
            try {
                this.txtGroupId.setText(this.selectedIndexedArtifactFile.group);
                this.txtArtifactId.setText(this.selectedIndexedArtifactFile.artifact);
                String type = this.managed.get(new ArtifactKey(this.selectedIndexedArtifactFile.group, this.selectedIndexedArtifactFile.artifact, this.selectedIndexedArtifactFile.version, this.selectedIndexedArtifactFile.classifier));
                if (type != null) {
                    this.txtVersion.setText("");
                    if (type.length() > 0) {
                        this.selectedIndexedArtifactFile = this.cloneIndexedArtifactFile(this.selectedIndexedArtifactFile, type);
                    }
                } else {
                    this.txtVersion.setText(this.selectedIndexedArtifactFile.version);
                }
            }
            finally {
                this.ignoreTextChange = false;
            }
        }
    }

    public IndexedArtifact getSelectedIndexedArtifact() {
        return this.selectedIndexedArtifact;
    }

    public IndexedArtifactFile getSelectedIndexedArtifactFile() {
        return this.selectedIndexedArtifactFile;
    }

    public String getSelectedScope() {
        return this.selectedScope;
    }

    private IndexedArtifact cloneIndexedArtifact(IndexedArtifact old, String groupId, String artifactId) {
        if (old == null) {
            return new IndexedArtifact(groupId, artifactId, null, null, null);
        }
        return new IndexedArtifact(groupId != null ? groupId : old.getGroupId(), artifactId != null ? artifactId : old.getArtifactId(), old.getPackageName(), old.getClassname(), old.getPackaging());
    }

    private IndexedArtifactFile cloneIndexedArtifactFile(IndexedArtifactFile old, String groupId, String artifactId, String version) {
        if (old == null) {
            return new IndexedArtifactFile(null, groupId, artifactId, version, null, null, null, 0L, null, 0, 0, null, null);
        }
        return new IndexedArtifactFile(old.repository, groupId, artifactId, version, old.type, old.classifier, old.fname, old.size, old.date, old.sourcesExists, old.javadocExists, old.prefix, old.goals);
    }

    private IndexedArtifactFile cloneIndexedArtifactFile(IndexedArtifactFile old, String type) {
        if (old == null) {
            throw new IllegalArgumentException("Must call with argument type != null");
        }
        return new IndexedArtifactFile(old.repository, old.group, old.artifact, old.version, type, old.classifier, old.fname, old.size, old.date, old.sourcesExists, old.javadocExists, old.prefix, old.goals);
    }
}

