/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.facets;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public abstract class AbstractFacetDetector
implements IExecutableExtension,
Comparable<AbstractFacetDetector> {
    public static final String ATTR_ID = "id";
    public static final String ATTR_FACET_ID = "facetId";
    public static final String ATTR_PRIORITY = "priority";
    public static final String ATTR_CLASS = "class";
    private String id;
    private String facetId;
    private int priority;

    public String getId() {
        if (this.id == null) {
            this.id = this.getClass().getName();
        }
        return this.id;
    }

    public String getFacetId() {
        return this.facetId;
    }

    public abstract IProjectFacetVersion findFacetVersion(IMavenProjectFacade var1, Map<?, ?> var2, IProgressMonitor var3) throws CoreException;

    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(AbstractFacetDetector other) {
        if (other == null) {
            return this.priority;
        }
        int result = other.priority - this.priority;
        if (result == 0) {
            return 0;
        }
        return result > 0 ? -1 : 1;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.id = config.getAttribute(ATTR_ID);
        this.facetId = config.getAttribute(ATTR_FACET_ID);
        try {
            this.priority = Integer.parseInt(config.getAttribute(ATTR_PRIORITY));
        }
        catch (Exception exception) {
            this.priority = 100;
        }
    }

    public String toString() {
        return this.getId();
    }
}

