/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.ui.views;

import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.MetamodelBrowser;
import org.eclipse.m2m.internal.qvt.oml.common.ui.views.WorkspaceMetamodelsDelta;
import org.eclipse.m2m.internal.qvt.oml.emf.util.mmregistry.MetamodelRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.services.IServiceLocator;

public class MetamodelBrowserView
extends ViewPart
implements IResourceChangeListener {
    public static final String ID = "org.eclipse.m2m.internal.qvt.oml.common.views.MetamodelBrowserView";
    private MetamodelBrowser browser;

    public MetamodelBrowserView() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            this.handleResourceChanged(event);
        }
        catch (Exception e) {
            CommonUIPlugin.getPlugin().log((Object)e);
        }
    }

    private void handleResourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        final WorkspaceMetamodelsDelta wsDelta = new WorkspaceMetamodelsDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource().getType() == 1 && MetamodelRegistry.isMetamodelFileName((String)delta.getResource().getName())) {
                        if (delta.getKind() == 1) {
                            wsDelta.addAddition(delta.getFullPath());
                        } else if (delta.getKind() == 2) {
                            wsDelta.addDeletion(delta.getFullPath());
                        } else if (delta.getKind() == 4) {
                            wsDelta.addModification(delta.getFullPath());
                        } else if (delta.getKind() == 4096) {
                            wsDelta.addMove(delta.getMovedFromPath(), delta.getMovedToPath());
                        }
                    }
                    return true;
                }
            });
        }
        catch (CoreException e) {
            CommonPlugin.log((Throwable)e);
        }
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!MetamodelBrowserView.this.browser.getControl().isDisposed() && !wsDelta.isEmpty()) {
                    MetamodelBrowserView.this.browser.update(wsDelta);
                }
            }
        });
    }

    public EObject navigate(EModelElement eModelElement) {
        if (this.browser != null) {
            return this.browser.navigate(eModelElement);
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.browser = new MetamodelBrowser(parent){

            protected IServiceLocator getServiceLocator() {
                return MetamodelBrowserView.this.getSite();
            }

            protected IToolBarManager getToolBarManager() {
                return MetamodelBrowserView.super.getViewSite().getActionBars().getToolBarManager();
            }
        };
        this.getSite().setSelectionProvider((ISelectionProvider)this.browser.getViewer());
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public Object getAdapter(Class key) {
        Object adaptedObject;
        Object object = adaptedObject = this.browser != null ? this.browser.getAdapter(key) : null;
        if (adaptedObject == null) {
            adaptedObject = super.getAdapter(key);
        }
        return adaptedObject;
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }
}

