/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionCollection;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionDictionary;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.PrimitiveType;

public class ConversionUtils {
    private ConversionUtils() {
    }

    public static Object createFromString(EClassifier type, String stringValue) {
        Object value;
        if (stringValue == null) {
            return null;
        }
        if (type instanceof DictionaryType) {
            return new ConversionDictionary((DictionaryType)type).createFromString(stringValue);
        }
        if (type instanceof CollectionType) {
            return new ConversionCollection((CollectionType)type).createFromString(stringValue);
        }
        try {
            if (ConversionUtils.isIntegerType(type)) {
                return new Integer(stringValue);
            }
            if (ConversionUtils.isRealType(type)) {
                return new Double(stringValue);
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid value: '" + stringValue + "' for datatype: " + type.getName());
        }
        if (ConversionUtils.isStringType(type)) {
            return new String(stringValue);
        }
        if (ConversionUtils.isBooleanType(type)) {
            return Boolean.valueOf(stringValue);
        }
        if (type instanceof EDataType && type.getEPackage() != null && type.getEPackage().getEFactoryInstance() != null && (value = type.getEPackage().getEFactoryInstance().createFromString((EDataType)type, stringValue)) != null) {
            return value;
        }
        throw new IllegalArgumentException("Invalid value: '" + stringValue + "' for datatype: " + type.getName());
    }

    public static void setupConversionDelegate(EClassifier type) {
        EDataType.Internal internalType;
        if (type instanceof DictionaryType) {
            EDataType.Internal internalType2 = (EDataType.Internal)type;
            if (internalType2.getConversionDelegate() == null) {
                internalType2.setConversionDelegate((EDataType.Internal.ConversionDelegate)new ConversionDictionary((DictionaryType)type));
            }
        } else if (type instanceof CollectionType && (internalType = (EDataType.Internal)type).getConversionDelegate() == null) {
            internalType.setConversionDelegate((EDataType.Internal.ConversionDelegate)new ConversionCollection((CollectionType)type));
        }
    }

    private static boolean isRealType(EClassifier type) {
        return type instanceof PrimitiveType && "Real".equals(((PrimitiveType)type).getName());
    }

    private static boolean isIntegerType(EClassifier type) {
        return type instanceof PrimitiveType && "Integer".equals(((PrimitiveType)type).getName());
    }

    private static boolean isBooleanType(EClassifier type) {
        return type instanceof PrimitiveType && "Boolean".equals(((PrimitiveType)type).getName());
    }

    static boolean isStringType(EClassifier type) {
        return type instanceof PrimitiveType && "String".equals(((PrimitiveType)type).getName());
    }
}

