/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.ArrayCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.KnownCollectionInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionExtractionUtils {
    public static ICollectionExtractor findCollectionExtractor(IObject collection) throws SnapshotException {
        if (collection == null) {
            return null;
        }
        if (collection instanceof IObjectArray) {
            return ArrayCollectionExtractor.INSTANCE;
        }
        int version = KnownCollectionInfo.resolveVersion(collection.getSnapshot());
        IClass collectionClass = collection.getClazz();
        KnownCollectionInfo.Info[] infoArray = KnownCollectionInfo.knownCollections;
        int n = KnownCollectionInfo.knownCollections.length;
        int n2 = 0;
        while (n2 < n) {
            KnownCollectionInfo.Info info = infoArray[n2];
            if ((info.version & version) == version && collectionClass.doesExtend(info.className)) {
                return info.extractor;
            }
            ++n2;
        }
        return null;
    }

    public static ICollectionExtractor findCollectionExtractor(String className) throws SnapshotException {
        KnownCollectionInfo.Info[] infoArray = KnownCollectionInfo.knownCollections;
        int n = KnownCollectionInfo.knownCollections.length;
        int n2 = 0;
        while (n2 < n) {
            KnownCollectionInfo.Info info = infoArray[n2];
            if (info.className.equals(className)) {
                return info.extractor;
            }
            ++n2;
        }
        return null;
    }

    public static AbstractExtractedCollection<?, ?> extractCollection(IObject collection) throws SnapshotException {
        ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(collection);
        if (extractor == null) {
            return null;
        }
        if (extractor instanceof IMapExtractor) {
            return new ExtractedMap(collection, (IMapExtractor)extractor);
        }
        return new ExtractedCollection(collection, extractor);
    }

    public static AbstractExtractedCollection<?, ?> extractCollection(IObject collection, String specificClass, ICollectionExtractor preferredExtractor) throws SnapshotException {
        if (specificClass != null && collection.getClazz().doesExtend(specificClass)) {
            return new ExtractedCollection(collection, preferredExtractor);
        }
        return CollectionExtractionUtils.extractCollection(collection);
    }

    public static ExtractedCollection extractList(IObject collection) throws SnapshotException {
        ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(collection);
        if (extractor == null) {
            return null;
        }
        return new ExtractedCollection(collection, extractor);
    }

    public static ExtractedMap extractMap(IObject collection) throws SnapshotException {
        ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(collection);
        if (extractor == null) {
            return null;
        }
        if (extractor instanceof IMapExtractor) {
            return new ExtractedMap(collection, (IMapExtractor)extractor);
        }
        return null;
    }

    public static ExtractedMap extractMap(IObject collection, String specificClass, IMapExtractor preferredExtractor) throws SnapshotException {
        if (specificClass != null && collection.getClazz().doesExtend(specificClass)) {
            return new ExtractedMap(collection, preferredExtractor);
        }
        return CollectionExtractionUtils.extractMap(collection);
    }
}

