/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class ExtractionUtils {
    public static Integer toInteger(Object i) {
        if (i instanceof Number) {
            return ((Number)i).intValue();
        }
        return null;
    }

    public static int getNumberOfNotNullArrayElements(IObjectArray arrayObject) {
        ISnapshot snapshot = arrayObject.getSnapshot();
        try {
            int[] outs = snapshot.getOutboundReferentIds(arrayObject.getObjectId());
            if (outs.length == 1 || outs.length == arrayObject.getLength() + 1) {
                return outs.length - 1;
            }
        }
        catch (SnapshotException snapshotException) {}
        return ExtractionUtils.getNumberOfNotNullArrayElements(arrayObject.getReferenceArray());
    }

    public static int getNumberOfNotNullArrayElements(long[] addresses) {
        int result = 0;
        int i = 0;
        while (i < addresses.length) {
            if (addresses[i] != 0L) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int getNumberOfNotNullArrayElements(int[] ids) {
        int result = 0;
        int i = 0;
        while (i < ids.length) {
            if (ids[i] != 0) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public static int[] referenceArrayToIds(ISnapshot snapshot, long[] referenceArray) throws SnapshotException {
        ArrayInt arr = new ArrayInt();
        int i = 0;
        while (i < referenceArray.length) {
            if (referenceArray[i] != 0L) {
                arr.add(snapshot.mapAddressToId(referenceArray[i]));
            }
            ++i;
        }
        return arr.toArray();
    }
}

