/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.MessageUtil;

public class FieldArrayCollectionExtractor
implements ICollectionExtractor {
    protected final String arrayField;

    public FieldArrayCollectionExtractor(String arrayField) {
        if (arrayField == null) {
            throw new IllegalArgumentException();
        }
        this.arrayField = arrayField;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        return this.getNumberOfNotNullElements(coll);
    }

    public boolean hasCapacity() {
        return true;
    }

    public Integer getCapacity(IObject coll) throws SnapshotException {
        IObjectArray arrayObject = this.extractEntries(coll);
        if (arrayObject == null) {
            return null;
        }
        return arrayObject.getLength();
    }

    public boolean hasFillRatio() {
        return true;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        Integer size = this.getNumberOfNotNullElements(coll);
        Integer cap = this.getCapacity(coll);
        if (size != null && cap != null) {
            return size.doubleValue() / cap.doubleValue();
        }
        return null;
    }

    public boolean hasExtractableContents() {
        return this.hasExtractableArray();
    }

    public boolean hasExtractableArray() {
        return !this.arrayField.endsWith(".");
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        return ExtractionUtils.referenceArrayToIds(coll.getSnapshot(), this.extractEntries(coll).getReferenceArray());
    }

    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        Object obj = coll.resolveValue(this.arrayField);
        if (obj instanceof IObjectArray) {
            return (IObjectArray)obj;
        }
        if (obj instanceof IObject) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), ((IObject)obj).getTechnicalName()});
            throw new SnapshotException(msg);
        }
        if (obj != null) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), obj.toString()});
            throw new SnapshotException(msg);
        }
        IObject next = this.resolveNextFields(coll);
        if (next == null) {
            return null;
        }
        IObjectArray ret = null;
        ISnapshot snapshot = next.getSnapshot();
        int[] nArray = snapshot.getOutboundReferentIds(next.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (snapshot.isArray(i) && (o = snapshot.getObject(i)) instanceof IObjectArray) {
                if (ret != null) {
                    return null;
                }
                ret = (IObjectArray)o;
            }
            ++n2;
        }
        return ret;
    }

    protected IObject resolveNextFields(IObject collection) throws SnapshotException {
        Object ret;
        int j = this.arrayField.lastIndexOf(46);
        if (j >= 0 && (ret = collection.resolveValue(this.arrayField.substring(0, j))) instanceof IObject) {
            return (IObject)ret;
        }
        IObject next = collection;
        int i = this.arrayField.indexOf(46);
        while (i >= 0 && next != null) {
            next = this.resolveNextField(next);
            i = this.arrayField.indexOf(46, i + 1);
        }
        return next;
    }

    private IInstance resolveNextField(IObject source) throws SnapshotException {
        ISnapshot snapshot = source.getSnapshot();
        IInstance ret = null;
        int[] nArray = snapshot.getOutboundReferentIds(source.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (!snapshot.isArray(i) && !snapshot.isClass(i) && (o = snapshot.getObject(i)) instanceof IInstance) {
                if (ret != null) {
                    ret = null;
                    break;
                }
                ret = (IInstance)o;
            }
            ++n2;
        }
        return ret;
    }

    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        IObjectArray arrayObject = this.extractEntries(coll);
        if (arrayObject == null) {
            return null;
        }
        return ExtractionUtils.getNumberOfNotNullArrayElements(arrayObject);
    }
}

