/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class FieldSizedCollectionExtractor
implements ICollectionExtractor {
    private final String sizeField;

    public FieldSizedCollectionExtractor(String sizeField) {
        if (sizeField == null) {
            throw new IllegalArgumentException();
        }
        this.sizeField = sizeField;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        Object value = coll.resolveValue(this.sizeField);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Long) {
            return ((Long)value).intValue();
        }
        return null;
    }

    public boolean hasCapacity() {
        return false;
    }

    public Integer getCapacity(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public boolean hasExtractableContents() {
        return false;
    }

    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public boolean hasExtractableArray() {
        return false;
    }

    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public Integer getNumberOfNotNullElements(IObject collection) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    public boolean hasFillRatio() {
        return false;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        return null;
    }
}

