/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.MapCollectionExtractorBase;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.util.MessageUtil;

public abstract class HashedMapCollectionExtractorBase
extends MapCollectionExtractorBase {
    protected final String arrayField;

    public HashedMapCollectionExtractorBase(String sizeField, String arrayField, String keyField, String valueField) {
        super(sizeField, keyField, valueField);
        this.arrayField = arrayField;
    }

    public boolean hasSize() {
        return true;
    }

    public Integer getSize(IObject coll) throws SnapshotException {
        Integer ret = super.getSize(coll);
        if (ret != null) {
            return ret;
        }
        if (this.hasExtractableContents()) {
            return this.getMapSize(coll, this.extractEntryIds(coll));
        }
        IObject header = this.resolveNextFields(coll);
        if (header != null) {
            ISnapshot snapshot = coll.getSnapshot();
            return this.getMapSize(coll, snapshot.getOutboundReferentIds(header.getObjectId()));
        }
        return null;
    }

    public boolean hasFillRatio() {
        return true;
    }

    public Double getFillRatio(IObject coll) throws SnapshotException {
        Integer size = this.getSize(coll);
        Integer cap = this.getCapacity(coll);
        if (size != null && cap != null) {
            return size.doubleValue() / cap.doubleValue();
        }
        return 1.0;
    }

    public boolean hasCollisionRatio() {
        return true;
    }

    public Double getCollisionRatio(IObject coll) throws SnapshotException {
        Integer size = this.getSize(coll);
        if (size == null || size <= 0) {
            return 0.0;
        }
        return (double)(size - this.getNumberOfNotNullElements(coll)) / (double)size.intValue();
    }

    protected IObjectArray extractBackingArray(IObject coll) throws SnapshotException {
        Object obj = coll.resolveValue(this.arrayField);
        IObjectArray ret = null;
        if (obj instanceof IObjectArray) {
            return (IObjectArray)obj;
        }
        if (obj instanceof IObject) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), ((IObject)obj).getTechnicalName()});
            throw new SnapshotException(msg);
        }
        if (obj != null) {
            String msg = MessageUtil.format((String)Messages.CollectionUtil_BadBackingArray, (Object[])new Object[]{this.arrayField, coll.getTechnicalName(), obj.toString()});
            throw new SnapshotException(msg);
        }
        IObject next = this.resolveNextFields(coll);
        if (next == null) {
            return null;
        }
        ISnapshot snapshot = next.getSnapshot();
        int[] nArray = snapshot.getOutboundReferentIds(next.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (snapshot.isArray(i) && (o = snapshot.getObject(i)) instanceof IObjectArray) {
                if (ret != null) {
                    return null;
                }
                ret = (IObjectArray)o;
            }
            ++n2;
        }
        return ret;
    }

    private int getMapSize(IObject collection, int[] objects) throws SnapshotException {
        int count = 0;
        ISnapshot snapshot = collection.getSnapshot();
        BitField seen = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
        ArrayInt extra = new ArrayInt();
        int[] nArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (!(snapshot.isClass(i) || seen.get(i) || snapshot.getClassOf(i).getName().equals("java.lang.Object"))) {
                extra.clear();
                extra.add(i);
                seen.set(i);
                int k = 0;
                while (k < extra.size()) {
                    int j = extra.get(k);
                    while (j >= 0) {
                        ++count;
                        j = this.resolveNextSameField(snapshot, j, seen, extra);
                    }
                    ++k;
                }
            }
            ++n2;
        }
        return count;
    }

    int resolveNextSameField(ISnapshot snapshot, int sourceId, BitField seen, ArrayInt extra) throws SnapshotException {
        int ret = -1;
        IClass c1 = snapshot.getClassOf(sourceId);
        int[] nArray = snapshot.getOutboundReferentIds(sourceId);
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClass c2;
            int i = nArray[n2];
            if (!snapshot.isArray(i) && !snapshot.isClass(i) && c1.equals(c2 = snapshot.getClassOf(i)) && !seen.get(i)) {
                seen.set(i);
                if (ret == -1) {
                    ret = i;
                } else {
                    extra.add(i);
                }
            }
            ++n2;
        }
        return ret;
    }

    protected IObject resolveNextFields(IObject collection) throws SnapshotException {
        Object ret;
        int j = this.arrayField.lastIndexOf(46);
        if (j >= 0 && (ret = collection.resolveValue(this.arrayField.substring(0, j))) instanceof IObject) {
            return (IObject)ret;
        }
        IObject next = collection;
        int i = this.arrayField.indexOf(46);
        while (i >= 0 && next != null) {
            next = this.resolveNextField(next);
            i = this.arrayField.indexOf(46, i + 1);
        }
        return next;
    }

    private IInstance resolveNextField(IObject source) throws SnapshotException {
        ISnapshot snapshot = source.getSnapshot();
        IInstance ret = null;
        int[] nArray = snapshot.getOutboundReferentIds(source.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (!snapshot.isArray(i) && !snapshot.isClass(i) && (o = snapshot.getObject(i)) instanceof IInstance) {
                if (ret != null) {
                    ret = null;
                    break;
                }
                ret = (IInstance)o;
            }
            ++n2;
        }
        return ret;
    }
}

