/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import java.util.Collection;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.collectionextract.ConcurrentHashMapCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.ConcurrentSkipListCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.EmptyCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.EmptyMapExtractor;
import org.eclipse.mat.internal.collectionextract.FieldArrayCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.FieldSizeArrayCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.FieldSizedCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.HashMapCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.HashSetCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.IBM6ArrayListCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.IdentityHashMapCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.LinkedListCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.NoContentCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.ReplicatedValueCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.SingletonCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.SingletonMapExtractor;
import org.eclipse.mat.internal.collectionextract.TreeMapCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.WrapperCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.WrapperMapExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;

public class KnownCollectionInfo {
    public static Info[] knownCollections = new Info[]{new Info("java.util.Collections$EmptyList", new EmptyCollectionExtractor()), new Info("java.util.Collections$EmptySet", new EmptyCollectionExtractor()), new Info("java.util.Collections$EmptyMap", new EmptyMapExtractor()), new Info("com.sap.engine.lib.util.AbstractDataStructure", new EmptyCollectionExtractor()), new Info("java.util.concurrent.SynchronousQueue", new EmptyCollectionExtractor()), new Info("java.util.concurrent.ConcurrentLinkedBlockingDeque", new FieldSizedCollectionExtractor("count")), new Info("java.util.concurrent.ConcurrentLinkedBlockingQueue", new FieldSizedCollectionExtractor("count.value")), new Info("java.util.concurrent.LinkedBlockingDeque", new FieldSizedCollectionExtractor("count")), new Info("java.util.concurrent.LinkedBlockingQueue", new FieldSizedCollectionExtractor("count.value")), new Info("java.util.concurrent.CopyOnWriteArrayList", new FieldArrayCollectionExtractor("array")), new Info("java.util.concurrent.CopyOnWriteArraySet", new FieldArrayCollectionExtractor("al.array")), new Info("java.util.ArrayList", -9, new FieldSizeArrayCollectionExtractor("size", "elementData")), new Info("java.util.LinkedList", -9, new LinkedListCollectionExtractor("size", "header")), new Info("java.util.LinkedList", 8, new LinkedListCollectionExtractor("size", "voidLink")), new Info("java.util.Vector", new FieldSizeArrayCollectionExtractor("elementCount", "elementData")), new Info("java.util.PriorityQueue", -13, new FieldSizeArrayCollectionExtractor("size", "queue")), new Info("java.util.PriorityQueue", 12, new FieldSizeArrayCollectionExtractor("size", "elements")), new Info("java.util.concurrent.DelayQueue", -13, new FieldSizeArrayCollectionExtractor("q.size", "q.queue")), new Info("java.util.concurrent.DelayQueue", 12, new FieldSizeArrayCollectionExtractor("q.size", "q.elements")), new Info("java.util.ArrayList", 8, new IBM6ArrayListCollectionExtractor("firstIndex", "lastIndex", "array")), new Info("java.util.ArrayDeque", -9, new IBM6ArrayListCollectionExtractor("head", "tail", "elements")), new Info("java.util.ArrayDeque", 8, new IBM6ArrayListCollectionExtractor("front", "rear", "elements")), new Info("java.util.IdentityHashMap", -15, new IdentityHashMapCollectionExtractor("size", "table")), new Info("java.util.IdentityHashMap", 6, new IdentityHashMapCollectionExtractor("size", "table")), new Info("java.util.IdentityHashMap", 8, new IdentityHashMapCollectionExtractor("size", "elementData")), new Info("java.util.HashMap", -9, new HashMapCollectionExtractor("size", "table", "key", "value")), new Info("java.util.HashMap", 8, new HashMapCollectionExtractor("elementCount", "elementData", "key", "value")), new Info("java.util.LinkedHashMap", 4, new HashMapCollectionExtractor("size", "table", "key", "value")), new Info("java.beans.beancontext.BeanContextSupport", -9, new HashMapCollectionExtractor("children.size", "children.table", "key", "value")), new Info("java.beans.beancontext.BeanContextSupport", 8, new HashMapCollectionExtractor("children.elementCount", "children.elementData", "key", "value")), new Info("com.ibm.jvm.util.HashMapRT", 12, new HashMapCollectionExtractor("size", "table", "key", "value")), new Info("java.util.HashSet", -9, new HashSetCollectionExtractor("map.size", "map.table", "key", "value")), new Info("java.util.HashSet", 8, new HashSetCollectionExtractor("backingMap.elementCount", "backingMap.elementData", "key", "value")), new Info("javax.script.SimpleBindings", -9, new HashMapCollectionExtractor("map.size", "map.table", "key", "value")), new Info("javax.script.SimpleBindings", 8, new HashMapCollectionExtractor("map.elementCount", "map.elementData", "key", "value")), new Info("java.util.jar.Attributes", -9, new HashMapCollectionExtractor("map.size", "map.table", "key", "value")), new Info("java.util.jar.Attributes", 8, new HashMapCollectionExtractor("map.elementCount", "map.elementData", "key", "value")), new Info("java.util.LinkedHashSet", 4, new HashSetCollectionExtractor("map.size", "map.table", "key", "value")), new Info("java.util.Hashtable", -13, new HashMapCollectionExtractor("count", "table", "key", "value")), new Info("java.util.Hashtable", 12, new HashMapCollectionExtractor("elementCount", "elementData", "key", "value")), new Info("java.util.Properties", 12, new HashMapCollectionExtractor("elementCount", "elementData", "key", "value")), new Info("java.util.WeakHashMap", -9, new HashMapCollectionExtractor("size", "table", "referent", "value")), new Info("java.util.WeakHashMap", 8, new HashMapCollectionExtractor("elementCount", "elementData", "referent", "value")), new Info("java.lang.ThreadLocal$ThreadLocalMap", 127, new HashMapCollectionExtractor("size", "table", "referent", "value")), new Info("java.util.concurrent.ConcurrentHashMap$Segment", new HashMapCollectionExtractor("count", "table", "key", "value")), new Info("java.util.concurrent.ConcurrentHashMap", 96, new HashMapCollectionExtractor("baseCount", "table", "key", "value")), new Info("java.util.concurrent.ConcurrentSkipListSet", -1, new ConcurrentSkipListCollectionExtractor("m.head.node.", "key", "value")), new Info("java.util.concurrent.ConcurrentSkipListMap", -1, new ConcurrentSkipListCollectionExtractor("head.node.", "key", "value")), new Info("java.util.TreeMap", -9, new TreeMapCollectionExtractor("size", "key", "value")), new Info("java.util.TreeMap", 8, new TreeMapCollectionExtractor("size", "keys[]", "values[]")), new Info("java.util.TreeSet", -9, new TreeMapCollectionExtractor("m.size", "key", "value")), new Info("java.util.TreeSet", 8, new TreeMapCollectionExtractor("backingMap.size", "keys[]", "values[]")), new Info("java.util.concurrent.ConcurrentHashMap", -97, new ConcurrentHashMapCollectionExtractor("segments", "key", "value")), new Info("java.util.Collections$SynchronizedCollection", new WrapperCollectionExtractor("c")), new Info("java.util.Collections$UnmodifiableCollection", new WrapperCollectionExtractor("c")), new Info("java.util.Collections$UnmodifiableMap", new WrapperMapExtractor("m")), new Info("java.util.Collections$SynchronizedMap", new WrapperMapExtractor("m")), new Info("java.util.Collections$CheckedCollection", new WrapperCollectionExtractor("c")), new Info("java.util.Collections$CheckedMap", new WrapperCollectionExtractor("m")), new Info("java.util.Collections$CheckedMap$CheckedEntrySet", new WrapperCollectionExtractor("s")), new Info("java.util.Collections$SingletonSet", new SingletonCollectionExtractor("element")), new Info("java.util.Collections$SingletonList", new SingletonCollectionExtractor("element")), new Info("java.util.Collections$SingletonMap", new SingletonMapExtractor("k", "v")), new Info("java.util.Collections$CopiesList", new ReplicatedValueCollectionExtractor("n", "element")), new Info("sun.util.PreHashedMap", new NoContentCollectionExtractor()), new Info("sun.misc.SoftCache", new NoContentCollectionExtractor()), new Info("java.util.AbstractList", new NoContentCollectionExtractor())};

    public static int resolveVersion(ISnapshot snapshot) throws SnapshotException {
        Object ver;
        Collection<IClass> classes;
        String jreVersion;
        int jreIndex;
        String jvmInfo = snapshot.getSnapshotInfo().getJvmInfo();
        if (jvmInfo != null && (jvmInfo.contains("IBM") || jvmInfo.contains(" build ")) && (jreIndex = jvmInfo.indexOf("JRE ")) != -1 && (jreVersion = jvmInfo.substring(jreIndex + 4)).length() >= 3) {
            if ((jreVersion = jreVersion.substring(0, 3)).equals("1.8")) {
                return 32;
            }
            if (jreVersion.equals("1.7")) {
                if (jvmInfo.matches(".*\\(SR[1-3][^0-9].*") || jvmInfo.matches(".*\\(GA")) {
                    return 8;
                }
                return 16;
            }
            if (jreVersion.equals("1.6")) {
                return 8;
            }
            if (jreVersion.equals("1.5")) {
                return 4;
            }
            if (jreVersion.equals("1.4")) {
                return 2;
            }
        }
        if ((classes = snapshot.getClassesByName("com.ibm.misc.JavaRuntimeVersion", false)) != null && !classes.isEmpty()) {
            return 4;
        }
        classes = snapshot.getClassesByName("com.ibm.oti.vm.BootstrapClassLoader", false);
        if (classes != null && !classes.isEmpty()) {
            return 8;
        }
        classes = snapshot.getClassesByName("com.ibm.jvm.Trace", false);
        if (classes != null && !classes.isEmpty()) {
            return 2;
        }
        classes = snapshot.getClassesByName("sun.misc.Version", false);
        if (classes != null && classes.size() > 0 && (ver = classes.iterator().next().resolveValue("java_version")) instanceof IObject && ((IObject)ver).getClassSpecificName().startsWith("1.8.")) {
            return 64;
        }
        return 1;
    }

    public static class Info {
        public final String className;
        public final int version;
        public final ICollectionExtractor extractor;

        public Info(String className, ICollectionExtractor extractor) {
            this(className, -1, extractor);
        }

        public Info(String className, int version, ICollectionExtractor extractor) {
            if (className == null) {
                throw new IllegalArgumentException();
            }
            if (extractor == null) {
                throw new IllegalArgumentException();
            }
            this.className = className;
            this.version = version;
            this.extractor = extractor;
        }
    }

    public static interface Version {
        public static final int SUN = 1;
        public static final int IBM14 = 2;
        public static final int IBM15 = 4;
        public static final int IBM16 = 8;
        public static final int IBM17 = 16;
        public static final int IBM18 = 32;
        public static final int JAVA18 = 64;
        public static final int ALL = -1;
    }
}

