/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.FieldSizedCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IInstance;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.VoidProgressListener;

public class LinkedListCollectionExtractor
extends FieldSizedCollectionExtractor {
    private final String leadField;

    public LinkedListCollectionExtractor(String sizeField, String leadField) {
        super(sizeField);
        this.leadField = leadField;
    }

    public boolean hasExtractableContents() {
        return true;
    }

    public int[] extractEntryIds(IObject list) throws SnapshotException {
        VoidProgressListener listener = new VoidProgressListener();
        int size = this.getSize(list);
        String taskMsg = MessageUtil.format((String)Messages.ExtractListValuesQuery_CollectingElements, (Object[])new Object[]{size, list.getTechnicalName()});
        listener.beginTask(taskMsg, size);
        ArrayInt result = new ArrayInt();
        int loopingLimit = size;
        IObject header = (IObject)list.resolveValue("header");
        if (header == null) {
            header = (IObject)list.resolveValue("voidLink");
        }
        if (header == null) {
            header = (IObject)list.resolveValue("first");
        }
        if (header == null) {
            header = this.resolveNextFields(list);
        }
        if (header == null) {
            return null;
        }
        IObject previous = header;
        IObject current = header;
        if (!current.getClazz().getName().equals("java.util.LinkedList$Node")) {
            current = (IObject)header.resolveValue("next");
            if (current == null) {
                ISnapshot snapshot = header.getSnapshot();
                int[] nArray = snapshot.getOutboundReferentIds(header.getObjectId());
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    IObject o = snapshot.getObject(i);
                    if (i != header.getClazz().getObjectId() && o.getClazz().equals(header.getClazz())) {
                        current = o;
                        break;
                    }
                    ++n2;
                }
            }
        } else {
            header = null;
        }
        while (current != null && current != header && loopingLimit-- > 0) {
            IObject next;
            IObject ref = (IObject)current.resolveValue("element");
            if (ref == null) {
                ref = (IObject)current.resolveValue("data");
            }
            if (ref == null) {
                ref = (IObject)current.resolveValue("item");
            }
            if ((next = (IObject)current.resolveValue("next")) == null) {
                ISnapshot snapshot = current.getSnapshot();
                int[] nArray = snapshot.getOutboundReferentIds(current.getObjectId());
                int n = nArray.length;
                int n3 = 0;
                while (n3 < n) {
                    int i = nArray[n3];
                    IObject o = snapshot.getObject(i);
                    if (i != previous.getObjectId() && i != current.getClazz().getObjectId()) {
                        if (o.getClazz().equals(current.getClazz())) {
                            if (next != null) {
                                next = null;
                                break;
                            }
                            next = o;
                        } else if (ref == null) {
                            ref = o;
                        }
                    }
                    ++n3;
                }
            }
            if (ref != null) {
                result.add(ref.getObjectId());
            }
            previous = current;
            current = next;
            listener.worked(1);
            if (listener.isCanceled()) break;
        }
        listener.done();
        return result.toArray();
    }

    protected IObject resolveNextFields(IObject collection) throws SnapshotException {
        Object ret;
        int j = this.leadField.lastIndexOf(46);
        if (j >= 0 && (ret = collection.resolveValue(this.leadField.substring(0, j))) instanceof IObject) {
            return (IObject)ret;
        }
        IObject next = collection;
        int i = this.leadField.indexOf(46);
        while (i >= 0 && next != null) {
            next = this.resolveNextField(next);
            i = this.leadField.indexOf(46, i + 1);
        }
        return next;
    }

    private IInstance resolveNextField(IObject source) throws SnapshotException {
        ISnapshot snapshot = source.getSnapshot();
        IInstance ret = null;
        int[] nArray = snapshot.getOutboundReferentIds(source.getObjectId());
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            IObject o;
            int i = nArray[n2];
            if (!snapshot.isArray(i) && !snapshot.isClass(i) && (o = snapshot.getObject(i)) instanceof IInstance) {
                if (ret != null) {
                    ret = null;
                    break;
                }
                ret = (IInstance)o;
            }
            ++n2;
        }
        return ret;
    }
}

