/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.collect;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.mat.collect.IteratorLong;
import org.eclipse.mat.collect.PrimeFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HashMapObjectLong<E>
implements Serializable {
    private static final NoSuchElementException noSuchElementException = new NoSuchElementException("This is static exception, there is no stack trace available. It is thrown by get() method.");
    private static final long serialVersionUID = 1L;
    private int capacity;
    private int step;
    private int limit;
    private int size;
    private boolean[] used;
    private Object[] keys;
    private long[] values;

    public HashMapObjectLong() {
        this(10);
    }

    public HashMapObjectLong(int initialCapacity) {
        this.init(initialCapacity);
    }

    public boolean put(E key, long value) {
        if (this.size == this.limit) {
            this.resize(this.capacity << 1);
        }
        int hash = this.hashOf(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash].equals(key)) {
                this.values[hash] = value;
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        this.used[hash] = true;
        this.keys[hash] = key;
        this.values[hash] = value;
        ++this.size;
        return false;
    }

    public boolean remove(E key) {
        Object keyObj = key;
        int hash = this.hashOf(keyObj) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash].equals(keyObj)) {
                this.used[hash] = false;
                --this.size;
                hash = (hash + this.step) % this.capacity;
                while (this.used[hash]) {
                    keyObj = this.keys[hash];
                    this.used[hash] = false;
                    int newHash = this.hashOf(keyObj) % this.capacity;
                    while (this.used[newHash]) {
                        newHash = (newHash + this.step) % this.capacity;
                    }
                    this.used[newHash] = true;
                    this.keys[newHash] = keyObj;
                    this.values[newHash] = this.values[hash];
                    hash = (hash + this.step) % this.capacity;
                }
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public boolean containsKey(E key) {
        int hash = this.hashOf(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash].equals(key)) {
                return true;
            }
            hash = (hash + this.step) % this.capacity;
        }
        return false;
    }

    public long get(E key) {
        int hash = this.hashOf(key) % this.capacity;
        while (this.used[hash]) {
            if (this.keys[hash].equals(key)) {
                return this.values[hash];
            }
            hash = (hash + this.step) % this.capacity;
        }
        throw noSuchElementException;
    }

    public Object[] getAllKeys() {
        Object[] array = new Object[this.size];
        int j = 0;
        int i = 0;
        while (i < this.used.length) {
            if (this.used[i]) {
                array[j++] = this.keys[i];
            }
            ++i;
        }
        return array;
    }

    public <T> T[] getAllKeys(T[] a) {
        if (a.length < this.size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.size);
        }
        int j = 0;
        int ii = 0;
        while (ii < this.used.length) {
            if (this.used[ii]) {
                a[j++] = this.keys[ii];
            }
            ++ii;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.size = 0;
        this.used = new boolean[this.capacity];
    }

    public Iterator<E> keys() {
        return new Iterator<E>(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapObjectLong.this.size;
            }

            @Override
            public E next() throws NoSuchElementException {
                while (++this.i < HashMapObjectLong.this.used.length) {
                    if (!HashMapObjectLong.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapObjectLong.this.keys[this.i];
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public IteratorLong values() {
        return new IteratorLong(){
            int n = 0;
            int i = -1;

            public boolean hasNext() {
                return this.n < HashMapObjectLong.this.size;
            }

            public long next() throws NoSuchElementException {
                while (++this.i < HashMapObjectLong.this.used.length) {
                    if (!HashMapObjectLong.this.used[this.i]) continue;
                    ++this.n;
                    return HashMapObjectLong.this.values[this.i];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public Iterator<Entry<E>> entries() {
        return new Iterator<Entry<E>>(){
            int n = 0;
            int i = -1;

            @Override
            public boolean hasNext() {
                return this.n < HashMapObjectLong.this.size;
            }

            @Override
            public Entry<E> next() throws NoSuchElementException {
                while (++this.i < HashMapObjectLong.this.used.length) {
                    if (!HashMapObjectLong.this.used[this.i]) continue;
                    ++this.n;
                    return new Entry<E>(){

                        @Override
                        public E getKey() {
                            return HashMapObjectLong.this.keys[i];
                        }

                        @Override
                        public long getValue() {
                            return HashMapObjectLong.this.values[i];
                        }
                    };
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() throws UnsupportedOperationException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public long[] getAllValues() {
        long[] a = new long[this.size];
        int index = 0;
        int ii = 0;
        while (ii < this.values.length) {
            if (this.used[ii]) {
                a[index++] = this.values[ii];
            }
            ++ii;
        }
        return a;
    }

    private void init(int initialCapacity) {
        this.capacity = PrimeFinder.findNextPrime(initialCapacity);
        this.step = Math.max(1, PrimeFinder.findPrevPrime(initialCapacity / 3));
        this.limit = (int)((double)this.capacity * 0.75);
        this.clear();
        this.keys = new Object[this.capacity];
        this.values = new long[this.capacity];
    }

    private void resize(int newCapacity) {
        int oldSize = this.size;
        boolean[] oldUsed = this.used;
        Object[] oldKeys = this.keys;
        long[] oldValues = this.values;
        this.init(newCapacity);
        int i = 0;
        while (i < oldUsed.length) {
            if (oldUsed[i]) {
                Object key = oldKeys[i];
                int hash = this.hashOf(key) % this.capacity;
                while (this.used[hash]) {
                    hash = (hash + this.step) % this.capacity;
                }
                this.used[hash] = true;
                this.keys[hash] = key;
                this.values[hash] = oldValues[i];
            }
            ++i;
        }
        this.size = oldSize;
    }

    private int hashOf(Object obj) {
        return obj.hashCode() & Integer.MAX_VALUE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Entry<E> {
        public E getKey();

        public long getValue();
    }
}

