/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerFactory;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedContentProviderFactory;
import org.eclipse.emf.facet.custom.ui.ICustomizedLabelProvider;
import org.eclipse.emf.facet.custom.ui.ICustomizedTreeContentProvider;
import org.eclipse.emf.facet.custom.ui.IResolvingCustomizedLabelProviderFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerFactory;
import org.eclipse.emf.facet.efacet.core.IFacetManagerListener;
import org.eclipse.emf.facet.efacet.core.IFacetManagerProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.modisco.infra.browser.editor.ui.internal.Activator;
import org.eclipse.modisco.infra.browser.editor.ui.internal.opener.ResourceEditorInput;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class TreeEditor
extends EditorPart
implements IEditingDomainProvider,
IFacetManagerProvider,
ICustomizationManagerProvider {
    private static final String EDITOR_ID = String.valueOf(Activator.getDefault().getBundle().getSymbolicName()) + ".TreeEditor";
    private Resource resource;
    private ResourceSet resourceSet;
    private EditingDomain editingDomain;
    private IFacetManager facetManager;
    private ICustomizationManager customManager;
    private TreeViewer tree;
    private IFacetManagerListener facetMgrListener;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEI = (FileEditorInput)input;
            IFile file = fileEI.getFile();
            IPath path = file.getFullPath();
            String pathStr = path.toString();
            URI uri = URI.createPlatformResourceURI((String)pathStr, (boolean)true);
            this.resourceSet = new ResourceSetImpl();
            this.resource = this.resourceSet.getResource(uri, true);
        } else if (input instanceof ResourceEditorInput) {
            ResourceEditorInput resourceEI = (ResourceEditorInput)input;
            this.resource = resourceEI.getResource();
            this.resourceSet = this.resource.getResourceSet();
        }
        AdapterFactoryImpl adapterFactory = new AdapterFactoryImpl();
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, this.resourceSet);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.tree.getControl());
        this.tree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.tree);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.tree = new TreeViewer(parent);
        this.facetManager = IFacetManagerFactory.DEFAULT.getOrCreateFacetManager(this.resourceSet);
        this.customManager = ICustomizationManagerFactory.DEFAULT.getOrCreateICustomizationManager(this.resourceSet);
        ICustomizedLabelProvider labelProvider = IResolvingCustomizedLabelProviderFactory.DEFAULT.createCustomizedLabelProvider(this.customManager);
        ICustomizedTreeContentProvider contentProvider = ICustomizedContentProviderFactory.DEFAULT.createCustomizedTreeContentProvider(this.customManager);
        this.tree.setContentProvider((IContentProvider)contentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tree.setInput((Object)this.resource.getContents());
        this.getSite().setSelectionProvider((ISelectionProvider)this.tree);
        this.facetMgrListener = new IFacetManagerListener(){

            public void facetManagerChanged() {
                TreeEditor.this.refresh();
            }
        };
        this.createPopupMenu();
        this.facetManager.addListener(this.facetMgrListener);
    }

    protected void refresh() {
        Object[] expanededElts = this.tree.getExpandedElements();
        this.tree.refresh();
        this.tree.setExpandedElements(expanededElts);
    }

    public void setFocus() {
    }

    public static String getEditorId() {
        return EDITOR_ID;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Object getAdapter(Class adapter) {
        Object result = null;
        result = adapter.isInstance((Object)this) ? this : (adapter == ISelectionProvider.class ? this.tree : super.getAdapter(adapter));
        return result;
    }

    public ICustomizationManager getCustomizationManager() {
        return this.customManager;
    }

    public IFacetManager getFacetManager() {
        return this.facetManager;
    }

    public void dispose() {
        this.facetManager.removeListener(this.facetMgrListener);
        super.dispose();
    }

    public ILabelProvider getViewerLabelProvider() {
        return (ILabelProvider)this.tree.getLabelProvider();
    }
}

