/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.facet.custom.core.ICustomizationManager;
import org.eclipse.emf.facet.custom.core.ICustomizationManagerProvider;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManager;
import org.eclipse.emf.facet.efacet.core.IFacetSetCatalogManagerFactory;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractFacetSetActivatorHandler
extends AbstractHandler {
    protected static Object execute(ExecutionEvent event, String facetSetID) throws ExecutionException {
        ICustomizationManagerProvider customMgrProvider;
        boolean toggle = HandlerUtil.toggleCommandState((Command)event.getCommand());
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart != null && (customMgrProvider = (ICustomizationManagerProvider)activePart.getAdapter(ICustomizationManagerProvider.class)) != null) {
            AbstractFacetSetActivatorHandler.execute(facetSetID, toggle, customMgrProvider);
        }
        return null;
    }

    private static void execute(String facetSetID, boolean toggle, ICustomizationManagerProvider customMgrProvider) {
        ICustomizationManager manager = customMgrProvider.getCustomizationManager();
        IFacetSetCatalogManager catalog = IFacetSetCatalogManagerFactory.DEFAULT.getOrCreateFacetSetCatalogManager(manager.getResourceSet());
        FacetSet facetSetToActive = null;
        for (FacetSet facetSet : catalog.getRegisteredFacetSets()) {
            if (!facetSetID.equals(facetSet.getName())) continue;
            facetSetToActive = facetSet;
            break;
        }
        if (facetSetToActive != null) {
            IFacetManager facetManager = manager.getFacetManager();
            List managedFacetSets = facetManager.getManagedFacetSets();
            if (toggle) {
                managedFacetSets.remove(facetSetToActive);
            } else if (!managedFacetSets.contains(facetSetToActive)) {
                managedFacetSets.add(0, facetSetToActive);
            }
        }
    }
}

