/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.editor.ui.internal.handlers;

import java.util.List;
import org.eclipse.emf.facet.efacet.core.IFacetManager;
import org.eclipse.emf.facet.efacet.core.IFacetManagerListener;
import org.eclipse.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;
import org.eclipse.jface.commands.ToggleState;
import org.eclipse.modisco.infra.browser.editor.ui.internal.editor.TreeEditor;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractFacetSetActivatorToggleState
extends ToggleState {
    private final IPartListener partListener;
    private final IFacetManagerListener facetMgrListener;
    private IFacetManager facetManager;
    private final String facetSetID;

    protected AbstractFacetSetActivatorToggleState(String facetSetID) {
        this.setShouldPersist(false);
        this.setValue(Boolean.FALSE);
        this.facetSetID = facetSetID;
        this.partListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
                AbstractFacetSetActivatorToggleState.this.partActivated(part);
            }
        };
        this.facetMgrListener = new IFacetManagerListener(){

            public void facetManagerChanged() {
                AbstractFacetSetActivatorToggleState.this.changeToggleState();
            }
        };
    }

    protected void partActivated(IWorkbenchPart part) {
        if (part instanceof TreeEditor) {
            TreeEditor treeEditor = (TreeEditor)part;
            this.facetManager = treeEditor.getFacetManager();
            this.facetManager.removeListener(this.facetMgrListener);
            this.facetManager.addListener(this.facetMgrListener);
            this.changeToggleState();
        }
    }

    protected void changeToggleState() {
        List facetSets = this.facetManager.getManagedFacetSets();
        for (FacetSet facetSet : facetSets) {
            if (this.facetSetID.equals(facetSet.getName())) {
                this.setValue(Boolean.TRUE);
                break;
            }
            if (this.getValue().equals(Boolean.FALSE)) continue;
            this.setValue(Boolean.FALSE);
        }
    }

    public Object getValue() {
        IWorkbenchPage activePage;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (activePage = window.getActivePage()) != null) {
            activePage.removePartListener(this.partListener);
            activePage.addPartListener(this.partListener);
        }
        return super.getValue();
    }
}

