/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import java.net.MalformedURLException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.client.TracException;
import org.eclipse.mylyn.internal.trac.core.client.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.client.TracPermissionDeniedException;
import org.eclipse.mylyn.internal.trac.core.model.TracRepositoryInfo;
import org.eclipse.mylyn.internal.trac.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class TracRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String TITLE = Messages.TracRepositorySettingsPage_Trac_Repository_Settings;
    private static final String DESCRIPTION = Messages.TracRepositorySettingsPage_EXAMPLE_HTTP_TRAC_EDGEWALL_ORG;
    private Combo accessTypeCombo;
    private ITracClient.Version[] versions;

    public TracRepositorySettingsPage(TaskRepository taskRepository) {
        super(TITLE, DESCRIPTION, taskRepository);
        this.setNeedsCertAuth(true);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsEncoding(false);
        this.setNeedsTimeZone(false);
    }

    protected void repositoryTemplateSelected(RepositoryTemplate template) {
        this.repositoryLabelEditor.setStringValue(template.label);
        this.setUrl(template.repositoryUrl);
        this.setAnonymous(template.anonymous);
        try {
            ITracClient.Version version = ITracClient.Version.valueOf((String)template.version);
            this.setTracVersion(version);
        }
        catch (RuntimeException runtimeException) {
            this.setTracVersion(ITracClient.Version.TRAC_0_9);
        }
        this.getContainer().updateButtons();
    }

    protected void createAdditionalControls(Composite parent) {
        this.addRepositoryTemplatesToServerUrlCombo();
        Label accessTypeLabel = new Label(parent, 0);
        accessTypeLabel.setText(Messages.TracRepositorySettingsPage_Access_Type_);
        this.accessTypeCombo = new Combo(parent, 8);
        this.accessTypeCombo.add(Messages.TracRepositorySettingsPage_Automatic__Use_Validate_Settings_);
        ITracClient.Version[] versionArray = this.versions = ITracClient.Version.values();
        int n = this.versions.length;
        int n2 = 0;
        while (n2 < n) {
            ITracClient.Version version = versionArray[n2];
            this.accessTypeCombo.add(version.toString());
            ++n2;
        }
        if (this.repository != null) {
            this.setTracVersion(ITracClient.Version.fromVersion((String)this.repository.getVersion()));
        } else {
            this.setTracVersion(null);
        }
        this.accessTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TracRepositorySettingsPage.this.accessTypeCombo.getSelectionIndex() > 0) {
                    TracRepositorySettingsPage.this.setVersion(TracRepositorySettingsPage.this.versions[TracRepositorySettingsPage.this.accessTypeCombo.getSelectionIndex() - 1].name());
                }
                TracRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.accessTypeCombo != null && this.accessTypeCombo.getSelectionIndex() != 0;
    }

    protected boolean isValidUrl(String url) {
        boolean isValid = super.isValidUrl(url);
        return isValid && !url.endsWith("/");
    }

    public ITracClient.Version getTracVersion() {
        if (this.accessTypeCombo.getSelectionIndex() == 0) {
            return null;
        }
        return this.versions[this.accessTypeCombo.getSelectionIndex() - 1];
    }

    public void setTracVersion(ITracClient.Version version) {
        if (version == null) {
            this.accessTypeCombo.select(0);
        } else {
            int i = this.accessTypeCombo.indexOf(version.toString());
            if (i != -1) {
                this.accessTypeCombo.select(i);
            }
            this.setVersion(version.name());
        }
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        if (((TracValidator)validator).getResult() != null) {
            this.setTracVersion(((TracValidator)validator).getResult());
            this.getContainer().updateButtons();
        }
        super.applyValidatorResult(validator);
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new TracValidator(repository, this.getTracVersion());
    }

    public String getConnectorKind() {
        return "trac";
    }

    public class TracValidator
    extends AbstractRepositorySettingsPage.Validator {
        private final String repositoryUrl;
        private final TaskRepository taskRepository;
        private ITracClient.Version version;
        private ITracClient.Version result;

        public TracValidator(TaskRepository taskRepository, ITracClient.Version version) {
            super((AbstractRepositorySettingsPage)TracRepositorySettingsPage.this);
            this.repositoryUrl = taskRepository.getRepositoryUrl();
            this.taskRepository = taskRepository;
            this.version = version;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                this.validate(monitor);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)INVALID_REPOSITORY_URL));
            }
            catch (TracLoginException e) {
                if (e.isNtlmAuthRequested()) {
                    AuthenticationCredentials credentials = this.taskRepository.getCredentials(AuthenticationType.REPOSITORY);
                    if (credentials == null || credentials.getUserName() == null || credentials.getPassword() == null) {
                        throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.trac.ui", 13, Messages.TracRepositorySettingsPage_auth_failed_missing_credentials, (Throwable)e));
                    }
                    if (!credentials.getUserName().contains("\\")) {
                        throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)Messages.TracRepositorySettingsPage_NTLM_authentication_requested_Error));
                    }
                }
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)INVALID_LOGIN));
            }
            catch (TracPermissionDeniedException tracPermissionDeniedException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)"Insufficient permissions for selected access type."));
            }
            catch (TracException e) {
                String message = Messages.TracRepositorySettingsPage_No_Trac_repository_found_at_url;
                if (e.getMessage() != null) {
                    message = String.valueOf(message) + ": " + e.getMessage();
                }
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)message));
            }
        }

        public void validate(IProgressMonitor monitor) throws MalformedURLException, TracException {
            TracRepositoryInfo info;
            ITracClient client;
            AbstractWebLocation location = new TaskRepositoryLocationFactory().createWebLocation(this.taskRepository);
            if (this.version != null) {
                client = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)this.version);
                info = client.validate(monitor);
            } else {
                try {
                    this.version = ITracClient.Version.XML_RPC;
                    client = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)this.version);
                    info = client.validate(monitor);
                }
                catch (TracException e) {
                    try {
                        this.version = ITracClient.Version.TRAC_0_9;
                        ITracClient client2 = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)this.version);
                        info = client2.validate(monitor);
                        if (e instanceof TracPermissionDeniedException) {
                            this.setStatus((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)1, (String)"org.eclipse.mylyn.trac.ui", (String)Messages.TracRepositorySettingsPage_Authentication_credentials_are_valid));
                        }
                    }
                    catch (TracLoginException tracLoginException) {
                        throw e;
                    }
                    catch (TracException tracException) {
                        throw new TracException();
                    }
                }
                this.result = this.version;
            }
            if (this.version == ITracClient.Version.XML_RPC && (info.isApiVersion(1, 0, 0) || info.isApiVersionOrHigher(1, 0, 3) && info.isApiVersionOrSmaller(1, 0, 5))) {
                this.setStatus((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)1, (String)"org.eclipse.mylyn.trac.ui", (String)Messages.TracRepositorySettingsPage_Authentication_credentials_valid_Update_to_latest_XmlRpcPlugin_Warning));
            }
            MultiStatus status = new MultiStatus("org.eclipse.mylyn.trac.ui", 0, NLS.bind((String)"Validation results for {0}", (Object)this.taskRepository.getRepositoryLabel()), null);
            status.add((IStatus)new Status(1, "org.eclipse.mylyn.trac.ui", NLS.bind((String)"Version: {0}", (Object)info.toString())));
            status.add((IStatus)new Status(1, "org.eclipse.mylyn.trac.ui", NLS.bind((String)"Access Type: {0}", (Object)this.version.toString())));
            StatusHandler.log((IStatus)status);
        }

        public ITracClient.Version getResult() {
            return this.result;
        }
    }
}

