/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.ant;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.core.ant.AbstractTestAntTask;
import org.eclipse.mylyn.internal.wikitext.core.ant.MarkupToDocbookTask;

public class MarkupToDocbookTaskTest
extends AbstractTestAntTask {
    private MarkupToDocbookTask task;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.task = new MarkupToDocbookTask();
        this.task.setMarkupLanguage(this.languageName);
    }

    public void testSimpleOutput() throws IOException {
        File markup = this.createSimpleTextileMarkup();
        this.task.setFile(markup);
        this.task.execute();
        this.listFiles();
        File docbookFile = new File(markup.getParentFile(), "markup.xml");
        MarkupToDocbookTaskTest.assertTrue((docbookFile.exists() && docbookFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(docbookFile);
        MarkupToDocbookTaskTest.assertTrue((boolean)content.contains("<book"));
        MarkupToDocbookTaskTest.assertTrue((boolean)content.contains("</book>"));
        MarkupToDocbookTaskTest.assertTrue((boolean)content.contains("<title>markup</title>"));
        MarkupToDocbookTaskTest.assertTrue((boolean)Pattern.compile("<chapter id=\"FirstHeading\">\\s*<title>First Heading</title>\\s*<para>some content</para>\\s*</chapter>", 8).matcher(content).find());
        MarkupToDocbookTaskTest.assertTrue((boolean)Pattern.compile("<chapter id=\"SecondHeading\">\\s*<title>Second Heading</title>\\s*<para>some more content</para>\\s*</chapter>", 8).matcher(content).find());
    }

    public void testSimpleOutputAlternateTitle() throws IOException {
        File markup = this.createSimpleTextileMarkup();
        this.task.setFile(markup);
        this.task.setBookTitle("Alternate Title");
        this.task.execute();
        this.listFiles();
        File docbookFile = new File(markup.getParentFile(), "markup.xml");
        MarkupToDocbookTaskTest.assertTrue((docbookFile.exists() && docbookFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(docbookFile);
        MarkupToDocbookTaskTest.assertTrue((boolean)content.contains("<book"));
        MarkupToDocbookTaskTest.assertTrue((boolean)content.contains("</book>"));
        MarkupToDocbookTaskTest.assertTrue((boolean)content.contains("<title>Alternate Title</title>"));
        MarkupToDocbookTaskTest.assertTrue((boolean)Pattern.compile("<chapter id=\"FirstHeading\">\\s*<title>First Heading</title>\\s*<para>some content</para>\\s*</chapter>", 8).matcher(content).find());
        MarkupToDocbookTaskTest.assertTrue((boolean)Pattern.compile("<chapter id=\"SecondHeading\">\\s*<title>Second Heading</title>\\s*<para>some more content</para>\\s*</chapter>", 8).matcher(content).find());
    }

    protected File createSimpleTextileMarkup() throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        try (PrintWriter writer = new PrintWriter(new FileWriter(markupFile));){
            writer.println("h1. First Heading");
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h1. Second Heading");
            writer.println();
            writer.println("some more content");
        }
        return markupFile;
    }

    public void testTaskdef() {
        MarkupToDocbookTaskTest.assertEquals((String)MarkupToDocbookTask.class.getName(), (String)this.loadTaskdefBundle().getString("wikitext-to-docbook"));
    }
}

