/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks.TestWikiToDocTask;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.tasks.WikiToDocTask;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class WikiToDocTaskTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private TestWikiToDocTask task;

    @Before
    public void before() throws IOException {
        this.task = new TestWikiToDocTask();
        this.task.setDest(this.temporaryFolder.getRoot());
    }

    @Test
    public void stylesheetUrlRelative() {
        File dest = this.task.getDest();
        WikiToDocTask.Stylesheet stylesheet = new WikiToDocTask.Stylesheet();
        stylesheet.setUrl("a/b.css");
        Assert.assertEquals((Object)"a/b.css", (Object)this.task.createBuilderStylesheet(dest, stylesheet).getUrl());
        Assert.assertEquals((Object)"../a/b.css", (Object)this.task.createBuilderStylesheet(new File(dest, "styles"), stylesheet).getUrl());
    }

    @Test
    public void stylesheetUrlAbsolute() {
        WikiToDocTask.Stylesheet stylesheet = new WikiToDocTask.Stylesheet();
        stylesheet.setUrl("http://example.com/a/b.css");
        Assert.assertEquals((Object)"http://example.com/a/b.css", (Object)this.task.createBuilderStylesheet(this.task.getDest(), stylesheet).getUrl());
    }

    @Test
    public void testMapPageNameToHref() throws Exception {
        Map<String, String> serverContent = Collections.singletonMap("http://wiki.eclipse.org/index.php?title=GEF%2FGEF4%2FCommon&action=raw", "Link to [[GEF/GEF4/Common#IActivatable|IActivatable]] is here\n\n==IActivatable==\nLorem ipsum");
        this.task.setServerContent(serverContent);
        this.task.setMarkupLanguage("MediaWiki");
        this.task.setWikiBaseUrl("http://wiki.eclipse.org");
        this.task.setNavigationImages(true);
        this.task.setValidate(true);
        this.task.setFailOnValidationError(true);
        this.task.setPrependImagePrefix("images");
        this.task.setFormatOutput(false);
        this.task.setDefaultAbsoluteLinkTarget("doc_external");
        this.task.setHelpPrefix("reference/wiki");
        this.task.setGenerateUnifiedToc(false);
        WikiToDocTask.Path path = new WikiToDocTask.Path();
        path.setTitle("GEF4 Common Documentation");
        path.setName("GEF/GEF4/Common");
        path.setGenerateToc(true);
        this.task.setPaths(Collections.singletonList(path));
        this.task.execute();
        File result = this.task.computeHtmlOutputFile(path);
        String content = Files.toString((File)result, (Charset)Charsets.UTF_8);
        Assert.assertTrue((boolean)content.contains("<p>Link to <a href=\"#IActivatable\" title=\"GEF/GEF4/Common#IActivatable\">IActivatable</a> is here</p>"));
    }

    @Test
    public void testLink() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("= What is Mylyn? =\n\n");
        sb.append("= Installation =\n\n");
        sb.append("=== Recommended GTK Setup for KDE ===\n\n");
        sb.append("There is a recommended GTK theme to use for KDE.\n\n");
        sb.append("= Task List =\n\n");
        sb.append("== Why are closed tasks not greyed out on Linux? ==\n\n");
        sb.append("See the [[Mylyn/FAQ#Recommended_GTK_Setup_for_KDE|Recommended GTK Setup for KDE]] section.\n\n");
        Map<String, String> serverContent = Collections.singletonMap("http://wiki.eclipse.org/index.php?title=Mylyn%2FFAQ&action=raw", sb.toString());
        this.task.setServerContent(serverContent);
        this.task.setMarkupLanguage("MediaWiki");
        this.task.setWikiBaseUrl("http://wiki.eclipse.org");
        this.task.setValidate(true);
        this.task.setFailOnValidationError(true);
        this.task.setPrependImagePrefix("images");
        this.task.setFormatOutput(true);
        this.task.setDefaultAbsoluteLinkTarget("mylyn_external");
        this.task.setTitle("Mylyn");
        this.task.setGenerateUnifiedToc(false);
        WikiToDocTask.Path path = new WikiToDocTask.Path();
        path.setTitle("Mylyn FAQ");
        path.setName("Mylyn/FAQ");
        path.setGenerateToc(true);
        this.task.setPaths(Collections.singletonList(path));
        this.task.execute();
        File mainPage = this.task.computeHtmlOutputFile(path);
        Assert.assertEquals((String)"main page exists", (Object)true, (Object)mainPage.exists());
        File installationPage = new File(mainPage.getParentFile(), "Installation.html");
        Assert.assertEquals((String)"'Installation.html' page exists", (Object)true, (Object)installationPage.exists());
        File taskListPage = new File(mainPage.getParentFile(), "Task-List.html");
        Assert.assertEquals((String)"'Task-List.html' page exists", (Object)true, (Object)taskListPage.exists());
        String content = Files.toString((File)taskListPage, (Charset)Charsets.UTF_8);
        Assert.assertTrue((boolean)content.contains("<a href=\"Installation.html#Recommended_GTK_Setup_for_KDE\" title=\"Mylyn/FAQ#Recommended_GTK_Setup_for_KDE\">Recommended GTK Setup for KDE</a> section."));
    }
}

