/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.textile.core;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.osgi.OsgiServiceLocator;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.core.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.builder.RecordingDocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguageConfiguration;
import org.eclipse.mylyn.wikitext.tests.AbstractMarkupGenerationTest;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;
import org.junit.Assert;
import org.junit.Test;

public class TextileLanguageTest
extends AbstractMarkupGenerationTest<TextileLanguage> {
    private static final String REGEX_NEWLINE = "(?:\\s*?^)";

    @Override
    protected TextileLanguage createMarkupLanguage() {
        return new TextileLanguage();
    }

    @Test
    public void testDiscoverable() {
        MarkupLanguage language = OsgiServiceLocator.getApplicableInstance().getMarkupLanguage("Textile");
        Assert.assertNotNull((Object)language);
        Assert.assertTrue((boolean)(language instanceof TextileLanguage));
    }

    @Test
    public void testIsDetectingRawHyperlinks() {
        Assert.assertFalse((boolean)((TextileLanguage)this.markupLanguage).isDetectingRawHyperlinks());
    }

    @Test
    public void testSimpleHeaders() {
        String html = this.parser.parseToHtml("h1. a header\n\nh2. another header");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<h1 id=\"aheader\">a header</h1>"));
        Assert.assertTrue((boolean)html.contains("<h2 id=\"anotherheader\">another header</h2>"));
    }

    @Test
    public void testMultilineBlockCode() {
        String html = this.parser.parseToHtml("bc. one\ntwo\n\nthree");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>one\\s+^two\\s+^</code>\\s*</pre>", 40).matcher(html).find());
    }

    @Test
    public void testPhraseModifierWorksAtStartOfLine() {
        String html = this.parser.parseToHtml("-a phrase modifier- at the start of a line");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<del>a phrase modifier</del> at"));
    }

    @Test
    public void testPhraseModifierWorksAtEndOfLine() {
        String html = this.parser.parseToHtml("at the start of a line: -a phrase modifier-");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("line: <del>a phrase modifier</del>"));
    }

    @Test
    public void testPhraseModifierSingleChar() {
        String html = this.parser.parseToHtml("a single character phrase modifier -b- is there");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("modifier <del>b</del>"));
    }

    @Test
    public void testPhraseModifierFalsePositives() {
        String html = this.parser.parseToHtml("this is - not a phrase modifier- and -neither is this - so there");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((!html.contains("<del>") ? 1 : 0) != 0);
    }

    @Test
    public void testPhraseModifierFalsePositives2() {
        String html = this.parser.parseToHtml("this is - not a phrase modifier - ");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((!html.contains("<del>") ? 1 : 0) != 0);
    }

    @Test
    public void testBlockCodeAtEndOfDocument() {
        String html = this.parser.parseToHtml("bc. one\ntwo\n");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>one\\s*^two\\s*^</code></pre>", 9).matcher(html).find());
    }

    @Test
    public void testBlockCodeAtEndOfDocument2() {
        String html = this.parser.parseToHtml("bc. one\ntwo");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>one\\s*^two\\s*^</code></pre>", 9).matcher(html).find());
    }

    @Test
    public void testPhraseModifierStrong() {
        String html = this.parser.parseToHtml("*strong text*");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<strong>strong text</strong>"));
    }

    @Test
    public void testPhraseModifiers() {
        String html = this.parser.parseToHtml("_emphasis_ *strong text* __italic__ **bold** ??citation?? -deleted text- +inserted text+ ^superscript^ ~subscript~ %spanned text% @code text@");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<em>emphasis</em>"));
        Assert.assertTrue((boolean)html.contains("<strong>strong text</strong>"));
        Assert.assertTrue((boolean)html.contains("<i>italic</i>"));
        Assert.assertTrue((boolean)html.contains("<b>bold</b>"));
        Assert.assertTrue((boolean)html.contains("<cite>citation</cite>"));
        Assert.assertTrue((boolean)html.contains("<del>deleted text</del>"));
        Assert.assertTrue((boolean)html.contains("<ins>inserted text</ins>"));
        Assert.assertTrue((boolean)html.contains("<sup>superscript</sup>"));
        Assert.assertTrue((boolean)html.contains("<sub>subscript</sub>"));
        Assert.assertTrue((boolean)html.contains("<span>spanned text</span>"));
        Assert.assertTrue((boolean)html.contains("<code>code text</code>"));
    }

    @Test
    public void testPhraseModifiersWithNonWordCharacters() {
        String html = this.parser.parseToHtml("_emphasis:_ *strong text:* __italic:__ **bold:** ??citation:?? -deleted text:- +inserted text:+ ^superscript:^ ~subscript:~ %spanned text:% @code text:@");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<em>emphasis:</em>"));
        Assert.assertTrue((boolean)html.contains("<strong>strong text:</strong>"));
        Assert.assertTrue((boolean)html.contains("<i>italic:</i>"));
        Assert.assertTrue((boolean)html.contains("<b>bold:</b>"));
        Assert.assertTrue((boolean)html.contains("<cite>citation:</cite>"));
        Assert.assertTrue((boolean)html.contains("<del>deleted text:</del>"));
        Assert.assertTrue((boolean)html.contains("<ins>inserted text:</ins>"));
        Assert.assertTrue((boolean)html.contains("<sup>superscript:</sup>"));
        Assert.assertTrue((boolean)html.contains("<sub>subscript:</sub>"));
        Assert.assertTrue((boolean)html.contains("<span>spanned text:</span>"));
        Assert.assertTrue((boolean)html.contains("<code>code text:</code>"));
    }

    @Test
    public void testDeleted() {
        String html = this.parser.parseToHtml("one -two three-four five- six");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<del>two three-four five</del>"));
    }

    @Test
    public void testAdjacentPhraseModifiers() {
        String html = this.parser.parseToHtml("_emphasis_ *strong text*");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<em>emphasis</em>"));
        Assert.assertTrue((boolean)html.contains("<strong>strong text</strong>"));
    }

    @Test
    public void testPhraseModifiersEnclosingText() {
        String html = this.parser.parseToHtml("_emphasis_ some text *strong text*");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile(".*?<em>emphasis</em>\\s*some text\\s*<strong>strong text</strong>.*", 40).matcher(html).matches());
    }

    @Test
    public void testPhraseModifierCode() {
        String html = this.parser.parseToHtml("@code1@:");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile(".*?<code>code1</code>:.*", 40).matcher(html).matches());
    }

    @Test
    public void testCodeWithCurlyBrace() {
        String html = this.parser.parseToHtml("for example: @{{bug|244618}}@");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>for example: <code>{{bug|244618}}</code></p>"));
    }

    @Test
    public void testPhraseModifierCodeWithNestedMarkup() {
        String html = this.parser.parseToHtml("a @code 'test' or \"test\" or *b* or <b>bo</b> sample@ more");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>a <code>code 'test' or \"test\" or *b* or &lt;b&gt;bo&lt;/b&gt; sample</code> more</p></body>"));
    }

    @Test
    public void testRelativeUrlNoBase() {
        String html = this.parser.parseToHtml("\"An URL\":foo/bar.html");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"foo/bar.html\">An URL</a>"));
    }

    @Test
    public void testGlossaryValidHtml() {
        String html = this.parser.parseToHtml("h1. Foo\n\none TWO(Two Ways Out) and MDD(Model-Driven Development)\n\nh1. Glossary\n\n{glossary}");
        TestUtil.println("HTML: \n" + html);
        Assert.assertFalse((boolean)html.contains("<p><dl"));
        Assert.assertTrue((boolean)html.contains("</h1><dl"));
    }

    @Test
    public void testLineStartingWithDeletedPhraseModifier() {
        String html = this.parser.parseToHtml("-this is deleted text-");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p><del>this is deleted text</del></p>"));
    }

    @Test
    public void testListItemWithDeletedText() {
        String html = this.parser.parseToHtml("- this is a list item with -deleted text-");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>- this is a list item with <del>deleted text</del></p>"));
    }

    @Test
    public void testListItemWithDeletedText2() {
        String html = this.parser.parseToHtml("* this is a list item with -deleted text-");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ul><li>this is a list item with <del>deleted text</del></li></ul>"));
    }

    @Test
    public void testHtmlEntityEncoding() {
        String html = this.parser.parseToHtml("Some A&BC Thing");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("A&amp;BC"));
    }

    @Test
    public void testHtmlEntityEncoding2() {
        String html = this.parser.parseToHtml("Some A&BC Thing; two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some A&amp;BC Thing; two</p>"));
    }

    @Test
    public void testHtmlEntityEncoding3() {
        String html = this.parser.parseToHtml("Some A&BCThing; two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some A&BCThing; two</p>"));
    }

    @Test
    public void testHtmlEntityEncoding4() {
        String html = this.parser.parseToHtml("Some A&#60; two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some A&#60; two</p>"));
    }

    @Test
    public void testHtmlEntityEncoding5() {
        String html = this.parser.parseToHtml("Some A&#x27; two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some A&#x27; two</p>"));
    }

    @Test
    public void testParagraphs() throws IOException {
        String html = this.parser.parseToHtml("first para\nnew line\n\nsecond para\n\n\n\n");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<body><p>first para<br/>\\s*new line</p><p>second para</p></body>", 8).matcher(html.toString()).find());
    }

    @Test
    public void testParagraphWithId() throws IOException {
        String html = this.parser.parseToHtml("p(#ab). first para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<p id=\"ab\">first para</p>"));
    }

    @Test
    public void testParagraphWithClass() throws IOException {
        String html = this.parser.parseToHtml("p(foo). first para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<p class=\"foo\">first para</p>"));
    }

    @Test
    public void testParagraphWithClassAndId() throws IOException {
        String html = this.parser.parseToHtml("p(foo#ab). first para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<p id=\"ab\" class=\"foo\">first para</p>"));
    }

    @Test
    public void testParagraphWithClassAndIdAndStyle() throws IOException {
        String html = this.parser.parseToHtml("p(foo#ab){color:black;}. first para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<p id=\"ab\" class=\"foo\" style=\"color:black;\">first para</p>"));
    }

    @Test
    public void testParagraphLeftAligned() throws IOException {
        String html = this.parser.parseToHtml("p<. first para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<p style=\"text-align: left;\">first para</p>"));
    }

    @Test
    public void testParagraphWithNestedList() throws IOException {
        String html = this.parser.parseToHtml("first para\n# numeric list\nfirst para second line");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>first para</p><ol><li>numeric list</li></ol><p>first para second line</p></body>"));
    }

    @Test
    public void testPreformattedDoesntMarkupContent() throws IOException {
        String html = this.parser.parseToHtml("pre. \n|_. a|_. table|_. header|\n|a|table|row|\n|a|table|row|\n");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<body><pre>\\s*\\|_. a\\|_. table\\|_. header\\|\\s+\\|a\\|table\\|row\\|\\s+\\|a\\|table\\|row\\|\\s+</pre></body>", 8).matcher(html.toString()).find());
    }

    @Test
    public void testHeading1() throws IOException {
        String html = this.parser.parseToHtml("h1(#ab). heading1\n\nnew para\n\na para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<body><h1 id=\"ab\">heading1</h1><p>new para</p><p>a para</p></body>", 8).matcher(html.toString()).find());
    }

    @Test
    public void testHeadingMultiline() throws IOException {
        String html = this.parser.parseToHtml("h1. heading1\nsecondline\n\na para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<body><h1 id=\"heading1\">heading1\\s+secondline</h1><p>a para</p></body>", 8).matcher(html.toString()).find());
    }

    @Test
    public void testHeading0NoHeading() throws IOException {
        String html = this.parser.parseToHtml("h0. heading0\n\nnew para\n\na para");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<body><p>h0. heading0</p><p>new para</p><p>a para</p></body>", 8).matcher(html.toString()).find());
    }

    @Test
    public void testMultilinePreformatted() throws IOException {
        String html = this.parser.parseToHtml("pre. one\ntwo\n\nthree");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<pre>one\\s+^two\\s+^</pre><p>three</p>", 40).matcher(html.toString()).find());
    }

    @Test
    public void testBlockQuote() throws IOException {
        String html = this.parser.parseToHtml("bq. one\ntwo\n\nthree");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<blockquote>\\s*<p>one<br/>\\s*two</p>\\s*</blockquote>", 40).matcher(html).find());
    }

    @Test
    public void testBlockQuoteWithCitation() throws IOException {
        String html = this.parser.parseToHtml("bq.:http://www.example.com some text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<blockquote cite=\"http://www.example.com\">\\s*<p>some text</p>\\s*</blockquote>", 40).matcher(html).find());
    }

    @Test
    public void testBlockQuote_bug304765() {
        String html = this.parser.parseToHtml("bq.. src/\n  main/\n    java/  (Java src folder)\n      META-INF\n     file.txt\n\n  \na");
        TestUtil.println("HTML: \n" + html);
    }

    @Test
    public void testBlockCode() throws IOException {
        String html = this.parser.parseToHtml("bc. one\ntwo\n\nthree");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>one\\s+two\\s+</code></pre>", 40).matcher(html).find());
    }

    @Test
    public void testBlockCodeWithTabs() throws IOException {
        String html = this.parser.parseToHtml("bc. one\n\ttwo\n\nthree");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("one\n\ttwo"));
    }

    @Test
    public void testBlockCodeWithTabsFormatted() throws IOException {
        StringWriter out = new StringWriter();
        HtmlDocumentBuilder documentBuilder = new HtmlDocumentBuilder((Writer)out, true);
        this.parser.setBuilder((DocumentBuilder)documentBuilder);
        this.parser.parse("bc. one\n\ttwo\n\nthree");
        String html = out.toString();
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("one\n\ttwo"));
    }

    @Test
    public void testBlockCodeWithEmbeddedHtmlTags() throws IOException {
        String html = this.parser.parseToHtml("bc. \nhere is <a href=\"#\">a working example</a>\n\n");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<body><pre><code>\\s*here is &lt;a href=\"#\"&gt;a working example&lt;/a&gt;\\s+</code></pre></body>", 40).matcher(html).find());
    }

    @Test
    public void testBlockCodeWithLeadingNewline() throws IOException {
        String html = this.parser.parseToHtml("bc. \none\ntwo\n\nthree");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>one\\s+two\\s+</code></pre>", 40).matcher(html).find());
    }

    @Test
    public void testBlockCodeWithLeadingNewlines() throws IOException {
        String html = this.parser.parseToHtml("bc.. \n\none\ntwo\np. three");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>(\\r|\\n)+one\\s+two\\s+</code></pre>", 40).matcher(html).find());
    }

    @Test
    public void testFootnote() throws IOException {
        String html = this.parser.parseToHtml("See foo[1].\n\nfn1. Foo.");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<p id=\"___fn[^\"]+\" class=\"footnote\"><sup>1</sup> Foo.</p>").matcher(html).find());
        Assert.assertTrue((boolean)Pattern.compile("<sup class=\"footnote\"><a href=\"#___fn[^\"]+\">1</a></sup>").matcher(html).find());
    }

    @Test
    public void testFootnoteRefNoFootnote() throws IOException {
        ((TextileLanguage)this.markupLanguage).setPreprocessFootnotes(true);
        String html = this.parser.parseToHtml("See foo[1].\n\nNo such footnote!");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>See foo[1].</p><p>No such footnote!</p></body>"));
    }

    @Test
    public void testListUnordered() throws IOException {
        String html = this.parser.parseToHtml("* a list\n* with two lines");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ul>"));
        Assert.assertTrue((boolean)html.contains("<li>a list</li>"));
        Assert.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        Assert.assertTrue((boolean)html.contains("</ul>"));
    }

    @Test
    public void testListUnordered2() throws IOException {
        String html = this.parser.parseToHtml("* a list\n** with several lines\n*** foo\n**  ??foo?? intentional two spaces leading content");
        TestUtil.println("HTML: \n" + html);
    }

    @Test
    public void testListOrdered() throws IOException {
        String html = this.parser.parseToHtml("# a list\n# with two lines");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol>"));
        Assert.assertTrue((boolean)html.contains("<li>a list</li>"));
        Assert.assertTrue((boolean)html.contains("<li>with two lines</li>"));
        Assert.assertTrue((boolean)html.contains("</ol>"));
    }

    @Test
    public void testListNested() throws IOException {
        String html = this.parser.parseToHtml("# a list\n## nested\n## nested2\n# level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol>"));
        Assert.assertTrue((boolean)html.contains("<li>a list"));
        Assert.assertTrue((boolean)html.contains("<li>nested"));
        Assert.assertTrue((boolean)html.contains("</ol>"));
    }

    @Test
    public void testListMixed() throws IOException {
        String html = this.parser.parseToHtml("# first\n* second");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol><li>first</li></ol><ul><li>second</li></ul>"));
    }

    @Test
    public void testListNestedMixed() throws IOException {
        String html = this.parser.parseToHtml("# a list\n#* nested\n#* nested2\n# level1\n\npara");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol><li>a list<ul><li>nested</li><li>nested2</li></ul></li><li>level1</li></ol>"));
    }

    @Test
    public void testListWithStyle() throws IOException {
        String html = this.parser.parseToHtml("#{color: blue} a list with style");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol style=\"color: blue\">"));
        Assert.assertTrue((boolean)html.contains("<li>a list with style</li>"));
        Assert.assertTrue((boolean)html.contains("</ol>"));
    }

    @Test
    public void testListNotAList() throws IOException {
        String html = this.parser.parseToHtml("- first\n- second");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>- first<br/>- second</p></body>"));
    }

    @Test
    public void testTable() throws IOException {
        String html = this.parser.parseToHtml("table. \n|a|row with|three columns|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td>a</td><td>row with</td><td>three columns</td></tr></table>"));
    }

    @Test
    public void testTable2() throws IOException {
        String html = this.parser.parseToHtml("foo bar\n|a|row with|three columns|\n|another|row|with three columns|\n\na para");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td>a</td><td>row with</td><td>three columns</td></tr><tr><td>another</td><td>row</td><td>with three columns</td></tr></table>"));
    }

    @Test
    public void testTableHeader() throws IOException {
        String html = this.parser.parseToHtml("table.\n|_. a|row with|three columns|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><th>a</th><td>row with</td><td>three columns</td></tr></table>"));
    }

    @Test
    public void testTableCellAlignment() throws IOException {
        String html = this.parser.parseToHtml("table.\n|^a|<row with|>four|<>columns|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td style=\"vertical-align: top;\">a</td><td style=\"text-align: left;\">row with</td><td style=\"text-align: right;\">four</td><td style=\"text-align: center;\">columns</td></tr></table>"));
    }

    @Test
    public void testTableCellColspan() throws IOException {
        String html = this.parser.parseToHtml("table.\n|\\2a|\\3b|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td colspan=\"2\">a</td><td colspan=\"3\">b</td></tr></table>"));
    }

    @Test
    public void testTableCellRowspan() throws IOException {
        String html = this.parser.parseToHtml("table.\n|/2a|/3b|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td rowspan=\"2\">a</td><td rowspan=\"3\">b</td></tr></table>"));
    }

    @Test
    public void testTableCellColspanRowspan() throws IOException {
        String html = this.parser.parseToHtml("table.\n|\\4/2a|\\5/3b|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td rowspan=\"2\" colspan=\"4\">a</td><td rowspan=\"3\" colspan=\"5\">b</td></tr></table>"));
    }

    @Test
    public void testTableWithEmbeddedTextile() throws IOException {
        String html = this.parser.parseToHtml("table.\n|*a*|row _with_|stuff|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td><strong>a</strong></td><td>row <em>with</em></td><td>stuff</td></tr></table>"));
    }

    @Test
    public void testTableWithAttributes() throws IOException {
        String html = this.parser.parseToHtml("table.\n|{color: red;}a|(foo)row with|(#bar)three columns|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td style=\"color: red;\">a</td><td class=\"foo\">row with</td><td id=\"bar\">three columns</td></tr></table>"));
    }

    @Test
    public void testTableWithAttributes2() throws IOException {
        String html = this.parser.parseToHtml("table{border:1px solid black;}.\n|This|is|a|row|\n|This|is|a|row|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table style=\"border:1px solid black;\"><tr><td>This</td><td>is</td><td>a</td><td>row</td></tr><tr><td>This</td><td>is</td><td>a</td><td>row</td></tr></table>"));
    }

    @Test
    public void testTableWithAttributes3() throws IOException {
        String html = this.parser.parseToHtml("|This|is|a|row|\n{background:#ddd}. |This|is|grey|row|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<table><tr><td>This</td><td>is</td><td>a</td><td>row</td></tr><tr style=\"background:#ddd\"><td>This</td><td>is</td><td>grey</td><td>row</td></tr></table>"));
    }

    @Test
    public void testTableWithStyles() {
        String html = this.parser.parseToHtml("table{border: 1px solid black}.\n|a|table|row|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><table style=\"border: 1px solid black\"><tr><td>a</td><td>table</td><td>row</td></tr></table></body>"));
    }

    @Test
    public void testTableWithStylesAndTrailingWhitespace() {
        String html = this.parser.parseToHtml("table{border: 1px solid black}. \n|a|table|row|");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><table style=\"border: 1px solid black\"><tr><td>a</td><td>table</td><td>row</td></tr></table></body>"));
    }

    @Test
    public void testPhraseModifierBold() throws IOException {
        String html = this.parser.parseToHtml("a paragraph with **bold content**");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>a paragraph with <b>bold content</b></p>"));
    }

    @Test
    public void testPhraseModifierBoldWithId() throws IOException {
        String html = this.parser.parseToHtml("a paragraph with **(#1)bold content**");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>a paragraph with <b id=\"1\">bold content</b></p>"));
    }

    @Test
    public void testSimplePhraseModifiers() throws IOException {
        String[][] pairs;
        String[][] stringArrayArray = pairs = new String[][]{{"**", "b"}, {"??", "cite"}, {"__", "i"}, {"_", "em"}, {"*", "strong"}, {"-", "del"}, {"+", "ins"}, {"~", "sub"}, {"^", "sup"}, {"%", "span"}, {"@", "code"}};
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pair = stringArrayArray[n2];
            this.initParser();
            String html = this.parser.parseToHtml("a paragraph with " + pair[0] + "content foo bar baz" + pair[0]);
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains("<p>a paragraph with <" + pair[1] + ">content foo bar baz</" + pair[1] + "></p>"));
            html = this.parser.parseToHtml(String.format("a %s2%s + b%s2%s = c%s2%s", pair[0], pair[0], pair[0], pair[0], pair[0], pair[0]));
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains(String.format("a <%s>2</%s> + b%s2%s = c%s2%s", pair[1], pair[1], pair[0], pair[0], pair[0], pair[0])));
            html = this.parser.parseToHtml("a paragraph with (" + pair[0] + "content foo bar baz" + pair[0] + ") punctuation");
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains("<p>a paragraph with (<" + pair[1] + ">content foo bar baz</" + pair[1] + ">) punctuation</p>"));
            html = this.parser.parseToHtml("a paragraph with " + pair[0] + "content foo bar baz" + pair[0] + ". punctuation");
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains("<p>a paragraph with <" + pair[1] + ">content foo bar baz</" + pair[1] + ">. punctuation</p>"));
            this.initParser();
            html = this.parser.parseToHtml("a paragraph with " + pair[0] + "(#abc)content foo bar baz" + pair[0]);
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains("<p>a paragraph with <" + pair[1] + " id=\"abc\">content foo bar baz</" + pair[1] + "></p>"));
            html = this.parser.parseToHtml("a paragraph with" + pair[0] + "content foo bar baz" + pair[0]);
            TestUtil.println("HTML: \n" + html);
            Assert.assertFalse((String)pair[1], (boolean)html.contains("<" + pair[1] + ">"));
            Assert.assertFalse((String)pair[1], (boolean)html.contains("</" + pair[1] + ">"));
            html = this.parser.parseToHtml("a paragraph with " + pair[0] + "content foo bar baz" + pair[0] + "baz.");
            TestUtil.println("HTML: \n" + html);
            Assert.assertFalse((String)pair[1], (boolean)html.contains("<" + pair[1] + ">"));
            Assert.assertFalse((String)pair[1], (boolean)html.contains("</" + pair[1] + ">"));
            ++n2;
        }
    }

    @Test
    public void testDeletedIssue22() {
        String html = this.parser.parseToHtml("Foo bar-baz one two three four-five.");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Foo bar-baz one two three four-five.</p>"));
    }

    @Test
    public void testDeletedBug338284() {
        LinkedHashMap<String, String> markupAndExpected = new LinkedHashMap<String, String>();
        markupAndExpected.put("Foo -one two-three four-", "<p>Foo <del>one two-three four</del></p>");
        markupAndExpected.put("Foo -one two- three four-", "<p>Foo <del>one two</del> three four-</p>");
        markupAndExpected.put("-one two-", "<p><del>one two</del></p>");
        markupAndExpected.put("-one-two-", "<p><del>one-two</del></p>");
        markupAndExpected.put("-one- two-", "<p><del>one</del> two-</p>");
        markupAndExpected.put("text -one two- and -three four-", "<p>text <del>one two</del> and <del>three four</del></p>");
        markupAndExpected.put("-a-", "<p><del>a</del></p>");
        markupAndExpected.put("--", "<p>--</p>");
        for (Map.Entry entry : markupAndExpected.entrySet()) {
            String markup = (String)entry.getKey();
            String expectedHtml = (String)entry.getValue();
            String html = this.parser.parseToHtml(markup);
            TestUtil.println(String.valueOf(markup) + " gives HTML: \n" + html);
            Assert.assertTrue((String)("Expecting " + expectedHtml + " in HTML: " + html), (boolean)html.contains(expectedHtml));
        }
    }

    @Test
    public void testPhraseModifierDeletedWithHyphens_bug321538() {
        String html = this.parser.parseToHtml("as I said, -hello oh-so-cruel world- again.\n\nThis works: -hell world-\n\nThis doesn't: -hello oh-so-cruel world-");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>as I said, <del>hello oh-so-cruel world</del> again.</p>"));
        Assert.assertTrue((boolean)html.contains("<p>This works: <del>hell world</del></p>"));
        Assert.assertTrue((boolean)html.contains("<p>This doesn&#8217;t: <del>hello oh-so-cruel world</del></p>"));
    }

    @Test
    public void testImage() throws IOException {
        String html = this.parser.parseToHtml("Here comes an !imageUrl! with more text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<img border=\"0\" src=\"imageUrl\"/>"));
    }

    @Test
    public void testImageWithAltAndTitle() throws IOException {
        String html = this.parser.parseToHtml("Here comes an !imageUrl(alt text)! with more text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<img alt=\"alt text\" title=\"alt text\" border=\"0\" src=\"imageUrl\"/>"));
    }

    @Test
    public void testImageAlignLeft() throws IOException {
        String html = this.parser.parseToHtml("Here comes an !<imageUrl! with more text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<img align=\"left\" border=\"0\" src=\"imageUrl\"/>"));
    }

    @Test
    public void testImageAlignRight() throws IOException {
        String html = this.parser.parseToHtml("Here comes an !>imageUrl! with more text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<img align=\"right\" border=\"0\" src=\"imageUrl\"/>"));
    }

    @Test
    public void testImageAlignCenter() throws IOException {
        String html = this.parser.parseToHtml("Here comes an !=imageUrl! with more text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<img align=\"center\" border=\"0\" src=\"imageUrl\"/>"));
    }

    @Test
    public void testImageRelative() throws IOException {
        String html = this.parser.parseToHtml("Here comes an !foo/bar/baz.jpg! with more text");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<img border=\"0\" src=\"foo/bar/baz.jpg\"/>"));
    }

    @Test
    public void testImageHyperlink() throws IOException {
        String html = this.parser.parseToHtml("Here comes a !hyperlink!:http://www.google.com to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"http://www.google.com\"><img border=\"0\" src=\"hyperlink\"/></a>"));
        Assert.assertFalse((boolean)html.contains("</a>:http://www.google.com"));
        Assert.assertTrue((boolean)html.contains("</a> to something"));
    }

    @Test
    public void testImageHyperlinkWithAttributes() throws IOException {
        String html = this.parser.parseToHtml("Here comes a !(foo-bar)hyperlink!:http://www.google.com to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"http://www.google.com\"><img class=\"foo-bar\" border=\"0\" src=\"hyperlink\"/></a>"));
        Assert.assertFalse((boolean)html.contains("</a>:http://www.google.com"));
        Assert.assertTrue((boolean)html.contains("</a> to something"));
    }

    @Test
    public void testImageFalsePositiveOnMultipleExclamationMarks() throws IOException {
        String html = this.parser.parseToHtml("Here comes a non-image!!! more text !!! and more");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>Here comes a non-image!!! more text !!! and more</p></body>"));
    }

    @Test
    public void testHtmlLiteral() throws IOException {
        String htmlFragment = "<a href=\"foo-bar\"><img src=\"some-image.jpg\"/></a>";
        String html = this.parser.parseToHtml("a paragraph " + htmlFragment + " with HTML literal");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>a paragraph " + htmlFragment + " with HTML literal</p>"));
    }

    @Test
    public void testHtmlLiteralSelfClosingTag() throws IOException {
        String html = this.parser.parseToHtml("a <br/> br tag");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("a <br/> br tag"));
    }

    @Test
    public void testHtmlLiteralTwoLinesWithAnchors() throws IOException {
        String html = this.parser.parseToHtml("Link 1 <a href=\"x\">x</a>\nand line 2 <a href=\"y\">y</a>");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Link 1 <a href=\"x\">x</a><br/>"));
        Assert.assertTrue((boolean)html.contains("and line 2 <a href=\"y\">y</a></p></body>"));
    }

    @Test
    public void testHtmlLiteralUnclosedTag() throws IOException {
        String html = this.parser.parseToHtml("<b>bold text with no terminating tag");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<b>bold text"));
    }

    @Test
    public void testHtmlLiteralAdjacentTags() throws IOException {
        String html = this.parser.parseToHtml("<span><a>some text</a></span>");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<span><a>some text</a></span>"));
    }

    @Test
    public void testHtmlLiteralAdjacentTags2() throws IOException {
        String html = this.parser.parseToHtml("<span>abc</span><a>some text</a>");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<span>abc</span><a>some text</a>"));
    }

    @Test
    public void testHtmlLiteralWithEmbeddedPhraseModifiers() throws IOException {
        Pattern pattern = Pattern.compile("(<[a-zA-Z][a-zA-Z0-9_-]*(?:\\s*[a-zA-Z][a-zA-Z0-9_:-]*=\"[^\"]*\")*\\s*/?>)");
        Matcher matcher = pattern.matcher("This document was authored using Textile markup: <a href=\"https://textile-j.dev.java.net/source/browse/*checkout*/textile-j/trunk/java/org.eclipse.mylyn.wikitext.ui.doc/help/Textile-J%20User%20Guide.textile\">original Textile markup for this document</a> ");
        while (matcher.find()) {
            TestUtil.println(String.format("Found '%s'", matcher.group(1)));
        }
        String html = this.parser.parseToHtml("This document was authored using Textile markup: <a href=\"https://textile-j.dev.java.net/source/browse/*checkout*/textile-j/trunk/java/org.eclipse.mylyn.wikitext.ui.doc/help/Textile-J%20User%20Guide.textile\">original Textile markup for this document</a>");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("markup: <a href=\"https://textile-j.dev.java.net/source/browse/*checkout*/textile-j/trunk/java/org.eclipse.mylyn.wikitext.ui.doc/help/Textile-J%20User%20Guide.textile\">original Textile markup for this document</a>"));
    }

    @Test
    public void testHtmlLiteralLoneCloseTag() throws IOException {
        String html = this.parser.parseToHtml("bold text with only a terminating</b> tag");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("terminating</b> tag"));
    }

    @Test
    public void testHtmlLiteralTerminatingTagWithLegalWhitespace() throws IOException {
        String html = this.parser.parseToHtml("<b>bold text</b  >");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<b>bold text</b  >"));
    }

    @Test
    public void testHtmlLiteralFalsePositive() throws IOException {
        String html = this.parser.parseToHtml("a <br br tag that is not real");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("a &lt;br br tag"));
    }

    @Test
    public void testHtmlLiteralFalsePositive2() throws IOException {
        String html = this.parser.parseToHtml("some no tag <!-- nt");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("&lt;!&#8212;"));
    }

    @Test
    public void testHtmlLiteralFalsePositive3() throws IOException {
        String html = this.parser.parseToHtml("some no tag <0nt");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("&lt;0nt"));
    }

    @Test
    public void testHtmlLiteralFalsePositive4() throws IOException {
        String html = this.parser.parseToHtml("some no tag <_nt");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("&lt;_nt"));
    }

    @Test
    public void testEscaping() throws IOException {
        String html = this.parser.parseToHtml("==no <b>textile</b> *none* _at_ all==");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("no <b>textile</b> *none* _at_ all"));
    }

    @Test
    public void testEscaping2() throws IOException {
        String html = this.parser.parseToHtml("==*none*==");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>*none*</p>"));
    }

    @Test
    public void testEscaping3() throws IOException {
        String html = this.parser.parseToHtml("Link 1 ==<a href=\"x\">x</a>==\nand line 2 ==<a href=\"y\">y</a>==");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Link 1 <a href=\"x\">x</a><br/>"));
        Assert.assertTrue((boolean)html.contains("and line 2 <a href=\"y\">y</a></p>"));
    }

    @Test
    public void testEscaping4() throws IOException {
        String html = this.parser.parseToHtml("=={toc}== Generates a table of contents.  Eg: =={toc}== or =={toc:style=disc|maxLevel=3}==");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<body><p>{toc} Generates a table of contents.  Eg: {toc} or {toc:style=disc|maxLevel=3}</p></body>"));
    }

    @Test
    public void testEscaping_NoTextile() throws IOException {
        String html = this.parser.parseToHtml("notextile. foo <b>bar</b>\n<i>baz</i>\n\ntextile *here*");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<body>foo <b>bar</b>\\s+<i>baz</i>\\s+<p>textile <strong>here</strong></p></body>").matcher(html).find());
    }

    @Test
    public void testEscaping_NoTextile_Extended() throws IOException {
        String html = this.parser.parseToHtml("notextile.. foo <b>bar</b>\n<i>baz</i>\n\nnotextile *here*\n\np. textile *here*");
        TestUtil.println(html);
        Assert.assertTrue((boolean)Pattern.compile("<body>foo <b>bar</b>\\s+<i>baz</i>\\s*notextile \\*here\\*\\s+<p>textile <strong>here</strong></p></body>").matcher(html).find());
    }

    @Test
    public void testReplacements() throws IOException {
        String html = this.parser.parseToHtml("some text with copyright(c), trademark(tm) and registered(r)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile(".*?<p>some text with copyright&#169;, trademark&#8482; and registered&#174;</p>.*", 40).matcher(html).matches());
    }

    @Test
    public void testApostrophe() throws IOException {
        String html = this.parser.parseToHtml("it's");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("it&#8217;s"));
    }

    @Test
    public void testQuotations() throws IOException {
        String html = this.parser.parseToHtml("some 'thing is' quoted");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("some &#8216;thing is&#8217; quoted"));
    }

    @Test
    public void testDoubleQuotations() throws IOException {
        String html = this.parser.parseToHtml("some \"thing is\" quoted");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("some &#8220;thing is&#8221; quoted"));
    }

    @Test
    public void testDoubleQuotationsGerman() throws IOException {
        MarkupLanguageConfiguration configuration = new MarkupLanguageConfiguration();
        configuration.setLocale(Locale.GERMAN);
        this.parser.getMarkupLanguage().configure(configuration);
        String html = this.parser.parseToHtml("some \"thing is\" quoted");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("some &#8222;thing is&#8221; quoted"));
    }

    @Test
    public void testDoubleQuotationsInTable() throws IOException {
        this.assertMarkup("<table><tr><td>\"thing is\"</td></tr></table>", "| \"thing is\" |");
    }

    @Test
    public void testCopyright() throws IOException {
        String html = this.parser.parseToHtml("copy(c)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("copy&#169;"));
    }

    @Test
    public void testTrademark() throws IOException {
        String html = this.parser.parseToHtml("trade(tm)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("trade&#8482;"));
    }

    @Test
    public void testRegistered() throws IOException {
        String html = this.parser.parseToHtml("registered(r)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("registered&#174;"));
    }

    @Test
    public void testCopyright2() throws IOException {
        String html = this.parser.parseToHtml("Copyright (C)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("Copyright &#169;"));
    }

    @Test
    public void testRegistered2() throws IOException {
        String html = this.parser.parseToHtml("Registered (R)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("Registered &#174;"));
    }

    @Test
    public void testTrademark2() throws IOException {
        String html = this.parser.parseToHtml("Trademark (TM)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("Trademark &#8482;"));
    }

    @Test
    public void testCopyright3() throws IOException {
        String html = this.parser.parseToHtml("copy (c)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("copy &#169;"));
    }

    @Test
    public void testTrademark3() throws IOException {
        String html = this.parser.parseToHtml("trade (tm)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("trade &#8482;"));
    }

    @Test
    public void testRegistered3() throws IOException {
        String html = this.parser.parseToHtml("registered (r)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("registered &#174;"));
    }

    @Test
    public void testEmDash() throws IOException {
        String html = this.parser.parseToHtml("one -- two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("one &#8212; two"));
    }

    @Test
    public void testEmDashAtStartOfLine() throws IOException {
        String html = this.parser.parseToHtml("-- two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("&#8212; two"));
    }

    @Test
    public void testEmDashNegativeNoPrecedingSpace() throws IOException {
        String html = this.parser.parseToHtml("one-- two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("one&#8212; two"));
    }

    @Test
    public void testEmDashAfterImage() throws IOException {
        String html = this.parser.parseToHtml("!images/button.png(Button)! -- Button");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p><img alt=\"Button\" title=\"Button\" border=\"0\" src=\"images/button.png\"/> &#8212; Button</p>"));
    }

    @Test
    public void testEnDash() throws IOException {
        String html = this.parser.parseToHtml("one - two");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("one &#8211; two"));
    }

    @Test
    public void testMul() throws IOException {
        String html = this.parser.parseToHtml("2 x 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("2 &#215; 4"));
    }

    @Test
    public void testFalseMul() throws IOException {
        String html = this.parser.parseToHtml("a x 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("a x 4"));
    }

    @Test
    public void testHyperlink() throws IOException {
        String html = this.parser.parseToHtml("Here comes a \"hyperlink\":http://www.google.com to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"http://www.google.com\">hyperlink</a>"));
    }

    @Test
    public void testHyperlinkWithClass() throws IOException {
        String html = this.parser.parseToHtml("Here comes a \"(test)hyperlink\":http://www.google.com to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"http://www.google.com\" class=\"test\">hyperlink</a>"));
    }

    @Test
    public void testHyperlinkWithEmphasis() throws IOException {
        String html = this.parser.parseToHtml("Here comes a \"_Click me_\":/stories/10146 to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"/stories/10146\"><em>Click me</em></a>"));
    }

    @Test
    public void testHyperlinkWithEmphasis2() throws IOException {
        String html = this.parser.parseToHtml("\"_Eclipse_\":http://eclipse.org");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"http://eclipse.org\"><em>Eclipse</em></a>"));
    }

    @Test
    public void testHyperlinkWithPunctuation() throws IOException {
        String html = this.parser.parseToHtml("Here comes a \"Click me!\":/stories/10146 to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"/stories/10146\">Click me!</a>"));
    }

    @Test
    public void testHyperlinkWithBold() throws IOException {
        String html = this.parser.parseToHtml("Here comes a \"*Click me*\":/stories/10146 to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"/stories/10146\"><strong>Click me</strong></a>"));
    }

    @Test
    public void testHyperlinkWithBoldWrapper() throws IOException {
        String html = this.parser.parseToHtml("Here comes a *\"Click me\":/stories/10146* to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<strong><a href=\"/stories/10146\">Click me</a></strong>"));
    }

    @Test
    public void testHyperlinkWithBoldWrapper2() throws IOException {
        String html = this.parser.parseToHtml("*\"text\":url*");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<strong><a href=\"url\">text</a></strong>"));
    }

    @Test
    public void testHyperlinkTailNegative() throws IOException {
        String[] tails;
        String[] stringArray = tails = new String[]{",", ".", ":", ";"};
        int n = tails.length;
        int n2 = 0;
        while (n2 < n) {
            String tail = stringArray[n2];
            String html = this.parser.parseToHtml("Here comes a \"hyperlink\":http://www.google.com" + tail + " to something");
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains("<a href=\"http://www.google.com\">hyperlink</a>" + tail + " to"));
            ++n2;
        }
    }

    @Test
    public void testHyperlinkTailPositive() throws IOException {
        String[] tails;
        String[] stringArray = tails = new String[]{")"};
        int n = tails.length;
        int n2 = 0;
        while (n2 < n) {
            String tail = stringArray[n2];
            String html = this.parser.parseToHtml("Here comes a \"hyperlink\":http://www.google.com" + tail + " to something");
            TestUtil.println("HTML: \n" + html);
            Assert.assertTrue((boolean)html.contains("<a href=\"http://www.google.com" + tail + "\">hyperlink</a> to"));
            ++n2;
        }
    }

    @Test
    public void testHyperlinkRelative() throws IOException {
        String html = this.parser.parseToHtml("Here comes a \"hyperlink\":foo/bar/baz.jpg to something");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"foo/bar/baz.jpg\">hyperlink</a>"));
    }

    @Test
    public void testAcronym() throws IOException {
        String html = this.parser.parseToHtml("ABC(A Better Comb)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<acronym title=\"A Better Comb\">ABC</acronym>"));
    }

    @Test
    public void testAcronym2() throws IOException {
        String html = this.parser.parseToHtml("Some preceding text ABC(A Better Comb)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<acronym title=\"A Better Comb\">ABC</acronym>"));
    }

    @Test
    public void testAcronym3() throws IOException {
        String html = this.parser.parseToHtml("Some preceding text ABCR(A Better Comb)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<acronym title=\"A Better Comb\">ABCR</acronym>"));
    }

    @Test
    public void testAcronymNegative() throws IOException {
        String html = this.parser.parseToHtml("Some preceding text AB(A Better Comb)");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>Some preceding text AB(A Better Comb)</p>"));
    }

    @Test
    public void testAcronymBug240743() {
        String markup = "As a very minor improvement to Textile-J(as what I proposed here http://www.cs.ubc.ca/~jingweno/soc/SoC2008.pdf)";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>As a very minor improvement to Textile-J(as what I proposed here http://www.cs.ubc.ca/~jingweno/soc/SoC2008.pdf)</p>"));
    }

    @Test
    public void testGlossary() throws IOException {
        String html = this.parser.parseToHtml("Some preceding text ABC(A Better Comb)\n\n{glossary}");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<acronym title=\"A Better Comb\">ABC</acronym>"));
        Assert.assertTrue((boolean)html.contains("<dl><dt>ABC</dt><dd>A Better Comb</dd></dl>"));
    }

    @Test
    public void testGlossaryWithStyle() throws IOException {
        String html = this.parser.parseToHtml("Some preceding text ABC(A Better Comb)\n\n{glossary:style=bullet}");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<acronym title=\"A Better Comb\">ABC</acronym>"));
        Assert.assertTrue((boolean)html.contains("<dl style=\"list-style: bullet\"><dt>ABC</dt><dd>A Better Comb</dd></dl>"));
    }

    @Test
    public void testTableOfContents() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        Assert.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        Assert.assertTrue((boolean)html.contains("href=\"#Subhead4\""));
        Assert.assertTrue((boolean)html.contains("<h3 id=\"Subhead4\">"));
    }

    @Test
    public void testTableOfContentsWithNoClass() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol class=\"toc\""));
    }

    @Test
    public void testTableOfContentsWithClass() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc:class=test}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol class=\"test\""));
    }

    @Test
    public void testTableOfContentsWithClassAtTopLevel_bug341019() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc:class=test}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<ol class=\"test\" style=\"list-style: none;\">"));
        Assert.assertTrue((boolean)html.contains("<ol style=\"list-style: none;\">"));
    }

    @Test
    public void testTableOfContentsWithMaxLevel() throws IOException {
        String html = this.parser.parseToHtml("h1. Table Of Contents\n\n{toc:maxLevel=2}\n\nh1. Top Header\n\nsome text\n\nh2. Subhead\n\nh2. Subhead2\n\nh1. Top Header 2\n\nh2. Subhead 3\n\nh3. Subhead 4");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<a href=\"#Subhead2\">"));
        Assert.assertTrue((boolean)html.contains("<h2 id=\"Subhead2\">"));
        Assert.assertFalse((boolean)html.contains("href=\"#Subhead4\""));
        Assert.assertTrue((boolean)html.contains("<h3 id=\"Subhead4\">"));
    }

    @Test
    public void testExtendedBlockQuote() {
        String html = this.parser.parseToHtml("bq.. one\ntwo\n\nthree\np. some para");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<blockquote><p>one<br/>\\s*two</p>\\s*<p>three</p></blockquote><p>some para</p>", 40).matcher(html).find());
    }

    @Test
    public void testExtendedBlockCode() {
        String html = this.parser.parseToHtml("bc.. one\ntwo\n\nthree\n\n\nblah");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>one(?:\\s*?^)two(?:\\s*?^)(?:\\s*?^)three(?:\\s*?^)(?:\\s*?^)(?:\\s*?^)blah(?:\\s*?^)</code></pre>", 40).matcher(html).find());
    }

    @Test
    public void testExtendedBlockCode2() {
        String html = this.parser.parseToHtml("bc.. \none\ntwo\n\nthree\n\n\nmore\n\np. some para");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre><code>one(?:\\s*?^)two(?:\\s*?^)(?:\\s*?^)three(?:\\s*?^)(?:\\s*?^)(?:\\s*?^)more(?:\\s*?^)</code></pre><p>some para</p>", 40).matcher(html).find());
    }

    @Test
    public void testExtendedPre() {
        String html = this.parser.parseToHtml("pre.. one\ntwo\n\nthree\n\n\nblah\np. para");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<pre>one(?:\\s*?^)two(?:\\s*?^)(?:\\s*?^)three(?:\\s*?^)(?:\\s*?^)(?:\\s*?^)blah(?:\\s*?^)</pre><p>para</p>", 40).matcher(html).find());
    }

    @Test
    public void testParagraphWithLeadingSpace() {
        String markup = " <div>\n\nsome text\n\n </div>";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println("MARKUP: \n" + markup);
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><div><p>some text</p></div></body>"));
    }

    @Test
    public void testParagraphWithLeadingSpace2() {
        String markup = " para text\npara line 2\n\nnew para";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println("MARKUP: \n" + markup);
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)Pattern.compile("<body>para text\\s+para line 2<p>new para</p></body>", 40).matcher(html).find());
    }

    @Test
    public void testParagraphsWithLineBreak() {
        String html = this.parser.parseToHtml("first\nsecond\n\np. third\nfourth\n\nfifth");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>first<br/>second</p>"));
        Assert.assertTrue((boolean)html.contains("<p>third<br/>fourth</p>"));
        Assert.assertTrue((boolean)html.contains("<p>fifth</p>"));
    }

    @Test
    public void testParagraphsWithLineThatHasWhitespaceInDelimitingLine() {
        String html = this.parser.parseToHtml("first\n \nsecond");
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<body><p>first</p><p>second</p></body>"));
    }

    @Test
    public void testBug50XHTMLCompliance() throws Exception {
        StringWriter writer = new StringWriter();
        MarkupParser parser = new MarkupParser((MarkupLanguage)new TextileLanguage());
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer);
        builder.setXhtmlStrict(true);
        builder.setEmitDtd(true);
        builder.setHtmlDtd("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">");
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse("!<image.png!:http://foo.bar");
        String html = writer.toString();
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<a href=\"http://foo.bar\"><img style=\"border-width: 0px;text-align: left;\" alt=\"\" src=\"image.png\"/></a>"));
    }

    @Test
    public void testBug50NoXHTMLCompliance() throws Exception {
        StringWriter writer = new StringWriter();
        MarkupParser parser = new MarkupParser((MarkupLanguage)new TextileLanguage());
        HtmlDocumentBuilder builder = new HtmlDocumentBuilder((Writer)writer);
        builder.setXhtmlStrict(false);
        builder.setEmitDtd(false);
        parser.setBuilder((DocumentBuilder)builder);
        parser.parse("!<image.png!:http://foo.bar");
        String html = writer.toString();
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<a href=\"http://foo.bar\"><img align=\"left\" border=\"0\" src=\"image.png\"/></a>"));
    }

    @Test
    public void testNamedLinks() {
        String markup = "I am crazy about \"TextileJ\":textilej\nand \"it's\":textilej \"all\":textilej I ever\n\"link to\":textilej!\n\n[textilej]https://textile-j.dev.java.net";
        String html = this.parser.parseToHtml(markup);
        TestUtil.println("HTML: \n" + html);
        Assert.assertTrue((boolean)html.contains("<p>I am crazy about <a href=\"https://textile-j.dev.java.net\">TextileJ</a><br/>and <a href=\"https://textile-j.dev.java.net\">it&#8217;s</a> <a href=\"https://textile-j.dev.java.net\">all</a> I ever<br/><a href=\"https://textile-j.dev.java.net\">link to</a>!</p><p>[textilej]https://textile-j.dev.java.net</p>"));
    }

    @Test
    public void testXmlEscaping() {
        String html = this.parser.parseToHtml("some <start>mark</start> up");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<p>some <start>mark</start> up</p>"));
    }

    @Test
    public void testHtmlEscaping() {
        String html = this.parser.parseToHtml("some <span class=\"s\">mark</span> up");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<p>some <span class=\"s\">mark</span> up</p>"));
    }

    @Test
    public void testFootnoteReferenceLexicalPosition() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("a footnote reference[1] more text");
        List<RecordingDocumentBuilder.Event> events = builder.getEvents();
        for (RecordingDocumentBuilder.Event event : events) {
            if (event.spanType != DocumentBuilder.SpanType.SUPERSCRIPT) continue;
            Assert.assertEquals((long)20L, (long)event.locator.getLineCharacterOffset());
            Assert.assertEquals((long)23L, (long)event.locator.getLineSegmentEndOffset());
            return;
        }
        Assert.fail((String)"expected to find superscript span");
    }

    @Test
    public void testLinkWithItalicStyle() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("\"_text_\":http://example.com");
        List<RecordingDocumentBuilder.Event> events = builder.getEvents();
        TestUtil.println(events);
        boolean emphasisFound = false;
        boolean textFound = false;
        for (RecordingDocumentBuilder.Event event : events) {
            if (event.spanType == DocumentBuilder.SpanType.EMPHASIS) {
                Assert.assertEquals((long)1L, (long)event.locator.getLineCharacterOffset());
                Assert.assertEquals((long)7L, (long)event.locator.getLineSegmentEndOffset());
                emphasisFound = true;
                continue;
            }
            if (event.text == null) continue;
            Assert.assertEquals((long)2L, (long)event.locator.getLineCharacterOffset());
            Assert.assertEquals((long)6L, (long)event.locator.getLineSegmentEndOffset());
            textFound = true;
        }
        Assert.assertTrue((String)"expected to find emphasis span", (boolean)emphasisFound);
        Assert.assertTrue((String)"expected to find text", (boolean)textFound);
    }

    @Test
    public void testBoldItalicsBold() {
        String html = this.parser.parseToHtml("*bold _ital ics_ bold*");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<strong>bold <em>ital ics</em> bold</strong>"));
    }

    @Test
    public void testItalicsBold() {
        String html = this.parser.parseToHtml("_italics **bol d** italics_");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<em>italics <b>bol d</b> italics</em>"));
    }

    @Test
    public void testBoldItalics() {
        String html = this.parser.parseToHtml("*_bold and italic_ not just bold*");
        TestUtil.println(html);
        Assert.assertTrue((boolean)html.contains("<strong><em>bold and italic</em> not just bold</strong>"));
    }

    @Test
    public void testNestedPhraseModifiersLexicalPosition() {
        RecordingDocumentBuilder builder = new RecordingDocumentBuilder();
        this.parser.setBuilder((DocumentBuilder)builder);
        this.parser.parse("a _sample *bold -sdf-*_");
        List<RecordingDocumentBuilder.Event> events = builder.getEvents();
        int found = 0;
        for (RecordingDocumentBuilder.Event event : events) {
            TestUtil.println(event);
            if (event.spanType == DocumentBuilder.SpanType.EMPHASIS) {
                ++found;
                Assert.assertEquals((long)2L, (long)event.locator.getLineCharacterOffset());
                Assert.assertEquals((long)23L, (long)event.locator.getLineSegmentEndOffset());
                continue;
            }
            if (event.spanType == DocumentBuilder.SpanType.STRONG) {
                ++found;
                Assert.assertEquals((long)10L, (long)event.locator.getLineCharacterOffset());
                Assert.assertEquals((long)22L, (long)event.locator.getLineSegmentEndOffset());
                continue;
            }
            if (event.spanType != DocumentBuilder.SpanType.DELETED) continue;
            ++found;
            Assert.assertEquals((long)16L, (long)event.locator.getLineCharacterOffset());
            Assert.assertEquals((long)21L, (long)event.locator.getLineSegmentEndOffset());
        }
        Assert.assertEquals((long)3L, (long)found);
    }

    @Test
    public void testMarkupContainingCDATA() {
        String[] stringArray = new String[]{"pre", "bc"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String blockType = stringArray[n2];
            String html = this.parser.parseToHtml(String.valueOf(blockType) + ". <![CDATA[123 456]]>");
            TestUtil.println(html);
            Assert.assertTrue((boolean)html.contains("&lt;![CDATA[123 456]]&gt;"));
            ++n2;
        }
    }

    @Test
    public void testEntityReferences() {
        String[] entities;
        String[] stringArray = entities = new String[]{"copy", "amp", "foobar", "#28", "x3C", "x3E"};
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            String markup = "text &" + entity + ";";
            String html = this.parser.parseToHtml(markup);
            TestUtil.println(html);
            Assert.assertTrue((boolean)html.contains("&" + entity + ";"));
            markup = "&" + entity + ";";
            html = this.parser.parseToHtml(markup);
            TestUtil.println(html);
            Assert.assertTrue((boolean)html.contains("&" + entity + ";"));
            markup = "&" + entity + "; text";
            html = this.parser.parseToHtml(markup);
            TestUtil.println(html);
            Assert.assertTrue((boolean)html.contains("&" + entity + ";"));
            ++n2;
        }
    }

    @Test
    public void testEntityReferences_NegativeMatch() {
        String[] entities;
        String[] stringArray = entities = new String[]{"copy", "amp", "foobar", "#28", "x3C", "x3E"};
        int n = entities.length;
        int n2 = 0;
        while (n2 < n) {
            String entity = stringArray[n2];
            String markup = "text &" + entity + " ;";
            String html = this.parser.parseToHtml(markup);
            TestUtil.println(html);
            Assert.assertTrue((boolean)html.contains("&amp;" + entity + " ;"));
            markup = "text & " + entity + ";";
            html = this.parser.parseToHtml(markup);
            TestUtil.println(html);
            Assert.assertTrue((boolean)html.contains("&amp; " + entity + ";"));
            ++n2;
        }
    }
}

