/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.summaryrow;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowLayer;

public class FixedSummaryRowLayer
extends SummaryRowLayer {
    public static final String DEFAULT_SUMMARY_ROW_LABEL = "Summary";
    protected String summaryRowLabel = "Summary";
    protected ILayer horizontalLayerDependency;
    private boolean horizontalCompositeDependency = true;

    public FixedSummaryRowLayer(IUniqueIndexLayer bodyDataLayer, ILayer horizontalLayerDependency, IConfigRegistry configRegistry) {
        this(bodyDataLayer, horizontalLayerDependency, configRegistry, true, true);
    }

    public FixedSummaryRowLayer(IUniqueIndexLayer bodyDataLayer, ILayer horizontalLayerDependency, IConfigRegistry configRegistry, boolean autoConfigure) {
        this(bodyDataLayer, horizontalLayerDependency, configRegistry, true, autoConfigure);
    }

    public FixedSummaryRowLayer(IUniqueIndexLayer bodyDataLayer, ILayer horizontalLayerDependency, IConfigRegistry configRegistry, boolean smoothUpdates, boolean autoConfigure) {
        super(bodyDataLayer, configRegistry, smoothUpdates, autoConfigure);
        this.horizontalLayerDependency = horizontalLayerDependency;
        this.setStandalone(true);
        if (bodyDataLayer instanceof AbstractLayer) {
            ((AbstractLayer)((Object)bodyDataLayer)).setLayerPainter(new GridLineCellLayerPainter(false, true));
        }
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        if (!this.isBodyColumn(columnPosition)) {
            return this.getSummaryRowLabel();
        }
        int columnIndex = LayerUtil.convertColumnPosition(this.horizontalLayerDependency, columnPosition, (IUniqueIndexLayer)this.underlyingLayer);
        return super.getDataValueByPosition(columnIndex, rowPosition);
    }

    protected boolean isBodyColumn(int columnPosition) {
        return !this.horizontalCompositeDependency || columnPosition != 0;
    }

    public boolean hasHorizontalCompositeDependency() {
        return this.horizontalCompositeDependency;
    }

    public void setHorizontalCompositeDependency(boolean compositeDependency) {
        this.horizontalCompositeDependency = compositeDependency;
    }

    public String getSummaryRowLabel() {
        return this.summaryRowLabel;
    }

    public void setSummaryRowLabel(String summaryRowLabel) {
        this.summaryRowLabel = summaryRowLabel;
    }

    @Override
    protected LabelStack getConfigLabelsByPositionWithoutTransformation(int columnPosition, int rowPosition) {
        return super.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (!this.isBodyColumn(columnPosition)) {
            LabelStack labelStack = this.horizontalLayerDependency.getConfigLabelsByPosition(columnPosition, this.horizontalLayerDependency.getRowCount() - 1);
            labelStack.addLabelOnTop("SummaryRow");
            if (this.getConfigLabelAccumulator() != null) {
                this.getConfigLabelAccumulator().accumulateConfigLabels(labelStack, columnPosition, rowPosition);
            }
            return labelStack;
        }
        int columnIndex = LayerUtil.convertColumnPosition(this.horizontalLayerDependency, columnPosition, (IUniqueIndexLayer)this.underlyingLayer);
        return super.getConfigLabelsByPosition(columnIndex, rowPosition);
    }

    @Override
    public int getColumnCount() {
        return this.horizontalLayerDependency.getColumnCount();
    }

    @Override
    public int getPreferredColumnCount() {
        return this.horizontalLayerDependency.getPreferredColumnCount();
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        return this.horizontalLayerDependency.getColumnIndexByPosition(columnPosition);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        return this.horizontalLayerDependency.localToUnderlyingColumnPosition(localColumnPosition);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer == this.horizontalLayerDependency) {
            return underlyingColumnPosition;
        }
        return this.horizontalLayerDependency.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPosition);
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        if (sourceUnderlyingLayer == this.horizontalLayerDependency) {
            return underlyingColumnPositionRanges;
        }
        return this.horizontalLayerDependency.underlyingToLocalColumnPositions(sourceUnderlyingLayer, underlyingColumnPositionRanges);
    }

    @Override
    public int getWidth() {
        return this.horizontalLayerDependency.getWidth();
    }

    @Override
    public int getPreferredWidth() {
        return this.horizontalLayerDependency.getPreferredWidth();
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        return this.horizontalLayerDependency.getColumnWidthByPosition(columnPosition);
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.horizontalLayerDependency.isColumnPositionResizable(columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.horizontalLayerDependency.getColumnPositionByX(x);
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.horizontalLayerDependency.getStartXOfColumnPosition(columnPosition);
    }
}

