/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.concurrent;

import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import org.eclipse.net4j.internal.util.concurrent.IExecutorServiceProvider;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.IManagedContainer;

public final class InternalConcurrencyUtil {
    private InternalConcurrencyUtil() {
    }

    public static ExecutorService getExecutorService(Object object) {
        if (object != null) {
            if (object instanceof IExecutorServiceProvider) {
                try {
                    return ((IExecutorServiceProvider)object).getExecutorService();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (object instanceof IManagedContainer) {
                try {
                    return ConcurrencyUtil.getExecutorService((IManagedContainer)object);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                Method method = ReflectUtil.getMethod(object.getClass(), "getExecutorService", new Class[0]);
                Object result = ReflectUtil.invokeMethod(method, object, new Object[0]);
                if (result instanceof ExecutorService) {
                    return (ExecutorService)result;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

