/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.signal;

import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import org.eclipse.internal.net4j.bundle.OM;
import org.eclipse.net4j.buffer.BufferInputStream;
import org.eclipse.net4j.buffer.BufferOutputStream;
import org.eclipse.net4j.channel.IChannel;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.MonitorProgressRequest;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.monitor.TimeoutMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IndicationWithMonitoring
extends IndicationWithResponse {
    private Monitor monitor;

    public IndicationWithMonitoring(SignalProtocol<?> protocol, short id, String name) {
        super(protocol, id, name);
    }

    public IndicationWithMonitoring(SignalProtocol<?> protocol, short signalID) {
        super(protocol, signalID);
    }

    public IndicationWithMonitoring(SignalProtocol<?> protocol, Enum<?> literal) {
        super(protocol, literal);
    }

    @Override
    protected void execute(BufferInputStream in, BufferOutputStream out) throws Exception {
        try {
            super.execute(in, out);
        }
        finally {
            if (this.monitor != null) {
                this.monitor.done();
                this.monitor = null;
            }
        }
    }

    @Override
    protected final void indicating(ExtendedDataInputStream in) throws Exception {
        OMMonitor subMonitor = null;
        boolean useMonitor = in.readBoolean();
        if (useMonitor) {
            int monitorProgressSeconds = in.readInt();
            int monitorTimeoutSeconds = in.readInt();
            this.monitor = new ReportingMonitor(monitorProgressSeconds, monitorTimeoutSeconds);
        } else {
            int monitorTimeoutSeconds = in.readInt();
            this.monitor = new TimeoutMonitor(1000L * (long)monitorTimeoutSeconds);
        }
        this.monitor.begin(100.0);
        subMonitor = this.monitor.fork((double)this.getIndicatingWorkPercent());
        this.indicating(in, subMonitor);
    }

    @Override
    protected final void responding(ExtendedDataOutputStream out) throws Exception {
        OMMonitor subMonitor = this.monitor != null ? this.monitor.fork(100.0 - (double)this.getIndicatingWorkPercent()) : null;
        this.responding(out, subMonitor);
    }

    protected abstract void indicating(ExtendedDataInputStream var1, OMMonitor var2) throws Exception;

    protected abstract void responding(ExtendedDataOutputStream var1, OMMonitor var2) throws Exception;

    protected ExecutorService getMonitoringExecutorService() {
        return this.getProtocol().getExecutorService();
    }

    protected int getIndicatingWorkPercent() {
        return 99;
    }

    void setMonitorCanceled() {
        this.monitor.cancel();
    }

    private final class ReportingMonitor
    extends TimeoutMonitor {
        private TimerTask sendProgressTask;

        public ReportingMonitor(int monitorProgressSeconds, int monitorTimeoutSeconds) {
            super(1000L * (long)monitorTimeoutSeconds);
            this.sendProgressTask = new TimerTask(){

                public void run() {
                    try {
                        ReportingMonitor.this.sendProgress();
                    }
                    catch (Throwable ex) {
                        OM.LOG.error("ReportingMonitorTask failed", ex);
                        this.cancel();
                    }
                }
            };
            long period = 1000L * (long)monitorProgressSeconds;
            this.scheduleAtFixedRate(this.sendProgressTask, period, period);
        }

        public void cancel(RuntimeException cancelException) {
            this.sendProgressTask.cancel();
            super.cancel(cancelException);
        }

        public void done() {
            this.sendProgressTask.cancel();
            super.done();
        }

        private void sendProgress() {
            block2: {
                SignalProtocol<?> protocol = IndicationWithMonitoring.this.getProtocol();
                try {
                    int correlationID = -IndicationWithMonitoring.this.getCorrelationID();
                    double totalWork = this.getTotalWork();
                    double work = this.getWork();
                    new MonitorProgressRequest(protocol, correlationID, totalWork, work).sendAsync();
                }
                catch (Exception ex) {
                    IChannel channel = protocol.getChannel();
                    if (!LifecycleUtil.isActive((Object)channel)) break block2;
                    OM.LOG.error((Throwable)ex);
                }
            }
        }
    }
}

