/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CreateSwitchAdapter
extends AbstractTransformableClassNode {
    private Method method;
    private int firstArgIndex;

    public CreateSwitchAdapter(Method method) {
        this.method = method;
        this.firstArgIndex = method.isStatic() ? 0 : 1;
    }

    public CreateSwitchAdapter(Method method, boolean isRoleMethod) {
        this.method = method;
        this.firstArgIndex = method.isStatic() ? (isRoleMethod ? 2 : 0) : 1;
    }

    @Override
    public boolean transform() {
        MethodNode methodNode = this.getMethod(this.method);
        if (methodNode == null) {
            return false;
        }
        methodNode.instructions.clear();
        this.addPreSwitchInstructions(methodNode);
        LabelNode def = new LabelNode();
        LookupSwitchInsnNode switchNode = new LookupSwitchInsnNode(def, new int[0], new LabelNode[0]);
        methodNode.instructions.add((AbstractInsnNode)switchNode);
        methodNode.instructions.add((AbstractInsnNode)def);
        this.addInstructionForDefaultLabel(methodNode);
        this.addPostSwitchInstructions(methodNode);
        methodNode.maxStack = this.getMaxStack();
        return true;
    }

    protected void addPostSwitchInstructions(MethodNode method) {
    }

    protected void addPreSwitchInstructions(MethodNode method) {
        method.instructions.add((AbstractInsnNode)new IntInsnNode(21, this.firstArgIndex));
    }

    protected void addInstructionForDefaultLabel(MethodNode method) {
        method.instructions.add((AbstractInsnNode)new InsnNode(1));
        method.instructions.add((AbstractInsnNode)new InsnNode(176));
    }

    protected int getMaxStack() {
        return 1;
    }

    protected int getFirstArgIndex() {
        return this.firstArgIndex;
    }

    protected Method getMethod() {
        return this.method;
    }
}

