/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console.xtfo;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ocl.examples.xtext.console.xtfo.HighlightingHelper;
import org.eclipse.ocl.examples.xtext.console.xtfo.TextViewerAction;
import org.eclipse.ocl.examples.xtext.console.xtfo.ToggleSLCommentAction;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.OCLInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ActiveShellExpression;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class EmbeddedXtextEditor {
    private static final String XTEXT_UI_FORMAT_ACTION = "org.eclipse.xtext.ui.FormatAction";
    private static final String XTEXT_UI_TOGGLE_SL_COMMENT_ACTION = "org.eclipse.xtext.ui.ToggleCommentAction";
    private Composite fControl;
    private int fStyle;
    private XtextSourceViewer fSourceViewer;
    private XtextResource fResource;
    private XtextDocument fDocument;
    @Inject
    @Named(value="file.extensions")
    private String fFileExtension;
    private XtextSourceViewerConfiguration fViewerConfiguration;
    @Inject
    private HighlightingHelper fHighlightingHelper;
    @Inject
    private IResourceSetProvider fResourceSetProvider;
    @Inject
    private IGrammarAccess fGrammarAccess;
    @Inject
    private XtextSourceViewer.Factory fSourceViewerFactory;
    @Inject
    private Provider<XtextSourceViewerConfiguration> fSourceViewerConfigurationProvider;
    @Inject
    private Provider<XtextDocument> fDocumentProvider;
    @Inject
    private Provider<XtextResource> fXtextResourceProvider;
    @Inject
    private IResourceValidator fResourceValidator;
    @Inject
    private IPreferenceStoreAccess fPreferenceStoreAccess;
    @Inject
    private ICharacterPairMatcher characterPairMatcher;
    @Inject(optional=true)
    private AnnotationPainter.IDrawingStrategy projectionAnnotationDrawingStrategy;
    private IOverviewRuler fOverviewRuler;
    private IAnnotationAccess fAnnotationAccess;
    @NonNull
    private OCLInternal ocl;
    private IVerticalRuler fVerticalRuler;
    @Inject
    private Provider<IDocumentPartitioner> documentPartitioner;
    private static final String ERROR_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.error";
    private static final String WARNING_ANNOTATION_TYPE = "org.eclipse.xtext.ui.editor.warning";
    private SourceViewerDecorationSupport fSourceViewerDecorationSupport;
    private static final int VERTICAL_RULER_WIDTH = 12;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private Map<String, IAction> fActions = Maps.newHashMap();
    private List<IAction> fSelectionDependentActions = Lists.newArrayList();
    private List<ActionHandler> fActionHandlers = Lists.newArrayList();

    public EmbeddedXtextEditor(Composite control, Injector injector, int style) {
        this.fControl = control;
        this.fStyle = style;
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
        injector.injectMembers((Object)this);
        this.ocl = OCLInternal.newInstance();
        ResourceSet csResourceSet = this.getResourceSet();
        if (csResourceSet != null) {
            this.ocl.getEnvironmentFactory().adapt((Notifier)csResourceSet);
        }
        this.createEditor(this.fControl);
    }

    public EmbeddedXtextEditor(Composite control, Injector injector) {
        this(control, injector, 2816);
    }

    public Composite getControl() {
        return this.fControl;
    }

    public XtextSourceViewer getViewer() {
        return this.fSourceViewer;
    }

    public XtextResource getResource() {
        return this.fResource;
    }

    public IXtextDocument getDocument() {
        return this.fDocument;
    }

    protected void setText(XtextDocument document, String text) {
        document.set(text);
        this.fResource = this.createResource(text);
        document.setInput(this.fResource);
        AnnotationModel annotationModel = new AnnotationModel();
        if (document instanceof ISynchronizable) {
            Object lock = ((ISynchronizable)document).getLockObject();
            if (lock == null) {
                lock = new Object();
                ((ISynchronizable)document).setLockObject(lock);
            }
            annotationModel.setLockObject(lock);
        }
        this.fSourceViewer.setDocument((IDocument)document, (IAnnotationModel)annotationModel);
    }

    private XtextResource createResource(String content) {
        XtextResource result = this.createResource();
        try {
            result.load((InputStream)new StringInputStream(content, result.getEncoding()), Collections.emptyMap());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private void createEditor(Composite parent) {
        this.createViewer(parent);
        Control control = this.fSourceViewer.getControl();
        GridData data = new GridData(4, 4, true, true);
        control.setLayoutData((Object)data);
        this.createActions();
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EmbeddedXtextEditor.this.menuAboutToShow(mgr);
            }
        });
        StyledText text = this.fSourceViewer.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", this.fActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", this.fActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", this.fActions.get(ITextEditorActionConstants.PASTE));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.appendToGroup("group.generate", this.fActions.get("org.eclipse.ui.edit.text.contentAssist.proposals"));
    }

    private void createViewer(Composite parent) {
        this.createSourceViewer(parent);
        this.installFoldingSupport((ProjectionViewer)this.fSourceViewer);
        this.setText(this.fDocument, "");
        this.fHighlightingHelper.install(this.fViewerConfiguration, this.fSourceViewer);
    }

    private IVerticalRuler createVerticalRuler() {
        return new CompositeRuler();
    }

    protected IVerticalRulerColumn createAnnotationRulerColumn(CompositeRuler ruler) {
        return new AnnotationRulerColumn(12, this.getAnnotationAccess());
    }

    private void createSourceViewer(Composite parent) {
        this.fVerticalRuler = this.createVerticalRuler();
        this.fSourceViewer = this.fSourceViewerFactory.createSourceViewer(parent, this.fVerticalRuler, this.getOverviewRuler(), true, this.fStyle);
        this.fViewerConfiguration = (XtextSourceViewerConfiguration)this.fSourceViewerConfigurationProvider.get();
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.installProjectionSupport((ProjectionViewer)this.fSourceViewer);
        this.getSourceViewerDecorationSupport((ISourceViewer)this.fSourceViewer);
        this.fSourceViewer.getTextWidget().addFocusListener((FocusListener)new SourceViewerFocusListener());
        this.fSourceViewerDecorationSupport.install(this.fPreferenceStoreAccess.getPreferenceStore());
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EmbeddedXtextEditor.this.fSourceViewerDecorationSupport.dispose();
            }
        });
        this.fDocument = (XtextDocument)this.fDocumentProvider.get();
        IDocumentPartitioner partitioner = (IDocumentPartitioner)this.documentPartitioner.get();
        partitioner.connect((IDocument)this.fDocument);
        this.fDocument.setDocumentPartitioner(partitioner);
        ValidationJob job = new ValidationJob(this.fResourceValidator, (IReadAccess)this.fDocument, new IValidationIssueProcessor(){
            private AnnotationIssueProcessor annotationIssueProcessor;

            public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
                if (this.annotationIssueProcessor == null) {
                    this.annotationIssueProcessor = new AnnotationIssueProcessor((IXtextDocument)EmbeddedXtextEditor.this.fDocument, EmbeddedXtextEditor.this.fSourceViewer.getAnnotationModel(), (IssueResolutionProvider)new IssueResolutionProvider.NullImpl());
                }
                if (this.annotationIssueProcessor != null) {
                    this.annotationIssueProcessor.processIssues(issues, monitor);
                }
            }
        }, CheckMode.FAST_ONLY);
        this.fDocument.setValidationJob((Job)job);
        this.fSourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EmbeddedXtextEditor.this.updateSelectionDependentActions();
            }
        });
    }

    private ProjectionSupport installProjectionSupport(ProjectionViewer projectionViewer) {
        ProjectionSupport projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        projectionSupport.addSummarizableAnnotationType(WARNING_ANNOTATION_TYPE);
        projectionSupport.addSummarizableAnnotationType(ERROR_ANNOTATION_TYPE);
        projectionSupport.setAnnotationPainterDrawingStrategy(this.projectionAnnotationDrawingStrategy);
        projectionSupport.install();
        return projectionSupport;
    }

    private void installFoldingSupport(ProjectionViewer projectionViewer) {
    }

    private SourceViewerDecorationSupport getSourceViewerDecorationSupport(ISourceViewer viewer) {
        if (this.fSourceViewerDecorationSupport == null) {
            this.fSourceViewerDecorationSupport = new SourceViewerDecorationSupport(viewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
            this.configureSourceViewerDecorationSupport(this.fSourceViewerDecorationSupport);
        }
        return this.fSourceViewerDecorationSupport;
    }

    private void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        UnmodifiableIterator e = Iterators.filter(this.fAnnotationPreferences.getAnnotationPreferences().iterator(), AnnotationPreference.class);
        while (e.hasNext()) {
            support.setAnnotationPreference((AnnotationPreference)e.next());
        }
        support.setCursorLinePainterPreferenceKeys("currentLine", "currentLineColor");
        support.setMarginPainterPreferenceKeys("printMargin", "printMarginColor", "printMarginColumn");
        if (this.characterPairMatcher != null) {
            support.setCharacterPairMatcher(this.characterPairMatcher);
            support.setMatchingCharacterPainterPreferenceKeys("CharacterMatching", "CharacterMatching.Color");
        }
    }

    private IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null && (this.fStyle & 0x200) != 0) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    private IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    private IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess(){

            public int getLayer(Annotation annotation) {
                if (annotation.isMarkedDeleted()) {
                    return 0;
                }
                return super.getLayer(annotation);
            }
        };
    }

    private IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    private ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    public void update(String text) {
        IDocument document = this.fSourceViewer.getDocument();
        this.fSourceViewer.setRedraw(false);
        document.set(text);
        this.fSourceViewer.setVisibleRegion(0, text.length());
        this.fSourceViewer.setRedraw(true);
    }

    private void createActions() {
        Action action = new TextViewerAction((ITextViewer)this.fSourceViewer, 3);
        action.setText("Cut");
        this.setAction(ITextEditorActionConstants.CUT, (IAction)action);
        this.setAsSelectionDependantAction((IAction)action);
        action = new TextViewerAction((ITextViewer)this.fSourceViewer, 4);
        action.setText("Copy");
        this.setAction(ITextEditorActionConstants.COPY, (IAction)action);
        this.setAsSelectionDependantAction((IAction)action);
        action = new TextViewerAction((ITextViewer)this.fSourceViewer, 5);
        action.setText("Paste");
        this.setAction(ITextEditorActionConstants.PASTE, (IAction)action);
        this.setAsSelectionDependantAction((IAction)action);
        action = new TextViewerAction((ITextViewer)this.fSourceViewer, 13);
        action.setText("Content Assist");
        this.setAction("org.eclipse.ui.edit.text.contentAssist.proposals", (IAction)action);
        this.setAsContextDependantAction((IAction)action);
        if (this.fViewerConfiguration.getContentFormatter((ISourceViewer)this.fSourceViewer) != null) {
            action = new TextViewerAction((ITextViewer)this.fSourceViewer, 15);
            action.setText("Format");
            this.setAction(XTEXT_UI_FORMAT_ACTION, (IAction)action);
            this.setAsContextDependantAction((IAction)action);
        }
        action = new ToggleSLCommentAction((ITextViewer)this.fSourceViewer);
        this.setAction(XTEXT_UI_TOGGLE_SL_COMMENT_ACTION, (IAction)action);
        this.setAsContextDependantAction((IAction)action);
        action.configure((ISourceViewer)this.fSourceViewer, (SourceViewerConfiguration)this.fViewerConfiguration);
    }

    private void setAction(String actionID, IAction action) {
        if (action.getId() == null) {
            action.setId(actionID);
        }
        this.fActions.put(actionID, action);
    }

    private void setAsContextDependantAction(IAction action) {
        this.fActionHandlers.add(new ActionHandler(action));
    }

    private void setAsSelectionDependantAction(IAction action) {
        this.fSelectionDependentActions.add(action);
    }

    private void updateSelectionDependentActions() {
        for (IAction action : this.fSelectionDependentActions) {
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    protected void updateAction(IAction action) {
    }

    protected XtextResource createResource() {
        String dummyFileName = String.valueOf(this.fGrammarAccess.getGrammar().getName()) + "." + this.fFileExtension;
        URI dummyURI = URI.createURI((String)dummyFileName);
        ResourceSet resourceSet = this.getResourceSet();
        XtextResource result = (XtextResource)this.fXtextResourceProvider.get();
        result.setURI(dummyURI);
        resourceSet.getResources().add((Object)result);
        return result;
    }

    public void dispose() {
        OCLInternal ocl2 = this.ocl;
        ocl2.dispose();
    }

    public ResourceSet getResourceSet() {
        return this.fResourceSetProvider.get(null);
    }

    @NonNull
    public OCL getOCL() {
        return this.ocl;
    }

    @NonNull
    public EnvironmentFactory getEnvironmentFactory() {
        return this.ocl.getEnvironmentFactory();
    }

    protected void internalSetOCL(@NonNull OCLInternal ocl) {
        this.ocl = ocl;
        ResourceSet csResourceSet = this.getResourceSet();
        if (csResourceSet != null) {
            EnvironmentFactoryInternal environmentFactory = ocl.getEnvironmentFactory();
            environmentFactory.adapt((Notifier)csResourceSet);
        }
    }

    private final class SourceViewerFocusListener
    implements FocusListener {
        private static final String EMBEDEDXTEXT_EDITOR_CONTEXT = "org.eclipse.ocl.examples.xtext.console.xtext.embededxtextEditor.context";
        private final Expression fExpression;
        private final List<IHandlerActivation> fHandlerActivations;
        private IContextActivation fContextActivation;

        public SourceViewerFocusListener() {
            this.fExpression = new ActiveShellExpression(EmbeddedXtextEditor.this.fSourceViewer.getControl().getShell());
            this.fHandlerActivations = Lists.newArrayList();
            EmbeddedXtextEditor.this.fSourceViewer.getControl().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
                    if (handlerService != null) {
                        handlerService.deactivateHandlers((Collection)SourceViewerFocusListener.this.fHandlerActivations);
                    }
                    SourceViewerFocusListener.this.fHandlerActivations.clear();
                }
            });
        }

        public void focusLost(FocusEvent e) {
            IHandlerService handlerService;
            IWorkbenchPage activePage;
            IEditorPart activeEditor;
            IWorkbench workbench;
            IWorkbenchWindow activeWorkbenchWindow;
            if (this.fContextActivation != null && (activeWorkbenchWindow = (workbench = PlatformUI.getWorkbench()).getActiveWorkbenchWindow()) != null && (activeEditor = (activePage = activeWorkbenchWindow.getActivePage()).getActiveEditor()) != null) {
                IWorkbenchPartSite site = activeEditor.getSite();
                IContextService contextService = (IContextService)site.getService(IContextService.class);
                contextService.deactivateContext(this.fContextActivation);
            }
            if ((handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class)) != null) {
                handlerService.deactivateHandlers(this.fHandlerActivations);
            }
        }

        public void focusGained(FocusEvent e) {
            IHandlerService handlerService;
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow != null) {
                IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
                IEditorPart activeEditor = activePage.getActiveEditor();
                if (activeEditor != null) {
                    IWorkbenchPartSite site = activeEditor.getSite();
                    IContextService contextService = (IContextService)site.getService(IContextService.class);
                    this.fContextActivation = contextService.activateContext(EMBEDEDXTEXT_EDITOR_CONTEXT);
                } else {
                    this.fContextActivation = null;
                }
            }
            if ((handlerService = (IHandlerService)workbench.getAdapter(IHandlerService.class)) != null) {
                for (ActionHandler actionHandler : EmbeddedXtextEditor.this.fActionHandlers) {
                    this.fHandlerActivations.add(handlerService.activateHandler(actionHandler.getAction().getId(), (IHandler)actionHandler, this.fExpression));
                }
            }
        }
    }
}

