/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.PivotTables;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.ReferringElement;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ValueSpecification;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.NavigationCallExpImpl;
import org.eclipse.ocl.pivot.internal.manager.TemplateSpecialisation;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.library.classifier.OclTypeConformsToOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanAndOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanImpliesOperation;
import org.eclipse.ocl.pivot.library.logical.BooleanNotOperation;
import org.eclipse.ocl.pivot.library.oclany.OclComparableLessThanEqualOperation;
import org.eclipse.ocl.pivot.library.string.CGStringGetSeverityOperation;
import org.eclipse.ocl.pivot.library.string.CGStringLogDiagnosticOperation;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.IntegerValue;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class PropertyCallExpImpl
extends NavigationCallExpImpl
implements PropertyCallExp {
    protected Property referredProperty;

    protected PropertyCallExpImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.PROPERTY_CALL_EXP;
    }

    @Override
    public Property getReferredProperty() {
        if (this.referredProperty != null && this.referredProperty.eIsProxy()) {
            InternalEObject oldReferredProperty = (InternalEObject)this.referredProperty;
            this.referredProperty = (Property)this.eResolveProxy(oldReferredProperty);
            if (this.referredProperty != oldReferredProperty && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 15, (Object)oldReferredProperty, (Object)this.referredProperty));
            }
        }
        return this.referredProperty;
    }

    public Property basicGetReferredProperty() {
        return this.referredProperty;
    }

    @Override
    public void setReferredProperty(Property newReferredProperty) {
        Property oldReferredProperty = this.referredProperty;
        this.referredProperty = newReferredProperty;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldReferredProperty, (Object)this.referredProperty));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getAnnotatingComments();
            }
            case 1: {
                return this.getOwnedAnnotations();
            }
            case 2: {
                return this.getOwnedComments();
            }
            case 3: {
                return this.getOwnedExtensions();
            }
            case 4: {
                return this.getName();
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return this.isIsRequired();
            }
            case 7: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 8: {
                return this.getTypeValue();
            }
            case 9: {
                return this.isIsImplicit();
            }
            case 10: {
                return this.isIsSafe();
            }
            case 11: {
                return this.getOwnedSource();
            }
            case 12: {
                return this.isIsPre();
            }
            case 13: {
                if (resolve) {
                    return this.getNavigationSource();
                }
                return this.basicGetNavigationSource();
            }
            case 14: {
                return this.getQualifiers();
            }
            case 15: {
                if (resolve) {
                    return this.getReferredProperty();
                }
                return this.basicGetReferredProperty();
            }
        }
        return this.eDynamicGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                this.getAnnotatingComments().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                this.getOwnedAnnotations().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                this.getOwnedComments().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                this.getOwnedExtensions().addAll((Collection)newValue);
                return;
            }
            case 4: {
                this.setName((String)newValue);
                return;
            }
            case 6: {
                this.setIsRequired((Boolean)newValue);
                return;
            }
            case 7: {
                this.setType((Type)newValue);
                return;
            }
            case 8: {
                this.setTypeValue((Type)newValue);
                return;
            }
            case 9: {
                this.setIsImplicit((Boolean)newValue);
                return;
            }
            case 10: {
                this.setIsSafe((Boolean)newValue);
                return;
            }
            case 11: {
                this.setOwnedSource((OCLExpression)newValue);
                return;
            }
            case 12: {
                this.setIsPre((Boolean)newValue);
                return;
            }
            case 13: {
                this.setNavigationSource((Property)newValue);
                return;
            }
            case 14: {
                this.getQualifiers().clear();
                this.getQualifiers().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setReferredProperty((Property)newValue);
                return;
            }
        }
        this.eDynamicSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getAnnotatingComments().clear();
                return;
            }
            case 1: {
                this.getOwnedAnnotations().clear();
                return;
            }
            case 2: {
                this.getOwnedComments().clear();
                return;
            }
            case 3: {
                this.getOwnedExtensions().clear();
                return;
            }
            case 4: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 6: {
                this.setIsRequired(true);
                return;
            }
            case 7: {
                this.setType(null);
                return;
            }
            case 8: {
                this.setTypeValue(null);
                return;
            }
            case 9: {
                this.setIsImplicit(false);
                return;
            }
            case 10: {
                this.setIsSafe(false);
                return;
            }
            case 11: {
                this.setOwnedSource(null);
                return;
            }
            case 12: {
                this.setIsPre(false);
                return;
            }
            case 13: {
                this.setNavigationSource(null);
                return;
            }
            case 14: {
                this.getQualifiers().clear();
                return;
            }
            case 15: {
                this.setReferredProperty(null);
                return;
            }
        }
        this.eDynamicUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.annotatingComments != null && !this.annotatingComments.isEmpty();
            }
            case 1: {
                return this.ownedAnnotations != null && !this.ownedAnnotations.isEmpty();
            }
            case 2: {
                return this.ownedComments != null && !this.ownedComments.isEmpty();
            }
            case 3: {
                return this.ownedExtensions != null && !this.ownedExtensions.isEmpty();
            }
            case 4: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 5: {
                return this.isIsMany();
            }
            case 6: {
                return (this.eFlags & 0x100) == 0;
            }
            case 7: {
                return this.type != null;
            }
            case 8: {
                return this.typeValue != null;
            }
            case 9: {
                return (this.eFlags & 0x200) != 0;
            }
            case 10: {
                return (this.eFlags & 0x400) != 0;
            }
            case 11: {
                return this.ownedSource != null;
            }
            case 12: {
                return (this.eFlags & 0x800) != 0;
            }
            case 13: {
                return this.navigationSource != null;
            }
            case 14: {
                return this.qualifiers != null && !this.qualifiers.isEmpty();
            }
            case 15: {
                return this.referredProperty != null;
            }
        }
        return this.eDynamicIsSet(featureID);
    }

    public int eDerivedOperationID(int baseOperationID, java.lang.Class<?> baseClass) {
        if (baseClass == ReferringElement.class) {
            switch (baseOperationID) {
                case 0: {
                    return 4;
                }
            }
            return -1;
        }
        return super.eDerivedOperationID(baseOperationID, baseClass);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.CompatibleBody((ValueSpecification)arguments.get(0));
            }
            case 3: {
                return this.validateTypeIsNotInvalid((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 4: {
                return this.getReferredElement();
            }
            case 5: {
                return this.getSpecializedReferredPropertyOwningType();
            }
            case 6: {
                return this.getSpecializedReferredPropertyType();
            }
            case 7: {
                return this.validateCompatibleResultType((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 8: {
                return this.validateNonStaticSourceTypeIsConformant((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 9: {
                return this.validateSafeSourceCanBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
            case 10: {
                return this.validateUnsafeSourceCanNotBeNull((DiagnosticChain)arguments.get(0), (Map)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitPropertyCallExp(this);
    }

    @Override
    public Element getReferredElement() {
        return this.getReferredProperty();
    }

    @Override
    @NonNull
    public Class getSpecializedReferredPropertyOwningType() {
        Evaluator evaluator;
        Property referredProperty = this.getReferredProperty();
        Class referencedType = referredProperty.getOwningClass();
        if (TemplateSpecialisation.needsSpecialisation(referencedType)) {
            evaluator = PivotUtilInternal.getEvaluator(this);
            TemplateSpecialisation templateSpecialization = new TemplateSpecialisation(evaluator.getCompleteEnvironment());
            Type resultType = this.getType();
            templateSpecialization.installEquivalence(resultType, referredProperty.getType());
            if (referencedType != null) {
                return templateSpecialization.getSpecialisation(referencedType);
            }
        }
        if (referencedType != null) {
            return referencedType;
        }
        evaluator = PivotUtilInternal.getEvaluator(this);
        return evaluator.getCompleteEnvironment().getOwnedStandardLibrary().getOclInvalidType();
    }

    @Override
    @NonNull
    public Class getSpecializedReferredPropertyType() {
        Evaluator evaluator;
        Type referencedType;
        Property referredProperty = this.getReferredProperty();
        Type specializedType = referencedType = referredProperty.getType();
        if (referencedType != null && TemplateSpecialisation.needsSpecialisation(referencedType)) {
            evaluator = PivotUtilInternal.getEvaluator(this);
            TemplateSpecialisation templateSpecialization = new TemplateSpecialisation(evaluator.getCompleteEnvironment());
            Type resultType = this.getType();
            templateSpecialization.installEquivalence(resultType, referredProperty.getType());
            specializedType = templateSpecialization.getSpecialisation(referencedType);
        }
        if (specializedType instanceof DataType) {
            Class behavioralType = ((DataType)specializedType).getBehavioralClass();
            return behavioralType != null ? behavioralType : (DataType)specializedType;
        }
        if (specializedType instanceof Class) {
            return (Class)specializedType;
        }
        evaluator = PivotUtilInternal.getEvaluator(this);
        return evaluator.getCompleteEnvironment().getOwnedStandardLibrary().getOclInvalidType();
    }

    @Override
    public boolean validateNonStaticSourceTypeIsConformant(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_2;
        IntegerValue severity_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "PropertyCallExp::NonStaticSourceTypeIsConformant"), PivotTables.INT_0);
        if (le) {
            symbol_2 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_conformsTo;
                Serializable CAUGHT_not;
                try {
                    Boolean safe_isStatic_source;
                    Object CAUGHT_referredProperty;
                    Property referredProperty = this.getReferredProperty();
                    try {
                        CAUGHT_referredProperty = referredProperty;
                    }
                    catch (Exception e) {
                        CAUGHT_referredProperty = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_referredProperty == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_isStatic_source = null;
                    } else {
                        assert (referredProperty != null);
                        boolean isStatic = referredProperty.isIsStatic();
                        safe_isStatic_source = isStatic;
                    }
                    Boolean not = BooleanNotOperation.INSTANCE.evaluate(safe_isStatic_source);
                    CAUGHT_not = not;
                }
                catch (Exception e) {
                    CAUGHT_not = ValueUtil.createInvalidValue(e);
                }
                try {
                    Type safe_type_source;
                    Object CAUGHT_ownedSource;
                    OCLExpression ownedSource = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource = ownedSource;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_1 = CAUGHT_ownedSource == null;
                    if (symbol_1 == Boolean.TRUE) {
                        safe_type_source = null;
                    } else {
                        Type type;
                        assert (ownedSource != null);
                        safe_type_source = type = ownedSource.getType();
                    }
                    Class getSpecializedReferredPropertyOwningType = this.getSpecializedReferredPropertyOwningType();
                    boolean conformsTo = OclTypeConformsToOperation.INSTANCE.evaluate(evaluator, safe_type_source, getSpecializedReferredPropertyOwningType);
                    CAUGHT_conformsTo = Boolean.valueOf(conformsTo);
                }
                catch (Exception e) {
                    CAUGHT_conformsTo = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_not, CAUGHT_conformsTo);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_2 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "PropertyCallExp::NonStaticSourceTypeIsConformant", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_2;
    }

    @Override
    public boolean validateSafeSourceCanBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        IntegerValue severity_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "PropertyCallExp::SafeSourceCanBeNull"), PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Serializable CAUGHT_not;
                Serializable CAUGHT_and;
                try {
                    Serializable CAUGHT_isSafe;
                    Serializable CAUGHT_ne;
                    try {
                        OCLExpression ownedSource = this.getOwnedSource();
                        boolean ne = ownedSource != null;
                        CAUGHT_ne = Boolean.valueOf(ne);
                    }
                    catch (Exception e) {
                        CAUGHT_ne = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Boolean isSafe = this.isIsSafe();
                        CAUGHT_isSafe = isSafe;
                    }
                    catch (Exception e) {
                        CAUGHT_isSafe = ValueUtil.createInvalidValue(e);
                    }
                    Boolean and = BooleanAndOperation.INSTANCE.evaluate(CAUGHT_ne, CAUGHT_isSafe);
                    CAUGHT_and = and;
                }
                catch (Exception e) {
                    CAUGHT_and = ValueUtil.createInvalidValue(e);
                }
                try {
                    Boolean safe_isRequired_source;
                    Object CAUGHT_ownedSource_0;
                    OCLExpression ownedSource_0 = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource_0 = ownedSource_0;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource_0 = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_ownedSource_0 == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_isRequired_source = null;
                    } else {
                        assert (ownedSource_0 != null);
                        boolean isRequired = ownedSource_0.isIsRequired();
                        safe_isRequired_source = isRequired;
                    }
                    Boolean not = BooleanNotOperation.INSTANCE.evaluate(safe_isRequired_source);
                    CAUGHT_not = not;
                }
                catch (Exception e) {
                    CAUGHT_not = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_and, CAUGHT_not);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "PropertyCallExp::SafeSourceCanBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateUnsafeSourceCanNotBeNull(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_1;
        IntegerValue severity_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "PropertyCallExp::UnsafeSourceCanNotBeNull"), PivotTables.INT_0);
        if (le) {
            symbol_1 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                InvalidValueException CAUGHT_safe_isRequired_source;
                Serializable CAUGHT_and;
                try {
                    Serializable CAUGHT_not;
                    Serializable CAUGHT_ne;
                    try {
                        OCLExpression ownedSource = this.getOwnedSource();
                        boolean ne = ownedSource != null;
                        CAUGHT_ne = Boolean.valueOf(ne);
                    }
                    catch (Exception e) {
                        CAUGHT_ne = ValueUtil.createInvalidValue(e);
                    }
                    try {
                        Boolean isSafe = this.isIsSafe();
                        Boolean not = BooleanNotOperation.INSTANCE.evaluate(isSafe);
                        CAUGHT_not = not;
                    }
                    catch (Exception e) {
                        CAUGHT_not = ValueUtil.createInvalidValue(e);
                    }
                    Boolean and = BooleanAndOperation.INSTANCE.evaluate(CAUGHT_ne, CAUGHT_not);
                    CAUGHT_and = and;
                }
                catch (Exception e) {
                    CAUGHT_and = ValueUtil.createInvalidValue(e);
                }
                try {
                    Boolean safe_isRequired_source;
                    Object CAUGHT_ownedSource_0;
                    OCLExpression ownedSource_0 = this.getOwnedSource();
                    try {
                        CAUGHT_ownedSource_0 = ownedSource_0;
                    }
                    catch (Exception e) {
                        CAUGHT_ownedSource_0 = ValueUtil.createInvalidValue(e);
                    }
                    Boolean symbol_0 = CAUGHT_ownedSource_0 == null;
                    if (symbol_0 == Boolean.TRUE) {
                        safe_isRequired_source = null;
                    } else {
                        assert (ownedSource_0 != null);
                        boolean isRequired = ownedSource_0.isIsRequired();
                        safe_isRequired_source = isRequired;
                    }
                    CAUGHT_safe_isRequired_source = safe_isRequired_source;
                }
                catch (Exception e) {
                    CAUGHT_safe_isRequired_source = ValueUtil.createInvalidValue(e);
                }
                Boolean status = BooleanImpliesOperation.INSTANCE.evaluate(CAUGHT_and, CAUGHT_safe_isRequired_source);
                CAUGHT_status = status;
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_1 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "PropertyCallExp::UnsafeSourceCanNotBeNull", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_1;
    }

    @Override
    public boolean validateCompatibleResultType(DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean symbol_0;
        IntegerValue severity_0;
        Evaluator evaluator = PivotUtilInternal.getEvaluator(this);
        boolean le = OclComparableLessThanEqualOperation.INSTANCE.evaluate(evaluator, severity_0 = CGStringGetSeverityOperation.INSTANCE.evaluate(evaluator, "PropertyCallExp::CompatibleResultType"), PivotTables.INT_0);
        if (le) {
            symbol_0 = ValueUtil.TRUE_VALUE;
        } else {
            boolean logDiagnostic;
            Serializable CAUGHT_status;
            try {
                Type type = this.getType();
                Class getSpecializedReferredPropertyType = this.getSpecializedReferredPropertyType();
                boolean status = type != null ? type.getTypeId() == getSpecializedReferredPropertyType.getTypeId() : false;
                CAUGHT_status = Boolean.valueOf(status);
            }
            catch (Exception e) {
                CAUGHT_status = ValueUtil.createInvalidValue(e);
            }
            symbol_0 = logDiagnostic = CGStringLogDiagnosticOperation.INSTANCE.evaluate(evaluator, TypeId.BOOLEAN, "PropertyCallExp::CompatibleResultType", this, null, diagnostics, context, null, severity_0, CAUGHT_status, PivotTables.INT_0).booleanValue();
        }
        return Boolean.TRUE == symbol_0;
    }
}

