/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.NamedElementImpl;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.values.OCLValue;

public abstract class TypeImpl
extends NamedElementImpl
implements Type {
    protected TypeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PivotPackage.Literals.TYPE;
    }

    @Override
    public Class isClass() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TemplateParameter isTemplateParameter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type specializeIn(CallExp expr, Type selfType) {
        return this;
    }

    @Override
    public Type flattenedType() {
        return this;
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.allOwnedElements();
            }
            case 1: {
                return this.getValue((Type)arguments.get(0), (String)arguments.get(1));
            }
            case 2: {
                return this.flattenedType();
            }
            case 3: {
                return this.isClass();
            }
            case 4: {
                return this.isTemplateParameter();
            }
            case 5: {
                return this.specializeIn((CallExp)arguments.get(0), (Type)arguments.get(1));
            }
        }
        return this.eDynamicInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public <R> R accept(@NonNull Visitor<R> visitor) {
        return visitor.visitType(this);
    }

    @NonNull
    public EObject createInstance() {
        EObject eTarget = this.getESObject();
        if (eTarget instanceof EClass) {
            EClass eClass = (EClass)eTarget;
            EObject element = eClass.getEPackage().getEFactoryInstance().create(eClass);
            return element;
        }
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Object createInstance(@NonNull String value) {
        EObject eTarget = this.getESObject();
        if (eTarget instanceof EDataType) {
            EDataType eDataType = (EDataType)eTarget;
            Object element = eDataType.getEPackage().getEFactoryInstance().createFromString(eDataType, value);
            return element;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public Type getCommonType(@NonNull IdResolver idResolver, @NonNull Type type) {
        if (type == this) {
            return this;
        }
        StandardLibrary standardLibrary = idResolver.getStandardLibrary();
        CompleteInheritance thisInheritance = this.getInheritance(standardLibrary);
        CompleteInheritance thatInheritance = type.getInheritance(standardLibrary);
        return thisInheritance.getCommonInheritance(thatInheritance).getPivotClass();
    }

    @Override
    public boolean isEqualTo(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        Class thatType;
        if (this == type) {
            return true;
        }
        Class thisType = this.getNormalizedType(standardLibrary);
        return thisType == (thatType = type.getNormalizedType(standardLibrary));
    }

    @Override
    public boolean isEqualToUnspecializedType(@NonNull StandardLibrary standardLibrary, @NonNull Type type) {
        return this == type;
    }

    @Override
    public boolean oclEquals(@NonNull OCLValue thatValue) {
        if (!(thatValue instanceof Type)) {
            return false;
        }
        TypeId thisTypeId = this.getTypeId();
        TypeId thatTypeId = ((Type)thatValue).getTypeId();
        return thisTypeId.equals(thatTypeId);
    }

    @Override
    public int oclHashCode() {
        return this.getTypeId().hashCode();
    }

    public Package getPackage() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public TemplateParameters getTypeParameters() {
        throw new UnsupportedOperationException();
    }
}

