/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.attributes;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Import;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Namespace;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.scoping.AbstractAttribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;

public class ModelAttribution
extends AbstractAttribution {
    public static final ModelAttribution INSTANCE = new ModelAttribution();

    @Override
    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        Model targetModel = (Model)target;
        environmentView.addAllPackages(targetModel);
        if (environmentView.accepts(PivotPackage.Literals.NAMESPACE)) {
            for (Import anImport : targetModel.getOwnedImports()) {
                Namespace namespace = anImport.getImportedNamespace();
                if (namespace == null || namespace.eIsProxy()) continue;
                String importName = anImport.getName();
                if (importName == null) {
                    if (!(namespace instanceof Package)) continue;
                    environmentView.addAllPackages((Package)namespace);
                    continue;
                }
                environmentView.addElement(importName, namespace);
            }
            if (!environmentView.hasFinalResult()) {
                URI baseURI;
                Resource eResource;
                environmentView.addRootPackages();
                if (!environmentView.hasFinalResult() && (eResource = targetModel.eResource()) != null && (baseURI = eResource.getURI()) != null) {
                    environmentView.addImportedElement(baseURI);
                }
            }
        }
        return scopeView.getParent();
    }
}

