/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.TemplateParameters;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.CompleteClassInternal;
import org.eclipse.ocl.pivot.internal.executor.PivotReflectiveFragment;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorTypeParameter;
import org.eclipse.ocl.pivot.internal.library.executor.ReflectiveInheritance;
import org.eclipse.ocl.pivot.types.AbstractFragment;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class CompleteInheritanceImpl
extends ReflectiveInheritance
implements CompleteInheritance {
    @NonNull
    public static final List<CompleteInheritanceImpl> EMPTY_LIST = Collections.emptyList();
    @NonNull
    public static final BestOperation bestOperation = new BestOperation();
    @NonNull
    protected final CompleteClassInternal completeClass;

    @NonNull
    public static TemplateParameterSubstitution createTemplateParameterSubstitution(@NonNull TemplateParameter formalParameter, @NonNull Type type) {
        TemplateParameterSubstitution templateParameterSubstitution = PivotFactory.eINSTANCE.createTemplateParameterSubstitution();
        templateParameterSubstitution.setFormal(formalParameter);
        templateParameterSubstitution.setActual(type);
        return templateParameterSubstitution;
    }

    public CompleteInheritanceImpl(@NonNull CompleteClassInternal completeClass) {
        super(ClassUtil.nonNullModel(completeClass.getName()), CompleteInheritanceImpl.computeFlags(completeClass.getPrimaryClass()), new ExecutorTypeParameter[0]);
        this.completeClass = completeClass;
        Class pivotClass = completeClass.getPrimaryClass();
        assert (!(pivotClass instanceof DataType) || ((DataType)pivotClass).getBehavioralClass() == null);
    }

    @Override
    @NonNull
    protected AbstractFragment createFragment(@NonNull CompleteInheritance baseInheritance) {
        return new PivotReflectiveFragment(this, baseInheritance);
    }

    @NonNull
    public CompleteClassInternal getCompleteClass() {
        return this.completeClass;
    }

    @Override
    @NonNull
    public Iterable<? extends CompleteInheritance> getInitialSuperInheritances() {
        return this.isOclAny() ? EMPTY_LIST : this.completeClass.getPartialClasses().getInitialSuperInheritances();
    }

    @NonNull
    public List<? extends Operation> getLocalOperations() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedOperations());
    }

    @NonNull
    public List<? extends Property> getLocalProperties() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedProperties());
    }

    @Override
    @Nullable
    public Operation getMemberOperation(@NonNull OperationId operationId) {
        return this.completeClass.getOperation(operationId);
    }

    @Override
    @Nullable
    public Property getMemberProperty(@NonNull String propertyName) {
        return this.completeClass.getProperty(propertyName);
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        return this.completeClass.getPrimaryClass().getMetaTypeName();
    }

    @Override
    @NonNull
    public List<Property> getOwnedProperties() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedProperties());
    }

    @Override
    @NonNull
    public List<Operation> getOwnedOperations() {
        return ClassUtil.nonNullEMF(this.completeClass.getPrimaryClass().getOwnedOperations());
    }

    @Override
    @NonNull
    public Class getPivotClass() {
        return this.getCompleteClass().getPrimaryClass();
    }

    @Override
    @NonNull
    public List<Class> getSuperClasses() {
        ArrayList<Class> superClasses = new ArrayList<Class>();
        for (Class superClass : this.completeClass.getProperSuperClasses()) {
            superClasses.add(superClass);
        }
        return superClasses;
    }

    @Override
    @NonNull
    public final TypeId getTypeId() {
        return this.completeClass.getPrimaryClass().getTypeId();
    }

    @Override
    @NonNull
    public TemplateParameters getTypeParameters() {
        return TemplateParameters.EMPTY_LIST;
    }

    public String toString() {
        return this.completeClass.getPrimaryClass().toString();
    }

    @Override
    public void uninstall() {
        this.completeClass.uninstall();
        super.uninstall();
    }

    public static final class BestOperation
    implements Function<List<Operation>, Operation> {
        public Operation apply(List<Operation> operations) {
            return operations.get(0);
        }
    }
}

