/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;
import org.eclipse.ocl.pivot.internal.utilities.IllegalMetamodelException;

public class CompleteURIs {
    @NonNull
    protected final CompleteModelInternal completeModel;
    @NonNull
    private final Map<String, Set<String>> completeURI2packageURIs = new HashMap<String, Set<String>>();
    @NonNull
    private final Map<String, String> packageURI2completeURI = new HashMap<String, String>();
    @NonNull
    private final Map<String, CompletePackageInternal> completeURI2completePackage = new HashMap<String, CompletePackageInternal>();

    public CompleteURIs(@NonNull CompleteModelInternal completeModel) {
        this.completeModel = completeModel;
    }

    public void didAddCompletePackage(@NonNull CompletePackageInternal completePackage) {
        String completeURI = completePackage.getURI();
        if (completeURI != null) {
            CompletePackage oldCompletePackage = this.completeURI2completePackage.put(completeURI, completePackage);
            assert (oldCompletePackage == null);
        }
    }

    public void didAddPartialModel(@NonNull Model partialModel) {
        for (Package asPackage : partialModel.getOwnedPackages()) {
            PackageId packageId;
            String packageURI = asPackage.getURI();
            String completeURI = this.getCompleteURI(packageURI);
            if (completeURI != packageURI || (packageId = asPackage.getPackageId()) != IdManager.METAMODEL || packageURI == null) continue;
            this.addPackageURI2completeURI(packageURI, "$metamodel$");
        }
    }

    public void didRemoveCompletePackage(@NonNull CompletePackageInternal completePackage) {
        String completeURI = completePackage.getURI();
        if (completeURI != null) {
            this.completeURI2completePackage.remove(completeURI);
            Set<String> packageURIs = this.completeURI2packageURIs.remove(completeURI);
            if (packageURIs != null) {
                for (String packageURI : packageURIs) {
                    this.packageURI2completeURI.remove(packageURI);
                }
            }
        }
    }

    public void didRemovePartialModel(@NonNull Model partialModel) {
        for (Package asPackage : partialModel.getOwnedPackages()) {
            PackageId packageId;
            String packageURI = asPackage.getURI();
            String completeURI = this.getCompleteURI(packageURI);
            if (completeURI == packageURI && (packageId = asPackage.getPackageId()) != IdManager.METAMODEL) continue;
        }
    }

    public synchronized void dispose() {
        this.completeURI2completePackage.clear();
    }

    @NonNull
    public Iterable<CompletePackageInternal> getAllCompletePackages() {
        return this.completeURI2completePackage.values();
    }

    @NonNull
    public Iterable<? extends CompletePackageInternal> getAllCompletePackagesWithUris() {
        return this.completeURI2completePackage.values();
    }

    public void addPackageURI2completeURI(@NonNull String packageURI, @NonNull String newCompleteURI) {
        String oldCompleteURI = this.packageURI2completeURI.get(packageURI);
        if (newCompleteURI.equals(oldCompleteURI)) {
            return;
        }
        if (oldCompleteURI != null) {
            throw new IllegalMetamodelException(newCompleteURI, oldCompleteURI);
        }
        if (this.completeURI2packageURIs.containsKey(packageURI)) {
            throw new IllegalMetamodelException(packageURI, oldCompleteURI);
        }
        this.packageURI2completeURI.put(packageURI, newCompleteURI);
        Set<String> packageURIs = this.completeURI2packageURIs.get(newCompleteURI);
        if (packageURIs == null) {
            packageURIs = new HashSet<String>();
            this.completeURI2packageURIs.put(newCompleteURI, packageURIs);
        }
        packageURIs.add(packageURI);
    }

    @Nullable
    public CompletePackageInternal getCompletePackage(@NonNull Package pivotPackage) {
        String packageURI = pivotPackage.getURI();
        if (packageURI == null) {
            return null;
        }
        String completeURI = this.getCompleteURI(packageURI);
        return completeURI != null ? this.completeURI2completePackage.get(completeURI) : null;
    }

    @Nullable
    public CompletePackageInternal getCompletePackage(@Nullable String completeURI) {
        return completeURI != null ? this.completeURI2completePackage.get(completeURI) : null;
    }

    @Nullable
    public CompletePackageInternal getCompletePackageByURI(@NonNull String packageURI) {
        int lastIndex = packageURI.lastIndexOf("#/");
        if (lastIndex > 0) {
            String substring;
            packageURI = substring = packageURI.substring(0, lastIndex);
        }
        String completeURI = this.getCompleteURI(packageURI);
        return this.completeURI2completePackage.get(completeURI);
    }

    @Nullable
    public String getCompleteURI(@Nullable String packageURI) {
        String completeURI = this.packageURI2completeURI.get(packageURI);
        if (completeURI != null) {
            return completeURI;
        }
        return packageURI;
    }

    public void removeCompletePackage(String completeURI) {
        this.completeURI2completePackage.remove(completeURI);
    }
}

