/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.CompletePackage;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.internal.CompletePackageImpl;
import org.eclipse.ocl.pivot.internal.complete.AbstractCompletePackages;
import org.eclipse.ocl.pivot.internal.complete.CompleteModelInternal;
import org.eclipse.ocl.pivot.internal.complete.CompletePackageInternal;

public class NestedCompletePackages
extends AbstractCompletePackages {
    private static final long serialVersionUID = 1L;

    public NestedCompletePackages(@NonNull CompletePackageImpl owner) {
        super(CompletePackage.class, owner, 6, 8);
        this.doRefreshNestedPackages();
    }

    @Override
    @NonNull
    public CompletePackageInternal createCompletePackage(@NonNull Package partialPackage) {
        CompletePackageInternal completePackage = (CompletePackageInternal)PivotFactory.eINSTANCE.createCompletePackage();
        completePackage.init(partialPackage.getName(), partialPackage.getNsPrefix(), partialPackage.getURI());
        return completePackage;
    }

    protected void doRefreshNestedPackages() {
        for (Package partialPackage : this.getPartialPackages()) {
            if (partialPackage == null) continue;
            this.getOwnedCompletePackage(partialPackage);
        }
    }

    @Override
    @NonNull
    public CompleteModelInternal getCompleteModel() {
        return this.getCompletePackage().getCompleteModel();
    }

    @NonNull
    public CompletePackageInternal getCompletePackage() {
        return (CompletePackageInternal)this.owner;
    }

    @Override
    @NonNull
    public CompletePackageInternal getOwnedCompletePackage(@NonNull Package partialPackage) {
        CompletePackageInternal completePackage = null;
        String uri = partialPackage.getURI();
        if (uri != null) {
            completePackage = this.getCompleteModel().getCompletePackageByURI(uri);
        }
        if (completePackage == null) {
            String name = partialPackage.getName();
            completePackage = super.getOwnedCompletePackage(name);
        }
        if (completePackage == null) {
            completePackage = this.createCompletePackage(partialPackage);
            this.add(completePackage);
        }
        completePackage.getPartialPackages().add(partialPackage);
        return completePackage;
    }

    @Override
    @NonNull
    protected Iterable<Package> getPartialPackages() {
        return this.getCompletePackage().getPartialPackages().getNestedPartialPackages();
    }
}

