/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.complete;

import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;

public class PartialProperties
implements Iterable<Property> {
    private boolean isResolved = false;
    @Nullable
    private Property resolution = null;
    @Nullable
    private List<Property> partials = null;
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;

    public PartialProperties(@NonNull EnvironmentFactoryInternal environmentFactory) {
        this.environmentFactory = environmentFactory;
    }

    public synchronized void didAddProperty(@NonNull Property pivotProperty) {
        List<Property> partials2 = this.partials;
        if (partials2 == null) {
            if (this.resolution == null) {
                this.resolution = pivotProperty;
                this.isResolved = true;
            } else {
                this.partials = partials2 = new ArrayList<Property>();
                partials2.add(this.resolution);
                if (this.resolution != pivotProperty) {
                    partials2.add(pivotProperty);
                }
                this.resolution = null;
                this.isResolved = false;
            }
        } else if (partials2.isEmpty()) {
            if (this.resolution == null) {
                this.resolution = pivotProperty;
                this.isResolved = true;
            } else {
                partials2.add(this.resolution);
                if (this.resolution != pivotProperty) {
                    partials2.add(pivotProperty);
                }
                this.resolution = null;
                this.isResolved = false;
            }
        } else {
            if (!partials2.contains(pivotProperty)) {
                partials2.add(pivotProperty);
            }
            this.resolution = null;
            this.isResolved = false;
        }
    }

    public boolean didRemoveProperty(@NonNull Property pivotProperty) {
        this.remove(pivotProperty);
        return this.isEmpty();
    }

    @Nullable
    public synchronized Property get() {
        if (this.isResolved) {
            return this.resolution;
        }
        this.resolve();
        if (this.isResolved) {
            return this.resolution;
        }
        ArrayList<Property> values = new ArrayList<Property>(this.partials);
        HashMap<Type, Property> primaryProperties = new HashMap<Type, Property>();
        for (Property property : values) {
            Type domainType;
            Class owningType;
            if (property == null || (owningType = property.getOwningClass()) == null || primaryProperties.containsKey(domainType = this.environmentFactory.getMetamodelManager().getPrimaryType(owningType))) continue;
            primaryProperties.put(domainType, property);
        }
        if (primaryProperties.size() == 1) {
            this.resolution = (Property)primaryProperties.values().iterator().next();
            this.isResolved = true;
            return this.resolution;
        }
        this.isResolved = true;
        this.resolution = null;
        return this.resolution;
    }

    public synchronized boolean isEmpty() {
        if (this.resolution != null) {
            return false;
        }
        List<Property> partials2 = this.partials;
        if (partials2 == null) {
            return true;
        }
        return partials2.size() <= 0;
    }

    @Override
    @NonNull
    public Iterator<Property> iterator() {
        if (!this.isResolved) {
            this.resolve();
        }
        if (this.resolution != null) {
            return Iterators.singletonIterator((Object)this.resolution);
        }
        if (this.partials != null) {
            return this.partials.iterator();
        }
        return Iterators.emptyIterator();
    }

    public synchronized void remove(@NonNull Property pivotProperty) {
        if (pivotProperty == this.resolution) {
            this.resolution = null;
        }
        if (this.partials != null) {
            this.partials.remove(pivotProperty);
        }
    }

    private void resolve() {
        assert (!this.isResolved);
        List<Property> partials2 = this.partials;
        if (partials2 == null) {
            return;
        }
        int size = partials2.size();
        if (size <= 0) {
            return;
        }
        if (size == 1) {
            this.isResolved = true;
            this.resolution = partials2.get(0);
        }
        ArrayList<Property> values = new ArrayList<Property>(this.partials);
        int i = 0;
        while (i < values.size() - 1) {
            boolean iRemoved = false;
            Property iValue = (Property)values.get(i);
            int j = i + 1;
            while (j < values.size()) {
                java.lang.Class<?> iClass = iValue.getClass();
                Property jValue = (Property)values.get(j);
                java.lang.Class<?> jClass = jValue.getClass();
                int verdict = 0;
                for (java.lang.Class<?> key : EnvironmentView.getDisambiguatorKeys()) {
                    if (!key.isAssignableFrom(iClass) || !key.isAssignableFrom(jClass)) continue;
                    List<Comparator<Object>> disambiguators = EnvironmentView.getDisambiguators(key);
                    if (disambiguators != null) {
                        for (Comparator<Object> comparator : disambiguators) {
                            verdict = comparator instanceof EnvironmentView.Disambiguator ? ((EnvironmentView.Disambiguator)comparator).compare(this.environmentFactory, iValue, jValue) : comparator.compare(iValue, jValue);
                            if (verdict != 0) break;
                        }
                    }
                    if (verdict != 0) break;
                }
                if (verdict == 0) {
                    ++j;
                    continue;
                }
                if (verdict < 0) {
                    values.remove(i);
                    iRemoved = true;
                    break;
                }
                values.remove(j);
            }
            if (iRemoved) continue;
            ++i;
        }
        if (values.size() == 1) {
            this.resolution = (Property)values.get(0);
            this.isResolved = true;
            return;
        }
    }

    public String toString() {
        if (this.resolution != null) {
            return this.resolution.toString();
        }
        List<Property> partials2 = this.partials;
        if (partials2 == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (Property dProperty : partials2) {
            if (s.length() > 0) {
                s.append(",");
            }
            s.append(dProperty.toString());
        }
        return s.toString();
    }
}

