/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.context;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.InvalidLiteralExp;
import org.eclipse.ocl.pivot.PivotFactory;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.context.Base2ASConversion;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.resource.CSResource;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.ParserContext;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.Pivotable;
import org.eclipse.ocl.pivot.utilities.StringUtil;

public abstract class AbstractParserContext
implements ParserContext {
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    protected final URI uri;
    @Nullable
    protected Element rootElement = null;

    protected AbstractParserContext(@NonNull EnvironmentFactory environmentFactory, @Nullable URI uri) {
        this.environmentFactory = (EnvironmentFactoryInternal)environmentFactory;
        this.uri = uri != null ? uri : ClassUtil.nonNullEMF(URI.createURI((String)(String.valueOf(EcoreUtil.generateUUID()) + ".essentialocl")));
    }

    @Override
    @NonNull
    public CSResource createBaseResource(@NonNull String expression) throws IOException, ParserException {
        try (URIConverter.ReadableInputStream inputStream = new URIConverter.ReadableInputStream(expression, "UTF-8");){
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(this.uri);
            if (resource == null) {
                throw new ParserException("Failed to load '" + this.uri + "'" + this.getDoSetupMessage());
            }
            if (!(resource instanceof CSResource)) {
                throw new ParserException("Failed to create Xtext resource for '" + this.uri + "'" + this.getDoSetupMessage());
            }
            CSResource baseResource = (CSResource)resource;
            this.getEnvironmentFactory().adapt((Notifier)resource);
            baseResource.setParserContext(this);
            baseResource.load((InputStream)inputStream, null);
            CSResource cSResource = baseResource;
            return cSResource;
        }
    }

    @Override
    @Nullable
    public Type getClassContext() {
        return null;
    }

    @NonNull
    protected String getDoSetupMessage() {
        if (EcorePlugin.IS_ECLIPSE_RUNNING) {
            return "";
        }
        String doSetup = this.environmentFactory.getDoSetupName(this.uri);
        if (doSetup == null) {
            return "";
        }
        return "\n\tMake sure " + doSetup + " has been called.";
    }

    @NonNull
    public EnvironmentFactoryInternal getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Nullable
    public Type getInstanceContext() {
        return null;
    }

    @Override
    @NonNull
    public ExpressionInOCL getExpression(@NonNull CSResource resource) throws ParserException {
        Element pivotElement;
        EList contents = resource.getContents();
        int size = contents.size();
        if (size < 1) {
            throw new ParserException("Missing parse returns");
        }
        if (size > 1) {
            throw new ParserException("Extra parse returns");
        }
        EObject csObject = (EObject)contents.get(0);
        if (csObject instanceof Pivotable && (pivotElement = ((Pivotable)csObject).getPivot()) instanceof ExpressionInOCL) {
            return (ExpressionInOCL)pivotElement;
        }
        throw new ParserException("Non-expression ignored");
    }

    @Override
    @NonNull
    public PivotMetamodelManager getMetamodelManager() {
        return this.environmentFactory.getMetamodelManager();
    }

    @Override
    @Nullable
    public Element getRootElement() {
        return this.rootElement;
    }

    @Override
    public void initialize(@NonNull Base2ASConversion conversion, @NonNull ExpressionInOCL expression) {
    }

    @Override
    @NonNull
    public ExpressionInOCL parse(@Nullable EObject owner, @NonNull String expression) throws ParserException {
        CSResource resource = null;
        try {
            resource = this.createBaseResource(expression);
            String childName = owner instanceof Nameable ? ((Nameable)owner).getName() : "<unknown>";
            EObject eContainer = owner != null ? owner.eContainer() : null;
            String parentName = eContainer instanceof Nameable ? ((Nameable)eContainer).getName() : "<unknown>";
            PivotUtil.checkResourceErrors(StringUtil.bind(PivotMessagesInternal.ValidationConstraintIsInvalid_ERROR_, parentName, childName, expression.trim()), resource);
            ExpressionInOCL expressionInOCL = this.getExpression(resource);
            expressionInOCL.setBody(expression);
            ExpressionInOCL expressionInOCL2 = expressionInOCL;
            return expressionInOCL2;
        }
        catch (IOException e) {
            ExpressionInOCL specification = PivotFactory.eINSTANCE.createExpressionInOCL();
            InvalidLiteralExp invalidValueBody = this.getMetamodelManager().createInvalidExpression();
            PivotUtil.setBody(specification, invalidValueBody, null);
            ExpressionInOCL expressionInOCL = specification;
            return expressionInOCL;
        }
        finally {
            if (resource != null) {
                resource.unload();
                ResourceSet resourceSet = resource.getResourceSet();
                if (resourceSet != null) {
                    resourceSet.getResources().remove((Object)resource);
                }
                EnvironmentFactoryAdapter.disposeAll(resource);
            }
        }
    }

    @Override
    public void setRootElement(@Nullable Element rootElement) {
        this.rootElement = rootElement;
    }
}

