/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.context;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.internal.context.Base2ASConversion;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;

public class OperationContext
extends ClassContext {
    @NonNull
    private final Operation operation;
    @Nullable
    private final String resultVariableName;

    public OperationContext(@NonNull EnvironmentFactory environmentFactory, @Nullable URI uri, @NonNull Operation operation, @Nullable String resultVariableName) {
        super(environmentFactory, uri, ClassUtil.nonNullModel(operation.getOwningClass()), null);
        this.operation = operation;
        this.resultVariableName = resultVariableName;
    }

    @Override
    public void initialize(@NonNull Base2ASConversion conversion, @NonNull ExpressionInOCL expression) {
        super.initialize(conversion, expression);
        conversion.setParameterVariables(expression, ClassUtil.nonNullEMF(this.operation.getOwnedParameters()));
        String resultVariableName2 = this.resultVariableName;
        if (resultVariableName2 != null) {
            conversion.setResultVariable(expression, this.operation, resultVariableName2);
        }
    }

    @NonNull
    public Operation getOperation() {
        return this.operation;
    }
}

