/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.internal.delegate.DelegateEPackageAdapter;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class DelegateResourceAdapter
extends AdapterImpl {
    @NonNull
    public static DelegateResourceAdapter getAdapter(@NonNull Resource resource) {
        DelegateResourceAdapter adapter = (DelegateResourceAdapter)EcoreUtil.getAdapter((List)resource.eAdapters(), DelegateResourceAdapter.class);
        if (adapter == null) {
            adapter = new DelegateResourceAdapter();
            resource.eAdapters().add((Object)adapter);
        }
        return adapter;
    }

    public Resource getTarget() {
        return (Resource)super.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        return type == DelegateResourceAdapter.class;
    }

    public void notifyChanged(Notification notification) {
        int featureID = notification.getFeatureID(Resource.class);
        int eventType = notification.getEventType();
        if (featureID == 4) {
            if (eventType == 1) {
                Resource resource = this.getTarget();
                EList contents = ClassUtil.nonNullEMF(resource.getContents());
                if (notification.getNewBooleanValue()) {
                    EPackage.Registry packageRegistry = resource.getResourceSet().getPackageRegistry();
                    this.installPackages(ClassUtil.nonNullEMF(packageRegistry), (List<? extends EObject>)contents);
                }
            }
        } else if (featureID == 2) {
            if (eventType == 4) {
                EObject oldValue = (EObject)ClassUtil.nonNullEMF(notification.getOldValue());
                this.unloadDelegate(oldValue);
            } else if (eventType == 6) {
                List oldValues = ClassUtil.nonNullEMF((List)notification.getOldValue());
                this.unloadDelegates(oldValues);
            }
        }
    }

    protected void installPackages(@NonNull EPackage.Registry packageRegistry, @NonNull List<? extends EObject> contents) {
        for (EObject eObject : contents) {
            if (!(eObject instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)eObject;
            packageRegistry.put((Object)ePackage.getNsURI(), (Object)ePackage);
            this.installPackages(packageRegistry, (List)ClassUtil.nonNullEMF(ePackage.getESubpackages()));
        }
    }

    public void setTarget(Notifier newTarget) {
        Resource resource = (Resource)newTarget;
        super.setTarget((Notifier)resource);
    }

    protected void unloadDelegate(@NonNull EObject eObject) {
        if (eObject instanceof EPackage) {
            EPackage ePackage = (EPackage)eObject;
            DelegateEPackageAdapter adapter = DelegateEPackageAdapter.findAdapter(ePackage);
            if (adapter != null) {
                adapter.unloadDelegates();
            }
            this.unloadDelegates((List)ClassUtil.nonNullEMF(ePackage.getESubpackages()));
        }
    }

    protected void unloadDelegates(@NonNull List<? extends EObject> contents) {
        for (EObject eObject : contents) {
            if (eObject == null) continue;
            this.unloadDelegate(eObject);
        }
    }
}

