/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.internal.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.pivot.internal.delegate.DelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.SemanticException;

public class InvocationBehavior
extends AbstractDelegatedBehavior<EOperation, EOperation.Internal.InvocationDelegate.Factory.Registry, EOperation.Internal.InvocationDelegate.Factory> {
    @NonNull
    public static final InvocationBehavior INSTANCE = new InvocationBehavior();
    @NonNull
    public static final String BODY_CONSTRAINT_KEY = "body";
    @NonNull
    public static final String NAME = "invocationDelegates";

    @Override
    @Nullable
    public EOperation.Internal.InvocationDelegate.Factory getDefaultFactory() {
        return EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE.getFactory(this.getName());
    }

    @Override
    @NonNull
    public EOperation.Internal.InvocationDelegate.Factory.Registry getDefaultRegistry() {
        return ClassUtil.nonNullEMF(EOperation.Internal.InvocationDelegate.Factory.Registry.INSTANCE);
    }

    @Override
    @NonNull
    public EPackage getEPackage(@NonNull EOperation eOperation) {
        return ClassUtil.nonNullEMF(eOperation.getEContainingClass().getEPackage());
    }

    @Override
    @Nullable
    public EOperation.Internal.InvocationDelegate.Factory getFactory(@NonNull DelegateDomain delegateDomain, @NonNull EOperation eOperation) {
        EOperation.Internal.InvocationDelegate.Factory.Registry registry = (EOperation.Internal.InvocationDelegate.Factory.Registry)DelegateResourceSetAdapter.getRegistry((EModelElement)eOperation, this.getRegistryClass(), (Object)this.getDefaultRegistry());
        return registry != null ? registry.getFactory(delegateDomain.getURI()) : null;
    }

    @Override
    @NonNull
    public Class<EOperation.Internal.InvocationDelegate.Factory> getFactoryClass() {
        return EOperation.Internal.InvocationDelegate.Factory.class;
    }

    @Override
    @NonNull
    public String getName() {
        return NAME;
    }

    @NonNull
    public ExpressionInOCL getQueryOrThrow(@NonNull MetamodelManager metamodelManager, @NonNull Operation operation) throws OCLDelegateException {
        LanguageExpression specification = operation.getBodyExpression();
        if (specification == null) {
            throw new OCLDelegateException(new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, NameUtil.qualifiedNameFor(operation), BODY_CONSTRAINT_KEY));
        }
        try {
            return metamodelManager.parseSpecification(specification);
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e);
        }
    }

    @Override
    @NonNull
    public Class<EOperation.Internal.InvocationDelegate.Factory.Registry> getRegistryClass() {
        return EOperation.Internal.InvocationDelegate.Factory.Registry.class;
    }
}

