/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationException;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.context.EInvocationContext;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.Query;
import org.eclipse.ocl.pivot.utilities.SemanticException;
import org.eclipse.ocl.pivot.utilities.StringUtil;

public class OCLQueryDelegate
implements QueryDelegate {
    @NonNull
    protected OCLDelegateDomain delegateDomain;
    @NonNull
    protected final EInvocationContext parserContext;
    @NonNull
    protected final String expression;
    private ExpressionInOCL specification = null;

    public OCLQueryDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EClassifier context, @Nullable Map<String, EClassifier> parameters, @NonNull String expression) {
        this.delegateDomain = delegateDomain;
        this.parserContext = new EInvocationContext(delegateDomain.getOCL().getEnvironmentFactory(), null, context, parameters);
        this.expression = expression;
    }

    @Nullable
    protected Object evaluate(@NonNull Query query, @Nullable Object target) {
        return query.evaluateEcore(target);
    }

    public Object execute(@Nullable Object target, Map<String, ?> arguments) throws InvocationTargetException {
        Map<String, Object> nonNullArguments = arguments != null ? arguments : Collections.emptyMap();
        try {
            int argCount;
            if (this.specification == null) {
                this.prepare();
            }
            ExpressionInOCL nonNullSpecification = this.specification;
            OCL ocl = this.delegateDomain.getOCL();
            IdResolver idResolver = ocl.getIdResolver();
            Object targetValue = idResolver.boxedValueOf(target);
            Class targetType = idResolver.getStaticTypeOf(targetValue);
            Type requiredType = nonNullSpecification.getOwnedContext().getType();
            if (requiredType == null || !targetType.conformsTo(ocl.getStandardLibrary(), requiredType)) {
                String message = StringUtil.bind(PivotMessagesInternal.WrongContextClassifier_ERROR_, targetType, requiredType);
                throw new OCLDelegateException(new SemanticException(message));
            }
            List<Variable> parameterVariables = nonNullSpecification.getOwnedParameters();
            int n = argCount = arguments != null ? arguments.size() : 0;
            if (parameterVariables.size() != argCount) {
                String message = StringUtil.bind(PivotMessagesInternal.MismatchedArgumentCount_ERROR_, argCount, parameterVariables.size());
                throw new OCLDelegateException(new SemanticException(message));
            }
            Query query = ocl.createQuery(nonNullSpecification);
            EvaluationEnvironment env = query.getEvaluationEnvironment(target);
            for (Variable parameterVariable : parameterVariables) {
                String name = parameterVariable.getName();
                Object object = nonNullArguments.get(name);
                if (object == null && !nonNullArguments.containsKey(name)) {
                    String message = StringUtil.bind(PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, nonNullSpecification.getBody());
                    throw new OCLDelegateException(new SemanticException(message));
                }
                Object value = idResolver.boxedValueOf(object);
                targetType = idResolver.getStaticTypeOf(value);
                requiredType = ClassUtil.nonNullModel(parameterVariable.getType());
                if (!targetType.conformsTo(ocl.getStandardLibrary(), requiredType)) {
                    String message = StringUtil.bind(PivotMessagesInternal.MismatchedArgumentType_ERROR_, name, targetType, requiredType);
                    throw new OCLDelegateException(new SemanticException(message));
                }
                env.add(parameterVariable, value);
            }
            Object result = this.evaluate(query, target);
            return idResolver.ecoreValueOf(null, result);
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (EvaluationException e) {
            String message = StringUtil.bind(PivotMessagesInternal.EvaluationResultIsInvalid_ERROR_, this.specification.getBody());
            throw new InvocationTargetException(new EvaluationException(message));
        }
        catch (WrappedException e) {
            throw new InvocationTargetException(e.getCause());
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public void prepare() throws InvocationTargetException {
        try {
            this.specification = this.parserContext.parse(this.parserContext.getClassContext(), this.expression);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public String toString() {
        OCLExpression bodyExpression = this.specification.getOwnedBody();
        if (bodyExpression != null) {
            return "<" + this.delegateDomain.getURI() + ":query> " + bodyExpression;
        }
        return "<" + this.delegateDomain.getURI() + ":query> " + this.specification.getBody();
    }
}

