/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.delegate.DelegateResourceSetAdapter;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.pivot.internal.delegate.DelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.pivot.internal.delegate.ValidationDelegate;
import org.eclipse.ocl.pivot.internal.ecore.es2as.Ecore2AS;
import org.eclipse.ocl.pivot.internal.manager.MetamodelManagerInternal;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.SemanticException;

public class ValidationBehavior
extends AbstractDelegatedBehavior<EClassifier, EValidator.ValidationDelegate.Registry, ValidationDelegate.Factory> {
    @NonNull
    public static final ValidationBehavior INSTANCE = new ValidationBehavior();
    @NonNull
    public static final String NAME = "validationDelegates";

    public Constraint getConstraint(@NonNull MetamodelManager metamodelManager, @NonNull EClassifier eClassifier, @NonNull String constraintName) throws OCLDelegateException {
        Constraint constraint;
        Resource ecoreMetamodel = ClassUtil.nonNullEMF(eClassifier.eResource());
        Ecore2AS ecore2as = Ecore2AS.getAdapter(ecoreMetamodel, (EnvironmentFactoryInternal)metamodelManager.getEnvironmentFactory());
        Type type = ecore2as.getCreated(Type.class, (EObject)eClassifier);
        if (type != null && (constraint = NameUtil.getNameable(((MetamodelManagerInternal)metamodelManager).getAllInvariants(type), constraintName)) != null) {
            return constraint;
        }
        throw new OCLDelegateException(new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, type, "constraint"));
    }

    @Override
    @Nullable
    public ValidationDelegate.Factory getDefaultFactory() {
        return (ValidationDelegate.Factory)ValidationDelegate.Factory.Registry.INSTANCE.getValidationDelegate(this.getName());
    }

    @Override
    @NonNull
    public EValidator.ValidationDelegate.Registry getDefaultRegistry() {
        return ClassUtil.nonNullEMF(ValidationDelegate.Factory.Registry.INSTANCE);
    }

    @Override
    @NonNull
    public EPackage getEPackage(@NonNull EClassifier eClassifier) {
        return ClassUtil.nonNullEMF(eClassifier.getEPackage());
    }

    @Override
    @Nullable
    public ValidationDelegate.Factory getFactory(@NonNull DelegateDomain delegateDomain, @NonNull EClassifier eClassifier) {
        EValidator.ValidationDelegate.Registry registry = (EValidator.ValidationDelegate.Registry)DelegateResourceSetAdapter.getRegistry((EModelElement)eClassifier, EValidator.ValidationDelegate.Registry.class, (Object)this.getDefaultRegistry());
        if (registry == null) {
            return null;
        }
        String delegateURI = delegateDomain.getURI();
        EValidator.ValidationDelegate validationDelegate = registry.getValidationDelegate(delegateURI);
        return (ValidationDelegate.Factory)validationDelegate;
    }

    @Override
    @NonNull
    public Class<ValidationDelegate.Factory> getFactoryClass() {
        return ValidationDelegate.Factory.class;
    }

    @Override
    @NonNull
    public String getName() {
        return NAME;
    }

    @NonNull
    public ExpressionInOCL getQueryOrThrow(@NonNull MetamodelManager metamodelManager, @NonNull Constraint constraint) throws OCLDelegateException {
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (specification == null) {
            throw new OCLDelegateException(new SemanticException(PivotMessagesInternal.MissingSpecificationBody_ERROR_, constraint, "constraint"));
        }
        try {
            return metamodelManager.parseSpecification(specification);
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e);
        }
    }

    @Override
    @NonNull
    public Class<ValidationDelegate.Factory.Registry> getRegistryClass() {
        return ValidationDelegate.Factory.Registry.class;
    }
}

