/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore;

import java.util.List;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.internal.evaluation.OCLEvaluationVisitor;
import org.eclipse.ocl.pivot.library.AbstractOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.MetamodelManager;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class EObjectOperation
extends AbstractOperation {
    @NonNull
    protected final Operation operation;
    @NonNull
    protected final EOperation eFeature;
    @NonNull
    protected final ExpressionInOCL specification;

    public EObjectOperation(@NonNull Operation operation, @NonNull EOperation eFeature, @NonNull ExpressionInOCL specification) {
        this.operation = operation;
        this.eFeature = eFeature;
        this.specification = specification;
    }

    @Override
    @Nullable
    public Object dispatch(@NonNull Evaluator evaluator, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        if (this.specification.getOwnedBody() == null) {
            try {
                EvaluationVisitor evaluationVisitor = (EvaluationVisitor)evaluator;
                MetamodelManager metamodelManager = evaluationVisitor.getMetamodelManager();
                metamodelManager.parseSpecification(this.specification);
            }
            catch (ParserException e) {
                throw new InvalidValueException(e, "parse failure", evaluator.getEvaluationEnvironment(), sourceValue, callExp);
            }
        }
        ExpressionInOCL query = this.specification;
        List<OCLExpression> arguments = callExp.getOwnedArguments();
        Object[] argumentValues = new Object[arguments.size()];
        int i = 0;
        while (i < arguments.size()) {
            OCLExpression argument = arguments.get(i);
            assert (argument != null);
            argumentValues[i] = evaluator.evaluate(argument);
            ++i;
        }
        Evaluator nestedEvaluator = evaluator instanceof OCLEvaluationVisitor ? ((OCLEvaluationVisitor)evaluator).createNestedUndecoratedEvaluator(query) : evaluator.createNestedEvaluator();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedEvaluator.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(query.getOwnedContext()), sourceValue);
        List<Variable> parameterVariables = query.getOwnedParameters();
        int iMax = Math.min(parameterVariables.size(), argumentValues.length);
        int i2 = 0;
        while (i2 < iMax) {
            nestedEvaluationEnvironment.add(ClassUtil.nonNullModel(parameterVariables.get(i2)), argumentValues[i2]);
            ++i2;
        }
        try {
            Object object = nestedEvaluator.evaluate(ClassUtil.nonNullPivot(query.getOwnedBody()));
            return object;
        }
        finally {
            nestedEvaluator.dispose();
        }
    }
}

