/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteEnvironment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.StandardLibrary;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.EvaluationLogger;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.complete.CompleteEnvironmentInternal;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class AbstractEvaluationVisitor
extends AbstractExtendingVisitor<Object, Object>
implements EvaluationVisitor {
    private static final int DEFAULT_REGEX_CACHE_LIMIT = 16;
    private static final float DEFAULT_REGEX_CACHE_LOAD_FACTOR = 0.75f;
    @NonNull
    protected final EnvironmentFactoryInternal environmentFactory;
    @NonNull
    protected final EvaluationEnvironment evaluationEnvironment;
    @NonNull
    protected final PivotMetamodelManager metamodelManager;
    @NonNull
    protected final CompleteEnvironmentInternal completeEnvironment;
    @NonNull
    protected final StandardLibraryInternal standardLibrary;
    @NonNull
    protected final ModelManager modelManager;
    @NonNull
    protected EvaluationVisitor undecoratedVisitor;
    private Map<String, Pattern> regexPatterns = null;
    private EvaluationLogger logger = new EvaluationLogger(){

        @Override
        public void append(@NonNull String message) {
            System.out.append(message);
        }
    };
    @Nullable
    protected Monitor monitor = null;

    protected AbstractEvaluationVisitor(@NonNull EvaluationEnvironment evalEnv) {
        super(Object.class);
        this.environmentFactory = (EnvironmentFactoryInternal)evalEnv.getEnvironmentFactory();
        this.evaluationEnvironment = evalEnv;
        this.metamodelManager = this.environmentFactory.getMetamodelManager();
        this.completeEnvironment = this.metamodelManager.getCompleteEnvironment();
        this.standardLibrary = this.completeEnvironment.getOwnedStandardLibrary();
        this.modelManager = evalEnv.getModelManager();
        this.undecoratedVisitor = this;
    }

    @NonNull
    protected Map<String, Pattern> createRegexCache() {
        return new LinkedHashMap<String, Pattern>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Pattern> eldest) {
                return this.size() > 16;
            }
        };
    }

    @Override
    @NonNull
    public CompleteEnvironment getCompleteEnvironment() {
        return this.completeEnvironment;
    }

    @Override
    @NonNull
    public EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    @NonNull
    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluationEnvironment;
    }

    @Override
    @NonNull
    public IdResolver getIdResolver() {
        return this.environmentFactory.getIdResolver();
    }

    @Override
    @Nullable
    public EvaluationLogger getLogger() {
        return this.logger;
    }

    @Override
    @NonNull
    public PivotMetamodelManager getMetamodelManager() {
        return this.metamodelManager;
    }

    @Override
    @NonNull
    public ModelManager getModelManager() {
        return this.modelManager;
    }

    @Override
    @Nullable
    public Monitor getMonitor() {
        return this.monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Pattern getRegexPattern(@NonNull String regex) {
        Object object;
        if (this.regexPatterns == null) {
            object = this;
            synchronized (object) {
                if (this.regexPatterns == null) {
                    this.regexPatterns = this.createRegexCache();
                }
            }
        }
        object = this.regexPatterns;
        synchronized (object) {
            Pattern pattern = this.regexPatterns.get(regex);
            if (pattern == null) {
                pattern = Pattern.compile(regex);
                assert (pattern != null);
                this.regexPatterns.put(regex, pattern);
            }
            return pattern;
        }
    }

    @Override
    public int getDiagnosticSeverity(int severityPreference, @Nullable Object resultValue) {
        if (resultValue == null) {
            return 4;
        }
        if (resultValue instanceof InvalidValueException) {
            return 8;
        }
        return severityPreference;
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        StatusCodes.Severity severity = this.environmentFactory.getSeverity(validationKey);
        return severity != null ? severity.getStatusCode() : 2;
    }

    @Override
    @NonNull
    public StandardLibrary getStandardLibrary() {
        return this.standardLibrary;
    }

    @Override
    @NonNull
    public Class getStaticTypeOf(@Nullable Object value) {
        return this.environmentFactory.getIdResolver().getStaticTypeOf(value);
    }

    @Override
    @NonNull
    public Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        return this.environmentFactory.getIdResolver().getStaticTypeOf(value, values);
    }

    @Override
    @NonNull
    public Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        return this.environmentFactory.getIdResolver().getStaticTypeOf(value, values);
    }

    @NonNull
    protected final EvaluationVisitor getUndecoratedVisitor() {
        return this.undecoratedVisitor;
    }

    @Override
    public boolean isCanceled() {
        return this.monitor != null && this.monitor.isCanceled();
    }

    @Override
    public void setCanceled(boolean isCanceled) {
        if (this.monitor != null) {
            this.monitor.setCanceled(isCanceled);
        } else if (isCanceled) {
            this.monitor = new BasicMonitor();
            this.monitor.setCanceled(isCanceled);
        }
    }

    @Override
    public void setLogger(@Nullable EvaluationLogger logger) {
        this.logger = logger;
    }

    @Override
    public void setMonitor(@Nullable Monitor monitor) {
        this.monitor = monitor;
    }

    @Override
    public void setUndecoratedVisitor(@NonNull EvaluationVisitor evaluationVisitor) {
        this.undecoratedVisitor = evaluationVisitor;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (evaluation environment: ");
        result.append(this.getEvaluationEnvironment());
        result.append(')');
        return result.toString();
    }

    @Override
    public Object visitConstraint(@NonNull Constraint constraint) {
        LanguageExpression specification = constraint.getOwnedSpecification();
        if (!(specification instanceof ExpressionInOCL)) {
            return null;
        }
        OCLExpression body = ((ExpressionInOCL)specification).getOwnedBody();
        if (body == null) {
            throw new IllegalArgumentException("constraint has no body expression");
        }
        Object result = body.accept(this.undecoratedVisitor);
        return ValueUtil.asBoolean(result);
    }
}

