/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.internal.evaluation.AbstractCustomizable;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.Option;
import org.eclipse.ocl.pivot.values.InvalidValueException;
import org.eclipse.osgi.util.NLS;

public class BasicEvaluationEnvironment
extends AbstractCustomizable
implements EvaluationEnvironment {
    @NonNull
    protected final EnvironmentFactory environmentFactory;
    @Nullable
    protected final EvaluationEnvironment parent;
    @NonNull
    protected final NamedElement executableObject;
    @NonNull
    protected final ModelManager modelManager;
    @NonNull
    private final Map<TypedElement, Object> variableValues = new HashMap<TypedElement, Object>();

    public BasicEvaluationEnvironment(@NonNull EnvironmentFactory environmentFactory, @NonNull NamedElement executableObject, @NonNull ModelManager modelManager) {
        this.environmentFactory = environmentFactory;
        this.parent = null;
        this.executableObject = executableObject;
        this.modelManager = modelManager;
    }

    public BasicEvaluationEnvironment(@NonNull EvaluationEnvironment parent, @NonNull NamedElement executableObject) {
        this.environmentFactory = parent.getEnvironmentFactory();
        this.parent = parent;
        this.executableObject = executableObject;
        this.modelManager = parent.getModelManager();
    }

    @Override
    public void add(@NonNull TypedElement referredVariable, @Nullable Object value) {
        Object oldValue;
        if (this.variableValues.containsKey(referredVariable) && (oldValue = this.variableValues.get(referredVariable)) != value && (oldValue == null || !oldValue.equals(value))) {
            String message = NLS.bind((String)PivotMessagesInternal.BindingExist_ERROR_, (Object)referredVariable, (Object)oldValue);
            throw new IllegalArgumentException(message);
        }
        this.variableValues.put(referredVariable, value);
    }

    @Override
    public void clear() {
        this.variableValues.clear();
    }

    @Override
    public void dispose() {
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType.isInstance(this)) {
            return (T)this;
        }
        return null;
    }

    @Override
    @NonNull
    public EnvironmentFactory getEnvironmentFactory() {
        return this.environmentFactory;
    }

    @Override
    @NonNull
    public NamedElement getExecutableObject() {
        return this.executableObject;
    }

    @Override
    @NonNull
    public ModelManager getModelManager() {
        return this.modelManager;
    }

    @Override
    @Nullable
    public EvaluationEnvironment getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public <T> T getValue(@NonNull Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            EvaluationEnvironment parent2 = this.parent;
            result = parent2 != null ? parent2.getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }

    @Override
    @Nullable
    public Object getValueOf(@NonNull TypedElement referredVariable) {
        Object object = this.variableValues.get(referredVariable);
        if (object == null && !this.variableValues.containsKey(referredVariable)) {
            EvaluationEnvironment parent2 = this.parent;
            if (parent2 != null) {
                object = parent2.getValueOf(referredVariable);
            } else {
                throw new InvalidValueException("Undefined Variable " + referredVariable, new Object[0]);
            }
        }
        return object;
    }

    @Override
    @NonNull
    public Set<TypedElement> getVariables() {
        return this.variableValues.keySet();
    }

    @Override
    @Nullable
    public Object remove(@NonNull TypedElement referredVariable) {
        return this.variableValues.remove(referredVariable);
    }

    @Override
    public void replace(@NonNull TypedElement referredVariable, @Nullable Object value) {
        this.variableValues.put(referredVariable, value);
    }

    public String toString() {
        return this.variableValues.toString();
    }
}

