/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.AbstractGeneralizedIdImpl;
import org.eclipse.ocl.pivot.internal.ids.SpecializedOperationIdImpl;
import org.eclipse.ocl.pivot.internal.ids.WeakHashMapOfListOfWeakReference4;

public class GeneralizedOperationIdImpl
extends AbstractGeneralizedIdImpl<OperationId>
implements OperationId,
WeakHashMapOfListOfWeakReference4.MatchableId<Integer, String, ParametersId> {
    @NonNull
    protected final TypeId parentId;
    @NonNull
    protected final ParametersId parametersId;

    public GeneralizedOperationIdImpl(@NonNull Integer hashCode, @NonNull TypeId parentId, int templateParameters, @NonNull String name, @NonNull ParametersId parametersId) {
        super(hashCode, templateParameters, name);
        this.parentId = parentId;
        this.parametersId = parametersId;
    }

    @Override
    @Nullable
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitOperationId(this);
    }

    @Override
    @NonNull
    protected OperationId createSpecializedId(@NonNull BindingsId templateBindings) {
        return new SpecializedOperationIdImpl(this, templateBindings);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        StringBuilder s = new StringBuilder();
        if (this.templateParameters > 0) {
            s.append("<" + this.templateParameters + ">");
        }
        s.append(this.parentId);
        s.append("::");
        s.append(this.name);
        s.append(this.parametersId);
        String string2 = s.toString();
        assert (string2 != null);
        return string2;
    }

    @Override
    @NonNull
    public OperationId getGeneralizedId() {
        return this;
    }

    @Override
    @NonNull
    public String getMetaTypeName() {
        return "Operation";
    }

    @Override
    @NonNull
    public ParametersId getParametersId() {
        return this.parametersId;
    }

    @Override
    @NonNull
    public TypeId getParent() {
        return this.parentId;
    }

    @Override
    public boolean matches(@NonNull Integer thoseTemplateParameters, @NonNull String thatName, @NonNull ParametersId thatParametersId) {
        if (this.parametersId != thatParametersId) {
            return false;
        }
        if (this.templateParameters != thoseTemplateParameters) {
            return false;
        }
        return this.name.equals(thatName);
    }
}

