/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.ecore;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteInheritance;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.TupleType;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.PackageId;
import org.eclipse.ocl.pivot.ids.RootPackageId;
import org.eclipse.ocl.pivot.ids.TuplePartId;
import org.eclipse.ocl.pivot.ids.TupleTypeId;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreReflectivePackage;
import org.eclipse.ocl.pivot.internal.library.executor.AbstractIdResolver;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutableStandardLibrary;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorPackage;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;

public class EcoreIdResolver
extends AbstractIdResolver
implements Adapter {
    @NonNull
    private Map<EClassifier, WeakReference<CompleteInheritance>> typeMap = new WeakHashMap<EClassifier, WeakReference<CompleteInheritance>>();

    public EcoreIdResolver(@NonNull Iterable<? extends EObject> roots, @NonNull ExecutorStandardLibrary standardLibrary) {
        super(standardLibrary);
        for (EObject eObject : roots) {
            this.addRoot(eObject);
        }
    }

    @Override
    @NonNull
    protected Package addEPackage(@NonNull EPackage ePackage) {
        String nsURI = ePackage.getNsURI();
        Package asPackage = (Package)this.nsURI2package.get(nsURI);
        if (asPackage == null) {
            PackageId packageId = IdManager.getPackageId(ePackage);
            asPackage = new EcoreReflectivePackage(ePackage, this, packageId);
            this.nsURI2package.put(nsURI, asPackage);
            if (packageId instanceof RootPackageId) {
                this.roots2package.put(((RootPackageId)packageId).getName(), asPackage);
            }
        }
        return asPackage;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    @NonNull
    public synchronized CompleteInheritance getInheritance(@NonNull EClassifier eClassifier) {
        CompleteInheritance type = this.weakGet(this.typeMap, eClassifier);
        if (type == null) {
            Class domainType;
            PackageId packageId;
            Element domainPackage;
            EPackage ePackage = eClassifier.getEPackage();
            assert (ePackage != null);
            ExecutorPackage execPackage = ((ExecutorStandardLibrary)this.standardLibrary).getPackage(ePackage);
            if (execPackage == null && (domainPackage = (packageId = IdManager.getPackageId(ePackage)).accept(this)) instanceof ExecutorPackage) {
                execPackage = (ExecutorPackage)domainPackage;
            }
            if (execPackage != null && (domainType = ((ExecutorPackage)execPackage).getOwnedClass(eClassifier.getName())) != null) {
                type = this.standardLibrary.getInheritance(domainType);
                this.typeMap.put(eClassifier, new WeakReference<CompleteInheritance>(type));
            }
        }
        return ClassUtil.nonNullState(type);
    }

    public Notifier getTarget() {
        return null;
    }

    @Override
    @NonNull
    public synchronized TupleType getTupleType(@NonNull TupleTypeId typeId) {
        return ((ExecutableStandardLibrary)this.standardLibrary).getTupleType(typeId);
    }

    @NonNull
    public TupleType getTupleType(TypedElement ... parts) {
        int iSize = parts.length;
        ArrayList<TuplePartId> partsList = new ArrayList<TuplePartId>(iSize);
        int i = 0;
        while (i < iSize) {
            TypedElement part = parts[i];
            String partName = NameUtil.getSafeName(part);
            partsList.add(IdManager.getTuplePartId(i, partName, part.getTypeId()));
            ++i;
        }
        return this.getTupleType(IdManager.getTupleTypeId("Tuple", partsList));
    }

    @Override
    @NonNull
    public Class getType(@NonNull EClassifier eClassifier) {
        return this.getInheritance(eClassifier).getPivotClass();
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void notifyChanged(Notification notification) {
    }

    public void setTarget(Notifier newTarget) {
    }
}

